#
# $Header: /home/rockware/cvs-main/operator/tcl/opButtons.tcl,v 1.18 1995/03/04 21:44:24 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
# The OpButtonsBoxs is a box of buttons.
# Each buttun is described by a list in the buttons list.
# The buttons list is a list of lists, each sub-list describes a button.
# The buton description lists have the following structure.
#
# Name Directory Command Bitmap-name Active-help-msg Ballon-message
# {Title dir command {bitmap} {ActiveHelp Message} {BalloonHelp Message}}
#
itcl_class OpButtonsBox {
    # no inherit.
    constructor config {
        #
        #  Create a window with the same name as this object
        #
        set class [$this info class]
        ::rename $this $this-tmp-
        ::frame $this -class $class
        ::rename $this $this-win-
        ::rename $this-tmp- $this

        # frame $this -class OpButtonsBox
        set cmd "catch {$this delete}"
        set e <Destroy>
        bind $this $e +[bind [winfo class $this] $e]
        bind $this $e +$cmd
        bind $this <Return> "+$this activate_default"
        bind $this <Enter> "+focus $this"

        set side_val [btn_side]
        set i 0
        foreach b $buttons {
            set bm [lindex $b 3]
            if {$bm != {}} {set bm @[opNameToFile $bm bitmap]}
            frame $this.$i
            button $this.$i.b -text [lindex $b 0] -command "
            set swd \[pwd]
            cd [lindex $b 1]
            [lindex $b 2]
            cd \$swd
            " -bitmap $bm -padx $bpadx -pady $bpady
            ::pack $this.$i.b -expand on -fill both
            ::pack $this.$i -side $side_val -expand on \
                -padx $padx -pady $pady  -ipadx $ipadx -ipady $ipady
            bind $this.$i   <Return> "+$this activate_default"
            bind $this.$i.b <Return> "+$this activate_default"
            # XXX Check if commenting one of (or both) the lines improve the
            # activity of the buttons.
            # opActiveHelpBind $this.$i [lindex $b 4]
            if {[lindex $b 5] != {}} {
                opBalloonHelp $this.$i [lindex $b 5]
            }
            incr i 1
        }
        set after_constructor 1
        pack
    }
    destructor {
        ::rename $this-win- {}
        catch {destroy $this}
    }
    method config config {if $after_constructor pack}

    # pack $widget -side bottom -fill x -padx 5 -pady 5
    # The ButtonsBox should be packed by its owner.
    # current implementation is bad.
    # it destroy all and build the buttons from scratch.
    # foreach i [winfo child $this] { catch { destroy $i }}
    method pack config {
        $this-win- config -relief $relief -borderwidth $borderwidth
        set fill {}
        if {$direction == "ud" || $direction == "du"} {
            set fill x
        }
        set side_val [btn_side]
        if {$default < 0} {
            foreach i [winfo child $this] {
                $i.b config -padx $bpadx -pady $bpady -anchor w
                if {$fill != {}} {
                    ::pack $i -side $side_val -fill $fill \
                        -padx $padx -pady $pady -ipadx $ipadx -ipady $ipady
                } {
                    ::pack $i -side $side_val \
                        -padx $padx -pady $pady -ipadx $ipadx -ipady $ipady
                }
            }
        } {
            if {$padx <= 4 || $pady <= 4} {
                set padx 4
                set pady 4
            }
            foreach i [winfo child $this] {
                $i config -bo 2 -relief flat
                ::pack $i.b -padx $padx -pady $pady
                if {$fill != {}} {
                    ::pack $i -side $side_val -fill $fill \
                        -padx $padx -pady $pady -ipadx $ipadx -ipady $ipady
                } {
                    ::pack $i -side $side_val \
                        -padx $padx -pady $pady -ipadx $ipadx -ipady $ipady
                }
            }
            $this.$default config -relief sunken
        }
    }
    # return the fill direction of the buttons box
    method fill_d {} {
        switch $direction {
            lr {return x}
            rl {return x}
            ud {return y}
            du {return y}
        }
    }
    # return the packing side of the buttons.
    method btn_side {} {
        switch $direction {
            lr {return left}
            rl {return right}
            ud {return top}
            du {return bottom}
        }
    }
    method win {} {return $this}
    method activate_default {} {
        if {$default >= 0} {$this.$default.b invoke}
    }

    # The buttons list with the above described information.
    public buttons {} {if $after_constructor pack}

    # buttons order firections: lr rl ud du
    public direction lr {if $after_constructor pack}
    # packing pad.
    public padx 0 {if $after_constructor pack}
    public pady 0 {if $after_constructor pack}
    public ipadx 0 {if $after_constructor pack}
    public ipady 0 {if $after_constructor pack}
    # button pad.
    public bpadx 6 {if $after_constructor pack}
    public bpady 3 {if $after_constructor pack}
    public default -1 {if $after_constructor pack}
    public relief flat {if $after_constructor pack}
    public borderwidth 0 {if $after_constructor pack}
    protected after_constructor 0
}
