/***********************************************************************
 *
 * Copyright (c) 1994 John F. Sefler.
 * All rights reserved.
 *
 ***********************************************************************
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written
 * agreement is hereby granted, provided the above copyright notice and
 * the following two paragraphs appear in all copies of this software.
 *
 * IN NO EVENT SHALL JOHN F. SEFLER BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF HE HAS
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * JOHN F. SEFLER SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
 * "AS IS" BASIS, AND JOHN F. SEFLER HAS NO OBLIGATION TO PROVIDE
 * MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 **********************************************************************/

/***********************************************************************
 *
 * TITLE:       3D Maze Generator and Ghost Dispatcher
 * FILE:        maze.c
 * PURPOSE:     This file contains the prototypes for C functions called
 *              from within a tcl/tk script.  This header file should be
 *              included in the TkAppInit.c file.
 *
 * AUTHOR:      John F. Sefler
 * DATE:        FALL 1994
 *
 **********************************************************************/


#include <tcl.h>

extern int NewMaze(ClientData clientData, Tcl_Interp *interp,
		   int argc, char **argv);
extern int AddGhost(ClientData clientData, Tcl_Interp *interp,
		    int argc, char **argv);
extern int AdvanceGhostsOneStep(ClientData clientData, Tcl_Interp *interp,
		    int argc, char **argv);
