#
# Copyright (c) 1995 Sean Halliday
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
#
# IN NO EVENT SHALL SEAN HALLIDAY BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SEAN HALLIDAY
# HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# SEAN HALLIDAY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND SEAN HALLIDAY HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
#
# halliday@BanffCentre.AB.CA or halliday@cs.ualberta.ca

set theParent "kjadlkjflajdf"

proc get_widget_value {w v} {
  global theParent
  set RET ""
  set A [catch "$w configure -$v" err]
  if {$A == 1 && [lindex $err 0] == "-$v"} {
    set A 0
    set list $err
  } elseif {$A == 0} {set list [$w configure -$v]}
  if {$A == 0} {
    set val [lindex $list 4]
    set val [try_sub $val $theParent]
    if {[llength $val] != 1} {return \{$val\}}
    return $val
  }
  return {}
}

proc try_sub {v p} {
  set nv {}
  foreach i $v {
    if {"[string range $i 0 [expr [string length $p] -1]]" == "$p"} {
      if {$nv != ""} {
        set nv "$nv \$Parent[string range $i [string length $p] end]"
      } else {set nv "\$Parent[string range $i [string length $p] end]"}
    } else {
      if {$nv != ""} {set nv "$nv $i"} else {set nv $i}
    }
  }
  return $nv
}

proc for_array_keys {item arr body} {
  upvar $item i
  upvar $arr a
  foreach i [array names a] {
    uplevel $body
  }
}

proc csubstr {s f l} {
  return [string range $s $f $l]
}

proc clength {s} {
  return [string length $s]
}

proc lvarpop {v} {
  upvar $v l
  set tmp $l
  set l [lrange $l 1 end]
  return [lindex $tmp 0]
}

proc isset {var} {
  set body "return \[info exists $var\]"
  uplevel $body
}

proc is_packed w {
  if {[catch "pack info $w"]==0} {return 1}
  return 0
}
proc is_aligned w {
  if {[align info $w]!=""} {return 1}
  return 0
}
proc is_placed w {
  if [is_aligned $w] {return 0}
  if {[place info $w]!=""} {return 1}
  return 0
}
proc is_blt_table w {
  if {[catch "blt_table info $w"]==0} {return 1}
  return 0
}

proc use_shape {w s marker} {
  global pp_shape selected 
  set n [winfo name $w]
  if {[is_gui_widget $w]==0} {
    if {$s=="align" && [is_aligned $w]} return
    if {$s=="pack" && [is_packed $w]} return
    if {$s=="place" && [is_placed $w]} return
    if {$s=="blt_table" && [is_blt_table $w]} return
  }
  if {$s == "pack"} {
    catch "pack forget .gui_edit$n.frame2"
    catch "pack forget .gui_edit$n.frame2b"
    catch "pack forget .gui_edit$n.frame2c"
    catch "pack .gui_edit$n.frame2a -fill x -expand 1"
  } elseif {$s == "place"} {
    #echo here
    catch "pack forget .gui_edit$n.frame2a"
    catch "pack forget .gui_edit$n.frame2b"
    catch "pack forget .gui_edit$n.frame2c"
    catch "pack .gui_edit$n.frame2 -fill x -expand 1"
  } elseif {$s == "blt_table"} {
    catch "pack forget .gui_edit$n.frame2"
    catch "pack forget .gui_edit$n.frame2a"
    catch "pack forget .gui_edit$n.frame2c"
    catch "pack .gui_edit$n.frame2b -fill x -expand 1"
  } elseif {$s == "align"} {
    catch "pack forget .gui_edit$n.frame2"
    catch "pack forget .gui_edit$n.frame2a"
    catch "pack forget .gui_edit$n.frame2b"
    catch "pack .gui_edit$n.frame2c -fill x -expand 1"
  }
  set pp_shape($w) $s
  if ![is_gui_widget $w] {
    if {$s == "pack"} {
      catch "place forget $w"
      catch "align forget $w"
      catch "blt_table forget $w"
      pack $w
    } elseif {$s == "place"} {
      catch "pack forget $w"
      catch "align forget $w"
      catch "blt_table forget $w"
      place $w -x 0 -y 0
    } elseif {$s == "blt_table"} {
      catch "pack forget $w"
      catch "align forget $w"
      catch "place forget $w"
      blt_table [winfo parent $w] $w [get_free_index [winfo parent $w]]
    } elseif {$s == "align"} {
      catch "pack forget $w"
      catch "blt_table forget $w"
      align $w
    }
  } else {
    foreach wi [make_widget_list] {
      if {[isset selected($wi)]==0} continue
      if {$selected($wi) == $marker} {
        set pp_shape($wi) $s
        set n [winfo name $wi]
        if {$s == "pack"} {
          catch "place forget $wi"
          catch "blt_table forget $wi"
          catch "pack $wi"
          catch "pack forget .gui_edit$n.frame2"
          catch "pack forget .gui_edit$n.frame2b"
          catch "pack forget .gui_edit$n.frame2c"
          catch "pack .gui_edit$n.frame2a -fill x -expand 1"
        } elseif {$s == "place"} {
          catch "pack forget $wi"
          catch "blt_table forget $wi"
          catch "place $wi -x 0 -y 0"
          catch "pack forget .gui_edit$n.frame2a"
          catch "pack forget .gui_edit$n.frame2b"
          catch "pack forget .gui_edit$n.frame2c"
          catch "pack .gui_edit$n.frame2 -fill x -expand 1"
        } elseif {$s == "blt_table"} {
          catch "pack forget .gui_edit$n.frame2a"
          catch "pack forget .gui_edit$n.frame2"
          catch "pack forget .gui_edit$n.frame2c"
          catch "blt_table [winfo parent $wi] $wi [get_free_index [winfo parent $wi]]"
          catch "pack .gui_edit$n.frame2b -fill x -expand 1"
        } elseif {$s == "align"} {
          catch "pack forget .gui_edit$n.frame2a"
          catch "pack forget .gui_edit$n.frame2"
          catch "pack forget .gui_edit$n.frame2b"
          catch "pack .gui_edit$n.frame2c -fill x -expand 1"
          catch "align $wi"
        }
      }
    }
  }
}

proc pack_val {w val} {
  global tk_version
  if {$tk_version >=4} {
    if {[catch "pack info $w"]==1} {set w .guibuilder.fr3.create.b}
    set l [pack info $w]
  } else {
    if {[catch "pack info $w"]==1} {set w .guibuilder.fr3.create.b}
    set l [pack info $w]
  }
  set i [lsearch $l $val]
  set i [expr $i + 1]
  return [lindex $l $i]
}


proc make_menu {w cmd args} {
  catch "destroy $w.m"
  if {[llength $args] == 1} {eval "set args $args"}
  #eval "menu $w.m -takefocus 1 $args"
  eval "menu $w.m $args"
  for {set i 0} {$i < [llength $cmd]} {set i [expr $i+1]} {
    set line [lindex $cmd $i]
    if {"[lindex $line 0]" == "separator" } {
      set CMD "$w.m add separator [lrange $line 1 end]"
      eval $CMD
    } elseif {"[lindex $line 0]" == "tearoff" } {
    } else {
      if {"[lindex $line 1]" == "menu" } {
        set CMD "$w.m add cascade -label \"[lindex $line 0]\" -menu [make_menu $w.m [lindex $line 2] [lrange $line 3 end]]"
        eval $CMD
      } else {
        set CMD "$w.m add [lindex $line 1] -label \"[lindex $line 0]\" -command \"[lindex $line 2]\" [lrange $line 3 end]"
        eval $CMD
      }
    }
  }
  return $w.m
}

#Begin Ted Dunning's code

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# generic bindings for emacs like behavior

bind Entry <Key> "entry_insert %W %A"
bind Entry <Shift-Key> "entry_insert %W %A"
bind Entry <Control_L> "nop"
bind Entry <Shift_L> "nop"
bind Entry <Shift_R> "nop"

proc nop {} {}

proc entry_insert {w key} {
    catch {$w delete sel.first sel.last}
    $w insert insert $key
}

bind Entry <Control-a> {%W icursor 0}
bind Entry <Control-e> {%W icursor end}
bind Entry <Control-f> {%W icursor [expr [%W index insert]+1]}
bind Entry <Control-b> {%W icursor [expr [%W index insert]-1]}
bind Entry <Control-k> {%W delete [%W index insert] end}

bind Entry <Control-Key> { }

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# normal motif style pasting

bind Entry <Button-2> {catch {%W insert insert [selection get]}}

bind Entry <Double-Button-1> {%W select from 0 ; %W select to end}

bind Entry <Delete> {handle_backspace %W}
bind Entry <BackSpace> {handle_backspace %W}
bind Entry <Control-h> {handle_backspace %W}

proc handle_backspace w {
    if {[catch {$w delete sel.first sel.last}]} {
        set pos [expr [$w index insert]-1]
        $w delete $pos $pos
    }
}

#End Ted Dunning's code.
