/*
 *=============================================================================
 *                                tSippTk.c
 *-----------------------------------------------------------------------------
 * Tcl-SIPP Tk utilities.
 *-----------------------------------------------------------------------------
 * Copyright 1992-1993 Mark Diekhans
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Mark Diekhans makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: tSippTk.c,v 4.0 1993/11/27 21:29:10 markd Rel $
 *=============================================================================
 */

#include "tSippInt.h"

#include "tk.h"
#include "tkInt.h"
#include "tkCanvas.h"

extern Tk_ItemType TkPhotoItemType;

extern int
Tk_PhotoCmd _ANSI_ARGS_((ClientData   clientData,
                         Tcl_Interp  *interp,
                         int          argc,
                         char       **argv));


/*=============================================================================
 * TkSippUpdate -- 
 *   Allow Tk to handle pending events, also checks for signals.
 *
 * Parameters:
 *   o tSippGlobPtr (I) - A pointer to the Tcl SIPP global structure.
 *-----------------------------------------------------------------------------
 */
void
TkSippUpdate (tSippGlobPtr)
    tSippGlob_pt  tSippGlobPtr;
{
    static char *argv [2] = {"update", NULL};

    if (tcl_AsyncReady) {
        if (Tcl_AsyncInvoke (tSippGlobPtr->interp, TCL_OK) == TCL_ERROR)
            Tk_BackgroundError (tSippGlobPtr->interp);
        Tcl_ResetResult (tSippGlobPtr->interp);
    }
    Tk_UpdateCmd (tSippGlobPtr->tkMainWindow, tSippGlobPtr->interp,
                  1, argv);
}

/*=============================================================================
 * TkSipp_Init -- 
 *   Initialize the Tcl/Sipp environment including Tk commands.  This is called
 * in place of TSippInitialize in a Tk application.
 *
 * Parameters:
 *   o interp (I) - Pointer to the Tcl interpreter.
 * Returns:
 *   TCL_OK or TCL_ERROR.
 *-----------------------------------------------------------------------------
 */
int
TkSipp_Init (interp)
    Tcl_Interp *interp;
{
    static char  *aTkCommand = "button";
    Tcl_CmdInfo   cmdInfo;
    tSippGlob_pt  tSippGlobPtr;

    /*
     * Locate the TK main window by finding a Tk command's client data.
     */
    if (!Tcl_GetCommandInfo (interp, aTkCommand, &cmdInfo)) {
        Tcl_AppendResult (interp, "unable to find Tk command \"",
                          aTkCommand, "\" need to locate main window for ",
                          "Tcl-SIPP", (char *) NULL);
        return TCL_ERROR;
    }

    /*
     * Initialize the basic TSIPP commands.
     */
    tSippGlobPtr = TSippInitialize (interp);
    if (tSippGlobPtr == NULL)
        return TCL_ERROR;

    /*
     * Save Tk information in the TSIPP globals and set up the photo widget
     * access.
     */
    tSippGlobPtr->tkMainWindow = cmdInfo.clientData;
    tSippGlobPtr->updateProc   = TkSippUpdate;

    TSippPhotoInit (tSippGlobPtr);

    /*
     * Create the "photo" command and canvas item type.
     */
    Tcl_CreateCommand (interp, "photo", Tk_PhotoCmd,
                       cmdInfo.clientData, (void (*)()) NULL);
    Tk_CreateItemType (&TkPhotoItemType);

    return TCL_OK;
}
