#==============================================================================
#                                 isy90.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program isy90.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: isy90.tcl,v 4.0 1993/11/27 21:25:52 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs 3

set M_PI           3.14159265358979323846
set BEZ_RES        9
set CYL_RES        40
set LID_ROT        1.5
set BLOCK_SIZE     1.2
set NCYL           16
set CYL_LEN        5.0
set SMALL_CYL_RAD  [expr (($BLOCK_SIZE * $M_PI) / ($NCYL * 2))]
set BIG_CYL_RAD    [expr (0.5 * $BLOCK_SIZE - 1.1 * $SMALL_CYL_RAD)]

proc TeapotSpout {resolution shader} {
    set vertexList {
        {7.000000E-01     3.750000E-02    5.625000E-01}
        {7.250000E-01     3.750000E-02    5.812500E-01}
        {7.000000E-01     6.250000E-02    5.812500E-01}
        {6.750000E-01     6.250000E-02    5.625000E-01}
        {5.750000E-01     6.250000E-02    4.875000E-01}
        {6.500000E-01     1.650000E-01    3.187500E-01}
        {4.250000E-01     1.650000E-01    3.187500E-01}
        {8.000000E-01     3.750000E-02    5.625000E-01}
        {8.625000E-01     3.750000E-02    5.906250E-01}
        {8.812500E-01     6.250000E-02    5.859375E-01}
        {8.250000E-01     6.250000E-02    5.625000E-01}
        {6.000000E-01     6.250000E-02    4.687500E-01}
        {7.750000E-01     1.650000E-01    1.687500E-01}
        {4.250000E-01     1.650000E-01    1.125000E-01}
        {8.000000E-01    -0.000000E+00    5.625000E-01}
        {8.625000E-01    -0.000000E+00    5.906250E-01}
        {8.812500E-01    -0.000000E+00    5.859375E-01}
        {8.250000E-01    -0.000000E+00    5.625000E-01}
        {6.000000E-01    -0.000000E+00    4.687500E-01}
        {7.750000E-01    -0.000000E+00    1.687500E-01}
        {4.250000E-01    -0.000000E+00    1.125000E-01}
        {8.000000E-01    -3.750000E-02    5.625000E-01}
        {8.625000E-01    -3.750000E-02    5.906250E-01}
        {8.812500E-01    -6.250000E-02    5.859375E-01}
        {8.250000E-01    -6.250000E-02    5.625000E-01}
        {6.000000E-01    -6.250000E-02    4.687500E-01}
        {7.750000E-01    -1.650000E-01    1.687500E-01}
        {4.250000E-01    -1.650000E-01    1.125000E-01}
        {7.000000E-01    -3.750000E-02    5.625000E-01}
        {7.250000E-01    -3.750000E-02    5.812500E-01}
        {7.000000E-01    -6.250000E-02    5.812500E-01}
        {6.750000E-01    -6.250000E-02    5.625000E-01}
        {5.750000E-01    -6.250000E-02    4.875000E-01}
        {6.500000E-01    -1.650000E-01    3.187500E-01}
        {4.250000E-01    -1.650000E-01    3.187500E-01}
        {7.000000E-01    -0.000000E+00    5.625000E-01}
        {7.250000E-01    -0.000000E+00    5.812500E-01}
        {7.000000E-01    -0.000000E+00    5.812500E-01}
        {6.750000E-01    -0.000000E+00    5.625000E-01}
        {5.750000E-01    -0.000000E+00    4.875000E-01}
        {6.500000E-01    -0.000000E+00    3.187500E-01}
        {4.250000E-01    -0.000000E+00    3.187500E-01}}
    set patchList {
        {{ 3  4  5  6}    {38 39 40 41}    {31 32 33 34}    {24 25 26 27}}
        {{21 22 23 24}    {14 15 16 17}    { 7  8  9 10}    { 0  1  2  3}}
        {{ 0  1  2  3}    {35 36 37 38}    {28 29 30 31}    {21 22 23 24}}
        {{24 25 26 27}    {17 18 19 20}    {10 11 12 13}    { 3  4  5  6}}}
    return [SippBezierPatch $resolution $vertexList $patchList $shader WORLD]
}

proc TeapotLid {resolution shader} {
    set vertexList {
        {3.500000E-01    0.000000E+00    5.625000E-01}
        {3.250000E-01    0.000000E+00    6.000000E-01}
        {1.000000E-01    0.000000E+00    6.000000E-01}
        {5.000000E-02    0.000000E+00    6.375000E-01}
        {0.000000E+00    0.000000E+00    6.750000E-01}
        {2.000000E-01    0.000000E+00    7.500000E-01}
        {0.000000e+00    0.000000e+00    7.500000e-01}}
    set curveList {
        {3 4 5 6}
        {0 1 2 3}}
    return [SippBezierCurve $resolution $vertexList $curveList $shader WORLD]
}

proc TeapotHandle {resolution shader} {
    set vertexList {
        {-4.750000E-01    -7.500000E-02    1.125000E-01}
        {-6.625000E-01    -7.500000E-02    1.968750E-01}
        {-7.500000E-01    -7.500000E-02    3.000000E-01}
        {-7.500000E-01    -7.500000E-02    4.125000E-01}
        {-7.500000E-01    -7.500000E-02    5.250000E-01}
        {-6.250000E-01    -7.500000E-02    5.250000E-01}
        {-3.750000E-01    -7.500000E-02    5.250000E-01}
        {-5.000000E-01    -7.500000E-02    1.875000E-01}
        {-6.250000E-01    -7.500000E-02    2.437500E-01}
        {-6.750000E-01    -7.500000E-02    3.562500E-01}
        {-6.750000E-01    -7.500000E-02    4.125000E-01}
        {-6.750000E-01    -7.500000E-02    4.687500E-01}
        {-5.750000E-01    -7.500000E-02    4.687500E-01}
        {-4.000000E-01    -7.500000E-02    4.687500E-01}
        {-5.000000E-01    -0.000000E+00    1.875000E-01}
        {-6.250000E-01    -0.000000E+00    2.437500E-01}
        {-6.750000E-01    -0.000000E+00    3.562500E-01}
        {-6.750000E-01    -0.000000E+00    4.125000E-01}
        {-6.750000E-01    -0.000000E+00    4.687500E-01}
        {-5.750000E-01    -0.000000E+00    4.687500E-01}
        {-4.000000E-01    -0.000000E+00    4.687500E-01}
        {-5.000000E-01     7.500000E-02    1.875000E-01}
        {-6.250000E-01     7.500000E-02    2.437500E-01}
        {-6.750000E-01     7.500000E-02    3.562500E-01}
        {-6.750000E-01     7.500000E-02    4.125000E-01}
        {-6.750000E-01     7.500000E-02    4.687500E-01}
        {-5.750000E-01     7.500000E-02    4.687500E-01}
        {-4.000000E-01     7.500000E-02    4.687500E-01}
        {-4.750000E-01     7.500000E-02    1.125000E-01}
        {-6.625000E-01     7.500000E-02    1.968750E-01}
        {-7.500000E-01     7.500000E-02    3.000000E-01}
        {-7.500000E-01     7.500000E-02    4.125000E-01}
        {-7.500000E-01     7.500000E-02    5.250000E-01}
        {-6.250000E-01     7.500000E-02    5.250000E-01}
        {-3.750000E-01     7.500000E-02    5.250000E-01}
        {-4.750000E-01    -0.000000E+00    1.125000E-01}
        {-6.625000E-01    -0.000000E+00    1.968750E-01}
        {-7.500000E-01    -0.000000E+00    3.000000E-01}
        {-7.500000E-01    -0.000000E+00    4.125000E-01}
        {-7.500000E-01    -0.000000E+00    5.250000E-01}
        {-6.250000E-01    -0.000000E+00    5.250000E-01}
        {-3.750000E-01    -0.000000E+00    5.250000E-01}}
    set patchList {
        {{ 6  5  4  3}    {13 12 11 10}    {20 19 18 17}    {27 26 25 24}}
        {{ 0  1  2  3}    {35 36 37 38}    {28 29 30 31}    {21 22 23 24}}
        {{21 22 23 24}    {14 15 16 17}    { 7  8  9 10}    { 0  1  2  3}}
        {{ 3  4  5  6}    {38 39 40 41}    {31 32 33 34}    {24 25 26 27}}}
    return [SippBezierPatch $resolution $vertexList $patchList $shader WORLD]
}

proc TeapotBody {resolution shader} {
    set vertexList {
        {3.750000E-01    0.000000E+00    0.000000E+00}
        {3.750000E-01    0.000000E+00    1.875000E-02}
        {5.000000E-01    0.000000E+00    7.500000E-02}
        {5.000000E-01    0.000000E+00    1.875000E-01}
        {5.000000E-01    0.000000E+00    3.000000E-01}
        {4.375000E-01    0.000000E+00    4.312500E-01}
        {3.750000E-01    0.000000E+00    5.625000E-01}
        {3.593750E-01    0.000000E+00    5.953125E-01}
        {3.343750E-01    0.000000E+00    5.953125E-01}
        {3.500000E-01    0.000000E+00    5.625000E-01}}
    set curveList {
        {6 7 8 9}
        {0 1 2 3}
        {3 4 5 6}}
    return [SippBezierCurve $resolution $vertexList $curveList $shader WORLD]
}


set marble [SippShaderMarble 0.4 0.5 0.05 8.0 {0.90 0.80 0.65} \
                             {0.30 0.08 0.08} {1.0 1.0 1.0}]
set granite [SippShaderGranite 0.4 0.1 0.4 20.0 {0.647 0.565 0.5} \
                               {0.15 0.12 0.10} {1.0 1.0 1.0}]

set sampling 1

SippShadows TRUE [expr (($G_size < 512) ? 2 * $G_size : $G_size)]

set handle [TeapotHandle $BEZ_RES $marble]
set spout  [TeapotSpout  $BEZ_RES $marble]
set body   [TeapotBody   $BEZ_RES $marble]
set lid    [TeapotLid    $BEZ_RES $marble]

SippObjectRotateZ $lid $LID_ROT

set teapot [SippObjectCreate]
SippObjectAddSubobj $teapot $body
SippObjectAddSubobj $teapot $lid
SippObjectAddSubobj $teapot $handle
SippObjectAddSubobj $teapot $spout

SippObjectAddSubobj WORLD $teapot

set column [SippObjectCreate]
set tmp [SippBlock [list $BLOCK_SIZE $BLOCK_SIZE [expr $BLOCK_SIZE/4.0]] \
                   $granite WORLD]
SippObjectMove $tmp [list 0.0 0.0 [expr -$BLOCK_SIZE/8.0]]
SippObjectAddSubobj $column $tmp

for {set idx  0} {$idx < $NCYL} {incr idx} {
    if {$idx == 0} {
        set tmp [SippCylinder $SMALL_CYL_RAD $CYL_LEN $CYL_RES $granite WORLD]
    } else {
        set tmp [SippObjectInstance $tmp]
    }
    set xDist [expr $BIG_CYL_RAD * cos($idx * 2.0 * $M_PI / $NCYL)]
    set yDist [expr $BIG_CYL_RAD * sin($idx * 2.0 * $M_PI / $NCYL)]
    set zDist [expr -0.5 * ($CYL_LEN + $BLOCK_SIZE / 4.0)]

    SippObjectMove $tmp [list $xDist $yDist $zDist]
    SippObjectAddSubobj $column $tmp
}

SippObjectAddSubobj WORLD $column

SippLightSourceCreate {-3.0 -3.0 6.0} {0.35 0.35 0.35} DIRECTION
SippSpotLightCreate {-3.0 -3.0 6.0} {0.0 0.0 0.0} 25.0 {0.45 0.45 0.45} \
                     SHARP TRUE
set camera [SippCameraCreate {2.0 -4.0 1.5} {0.0 0.0 0.1} \
                             {0.0 0.0 1.0} 0.2]
SippCameraUse $camera

DoRendering "isy90"
