/* Copyright 93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* 
 * tclttOtype.c
 *
 *	tt_otype_* functions
 *
 * $Id: tclttOtype.c,v 1.3 93/08/13 15:35:14 beust Exp Locker: beust $
 */

#include "main.h"

int
Tcltt_otype_deriveds_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_otype_deriveds_count(argv[1]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_derived(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result = tt_otype_derived(argv[1], atol(argv[2]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_otype_base(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_otype_base(argv[1]);
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_otype_is_derived(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  sprintf(Tcltt_Result, "%u", tt_otype_is_derived(argv[1], argv[2]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_osig_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_otype_osig_count(argv[1]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_hsig_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_otype_hsig_count(argv[1]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_osig_op(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result = tt_otype_osig_op(argv[1], atol(argv[2]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_otype_hsig_op(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result = tt_otype_hsig_op(argv[1], atol(argv[2]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_otype_osig_args_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  sprintf(Tcltt_Result, "%u",
	  tt_otype_osig_args_count(argv[1], atol(argv[2])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_hsig_args_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  sprintf(Tcltt_Result, "%u",
	  tt_otype_hsig_args_count(argv[1], atol(argv[2])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_osig_arg_mode(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  sprintf(Tcltt_Result, "%u",
	  tt_otype_osig_arg_mode(argv[1], atol(argv[2]), atol(argv[3])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_hsig_arg_mode(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  sprintf(Tcltt_Result, "%u",
	  tt_otype_hsig_arg_mode(argv[1], atol(argv[2]), atol(argv[3])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_osig_arg_type(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  sprintf(Tcltt_Result, "%u",
	  tt_otype_osig_arg_type(argv[1], atol(argv[2]), atol(argv[3])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_otype_hsig_arg_type(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  sprintf(Tcltt_Result, "%u",
	  tt_otype_hsig_arg_type(argv[1], atol(argv[2]), atol(argv[3])));
  interp -> result = Tcltt_Result;
  return result;
}

