/*                                               The HTML DTD -- software interface in libwww
                              HTML DTD - SOFTWARE INTERFACE
                                             
   SGML purists should excuse the use of the term "DTD" in this file to represent
   DTD-related information which is not exactly a DTD itself.
   
   The C modular structure doesn't work very well here, as the dtd is partly in the .h and
   partly in the .c which are not very independent.  Tant pis.
   
 */
#ifndef HTMLDTD_H
#define HTMLDTD_H

#include "HTUtils.h"
#include "SGML.h"

/*

Element Numbers

 */

/*

   Must Match all tables by element! These include tables in HTMLDTD.c and code in HTML.c
   .
   
 */
typedef enum _HTMLElement {
        HTML_A, HTML_ABBREV, HTML_ABSTRACT, HTML_ACRONYM, 
           HTML_ADDED, HTML_ADDRESS, HTML_ARG,
        HTML_B, HTML_BASE, HTML_BLOCKQUOTE, HTML_BODY,
           HTML_BOX, HTML_BR, HTML_BYLINE,
        HTML_CAPTION, HTML_CHANGED, HTML_CITE, HTML_CMD,
           HTML_CODE, HTML_COMMENT,
        HTML_DD, HTML_DFN, HTML_DIR, HTML_DL, HTML_DLC, HTML_DT,
        HTML_EM,
        HTML_FIG, HTML_FOOTNOTE, HTML_FORM,
        HTML_H1, HTML_H2, HTML_H3, HTML_H4, HTML_H5, HTML_H6, HTML_H7,
        HTML_HEAD, HTML_HTML, HTML_HTMLPLUS,
        HTML_I, HTML_IMAGE, HTML_IMG, HTML_INPUT, HTML_ISINDEX,
        HTML_KBD,
        HTML_L, HTML_LI, HTML_LINK, HTML_LISTING, HTML_LIT,
        HTML_MARGIN, HTML_MATH, HTML_MENU,     
        HTML_NOTE, HTML_NEXTID,
        HTML_OL, HTML_OPTION, HTML_OVER,
        HTML_P, HTML_PERSON, HTML_PLAINTEXT, HTML_PRE,
        HTML_Q, HTML_QUOTE,
        HTML_REMOVED, HTML_RENDER,
        HTML_S, HTML_SAMP, HTML_SELECT, HTML_STRONG, HTML_SUB, HTML_SUP,
        HTML_TAB, HTML_TABLE, HTML_TD, HTML_TEXTAREA, HTML_TH,
           HTML_TITLE, HTML_TR, HTML_TT,
        HTML_U, HTML_UL,
        HTML_VAR, HTML_XMP } HTMLElement;

#define HTML_ELEMENTS 85

/*

Attribute numbers

 */

/*

   Identifier is HTML_<element>_<attribute>. These must match the tables in HTML.c!
   
 */
#define HTML_A_EFFECT           0
#define HTML_A_HREF             1
#define HTML_A_ID               2
#define HTML_A_LANG             3
#define HTML_A_METHODS          4
#define HTML_A_NAME             5
#define HTML_A_PRINT            6
#define HTML_A_REL              7
#define HTML_A_REV              8
#define HTML_A_SHAPE            9
#define HTML_A_SIZE            10
#define HTML_A_TITLE           11
#define HTML_A_TYPE            12
#define HTML_A_URN             13
#define HTML_A_ATTRIBUTES      14

#define HTML_BASE_HREF          0
#define HTML_BASE_ATTRIBUTES    1

#define HTML_CHANGED_ID		0
#define HTML_CHANGED_IDREF	1
#define HTML_CHANGED_ATTRIBUTES	2

#define HTML_DL_COMPACT         0
#define HTML_DL_ID 		1
#define HTML_DL_INDEX		2
#define HTML_DL_LANG		3
#define HTML_DL_ATTRIBUTES	4

#define HTML_FORM_ACTION	0
#define HTML_FORM_ID		1
#define HTML_FORM_INDEX		2
#define HTML_FORM_LANG		3
#define HTML_FORM_METHOD	4
#define HTML_FORM_ATTRIBUTES	5

#define HTML_HPLUS_FORMS	0
#define HTML_HPLUS_VERSION	1
#define HTML_HPLUS_ATTRIBUTES	2

#define HTML_ID_ALIGN		0
#define HTML_ID_AT		1
#define HTML_ID_BORDER          2
#define HTML_ID_ID              3
#define HTML_ID_INDEX           4
#define HTML_ID_LANG            5
#define HTML_ID_ROLE		6
#define HTML_ID_SRC		7
#define HTML_ID_ATTRIBUTES      8

#define HTML_IMG_ISMAP          0
#define HTML_IMG_SRC            1
#define HTML_IMG_ATTRIBUTES     2

#define HTML_INPUT_ALIGN	0
#define HTML_INPUT_CHECKED	1
#define HTML_INPUT_DISABLED	2
#define HTML_INPUT_ERROR	3
#define HTML_INPUT_LANG		4
#define HTML_INPUT_MIN		5
#define HTML_INPUT_MAX		6
#define HTML_INPUT_NAME		7
#define HTML_INPUT_SIZE		8
#define HTML_INPUT_SRC		9
#define HTML_INPUT_TYPE		10
#define HTML_INPUT_VALUE	11
#define HTML_INPUT_ATTRIBUTES	12

#define HTML_OPTION_DISABLED	0
#define HTML_OPTION_LANG	1
#define HTML_OPTION_SELECTED	2
#define HTML_OPTION_ATTRIBUTES	3

#define HTML_RENDER_STYLE	0
#define HTML_RENDER_TAG		1
#define HTML_RENDER_ATTRIBUTES	2

#define HTML_SELECT_ERROR	0
#define HTML_SELECT_LANG	1
#define HTML_SELECT_NAME	2
#define HTML_SELECT_SEVERAL	3
#define HTML_SELECT_ATTRIBUTES  4

#define HTML_TBL_ALIGN		0
#define HTML_TBL_COLSPAN	1
#define HTML_TBL_LANG		2
#define HTML_TBL_ROWSPAN	3
#define HTML_TBL_ATTRIBUTES	4

#define HTML_TBLT_COLS		0
#define HTML_TBLT_DISABLED	1
#define HTML_TBLT_ERROR		2
#define HTML_TBLT_LANG		3
#define HTML_TBLT_NAME		4
#define HTML_TBLT_ROWS		5
#define HTML_TBLT_ATTRIBUTES	6


#define HTML_NEXTID_N 0

extern CONST SGML_dtd HTML_dtd;


/*

Start anchor element

   It is kinda convenient to have a particulr routine for starting an anchor element, as
   everything else for HTML is simple anyway.
   
  ON ENTRY
  
   targetstream poinst to a structured stream object.
   
   name and href point to attribute strings or are NULL if the attribute is to be omitted.
   
 */
extern void HTStartAnchor PARAMS((
                HTStructured * targetstream,
                CONST char *    name,
                CONST char *    href));


#endif /* HTMLDTD_H */

/*

   End of module definition  */
