#---------------------------------------------------------------------------
#
#	Toplevel Creation
#
#---------------------------------------------------------------------------

defwidget Toplevel Frame

#--	[new(toplevel) name]
#	Create a new toplevel named 'name' with generic background color.
#
defmethod Toplevel new {name args} {
  global env system

  args	title buttons stdargs actions aspect resizable background \
	info windowtitle icon reuse handler logos transient

  if { [winfo exists $name] } {
    if { $reuse == "true" } {
      wm withdraw $name
      update
      wm deiconify $name
      update
      focus $name
      return $name
    } {
      $name Dismiss
    }
  }

  set actions [$self buildActions $actions $name]

  if { $background == {} } {
    set background [Color slot bg]
  }
  toplevel $name -background $background -borderwidth 0 -relief flat
  Toplevel instantiate $name {}

  set transient [expr {$transient == "true"}]
  $name slot transient $transient
  if { $transient } {
    wm transient $name [winfo parent $name]
    $name decorate
  }

  if { $logos != {} } {
    Logos new *$name \
	-layout {top fillx} \
	-logos $logos
  } elseif { $title != {} } {
    Title new *$name -text $title
  }

  if { $info == "true" } {
    Infoline new *$name
  }

  if { $actions != {} } {
    Buttonpanel new $name.buttons \
	-layout {right filly} \
	-handler $handler \
	-buttons $buttons \
	-actions $actions \
  }

  if { $windowtitle == {} } {
    wm title $name $system(application)
  } {
    wm title $name $windowtitle
  }
  wm iconname $name [wm title $name]

  if { $icon != {} } {
    wm iconbitmap $name @[the(image) $icon]
  }

  if { $aspect != {} } {
    eval [concat wm aspect $name $aspect]
  }

  if { $resizable == "true" } {
    wm minsize $name 200 300
    wm maxsize $name 1200 1000
  }

  return $name
}

defmethod Toplevel decorate {} {

  $self configure -borderwidth 10
}
