#---------------------------------------------------------------------------
#
#	Multiple Listboxes
#
# Actions are invoked with: box#, boxName, item#, itemString
#

defwidget Listboxes

defmethod Listboxes new {name args} {

  args	action double {boxes 1} {textfont text} layout \
	titles {titlefont bold} init

  set action [$self buildAction $action $name]
  set double [$self buildAction $double $name]
puts stdout "$action $double"
  Frame new $name -layout $layout
  defsuper $name Listboxes

  Scrollbar new $name.scrolly -layout {right filly} -dir vertical \
	-action [list $name _scrollbar $boxes {}]

  set l 0
  foreach ini $init {
    set l0 [llength $ini]
    if { $l < $l0 } { set l $l0 }
  }
  set inits {}
  foreach ini $init {
    lappend inits [assertlength $ini $l]
  }

  set title ""
  set doubleaction ""
  set singleaction ""

  for {set i 1} {$i <= $boxes} {incr i} {
    set initi [lindex $inits [expr $i-1]]
    if { $titles != {} } {
      set title [lindex $titles [expr $i-1]]
      if { $title == {} } {
	set title " "
      }
    }
    if { $action != "" } {
      set singleaction [concat $action $i]
    }
    if { $double != "" } {
      set doubleaction [concat $double $i]
    }
    Listbox new $name.f$i \
	-yscroll [list $name _scrolllist $boxes $i $name.scrolly] \
	-init $initi -title $title \
	-textfont $textfont -titlefont $titlefont \
	-action $singleaction -double $doubleaction \
	-layout {left expand fill}
  }

  return $name
}

defmethod Listboxes list {index} {
  return $self.f$index.list
}

defmethod Listboxes _scrolllist {n ind scroll total max top bottom} {

  $scroll! set $total $max $top $bottom
  $self _scrollbar $n $ind $top
}

defmethod Listboxes _scrollbar {n ind top} {

  for {set i 1} {$i <= $n} {incr i} {
    if {$i != $ind} {
      $self.f$i.list! yview $top
    }
  }
}

#---------------------------------------------------------------------------

Window addDemo Listboxes

defmethod Listboxes demo {} {

  set t [Toplevel new * -title "New Toplevel" -info true -resizable true]
  Listboxes new *$t -boxes 3 -layout {top expand fill} \
	-init {{foodfhdskhfdshfsdhfhsdhfshfhdhfksdhfksf bar baz} 
	{fum fie fumsd sdfsdfo} {a b c d e f}} \
	-titles {Foo-Stuff More-Stuff Letters} \
	-action {- showAction single} -double {- showAction double}
  Button new *$t -layout {padx 20 pady 20 bottom} \
	-textfont largebold -text "Dismiss" \
	-action [list $t Dismiss]
  $t layout center
  cursor(busy) {exec sleep 2}
  puts stdout 1; exec sleep 1
  cursor(busy) {exec sleep 2}
}

