#---------------------------------------------------------------------------
#
#	Create a vertical button panel
#
#---------------------------------------------------------------------------

defwidget Buttonpanel

#--	[new Buttonpanel name -buttons -handler -stdargs -actions -layout]
#
#	This creates a new vertical button panel with the specified buttons
#	in one column, with a "Help" button at the top, and with a button
#	"Dismiss" at the bottom. "Help" will be followed by those buttons
#	from "$buttons" for which an action is specified. When a button is
#	pressed, the general handler function "handler" (usually an object)
#	is called with a first argument naming the button (symbolic name),
#	followed by all elements of "$stdargs" and the action associated
#	with the button name. Each element of "$actions" consists of a
#	symbolic button name, a name to display (or "" to take the symbolic
#	name), and a list of other elements describing an associated action.
#
defmethod Buttonpanel new {name args} {

  args	buttons handler stdargs actions layout

  # Collect the names of all allowed buttons into "$knobs"
  set space 0
  set knobs {Dismiss Help}
  foreach i $buttons {
    if { $i == {} } {
      lappend knobs {}
      set space 1
    } elseif { [position $i $knobs] < 0 && [assock $i $actions] != {} } {
      lappend knobs $i
      set space 0
    }
  }
  if { ! $space } {
    lappend knobs {}
  }
  set knobs [lrange $knobs 1 end]
  lappend knobs Dismiss

  # Default action for "Help" and "Dismiss" buttons.
  if { [assoc Help $actions] == {} } {
    lappend actions {Help {} Library/buttonpanel}
  }
  if { [assoc Dismiss $actions] == {} } {
    lappend actions {Dismiss {}}
  }

  Frame new $name -layout $layout
  defsuper $name Buttonpanel

  set pos top
  set space 0
  foreach button $knobs {

    if { $button == {} } {
      if { ! $space } {
	Space new *$name -layout {top}
	set space 1
      }
      continue
    }

    set action [assoca $button $actions]
    if { $action == {} } {
      continue
    }

    set label [lindex $action 1]
    if { $label == {} } {
      set label $button
    }
    set label [space(restore) $label]
    set action [lrange $action 2 end]

    if { $button == "Dismiss" } {
      set pos bottom
    }

    set space 0
    Button new *$name \
	-layout [concat $pos {padx 10 pady 10 frame center}] \
	-text [space(restore) $label] -textfont bold \
	-symbolic $button \
	-action [concat $handler [list $button] $stdargs [list $action]]
  }

  return $name
}

defmethod Buttonpanel find {name} {

  foreach child [winfo children $self] {
    if { [is $child Button] && [$child slot symbolic] == $name } {
      return $child
    }
  }
  return
}
