proc showAction {args} {
  puts stdout "Action: $args"
  return
}

## proc nil {args}
##	This procedure takes an arbitrary number of arguments and always
##	returns an empty string.
##
proc nil {args} {
  return
}

## proc assertlength {list length}
##	Return a list of length 'length'. If 'list' is shorter than 'length',
##	empty elements are appended. Otherwise, a list prefix of the requested
##	length is returned.
proc assertlength {list length} {

  set listlength [llength $list]
  if { $listlength == $length } {
    return $list
  }
  if { $listlength > $length } {
    return [lrange $list 0 [expr $length-1]]
  }
  for {} {$listlength < $length} {incr listlength} {
    lappend list {}
  }
  return $list
}

## proc assoc {key alist}
##	Association list lookup. This returns "" or the associated value.
##
proc assoc {key alist} {
  foreach pair $alist {
    if { [lindex $pair 0] == $key } {
      return [lrange $pair 1 end]
    }
  }
  return {}
}

## proc assocp {key alist}
##	Association list lookup with pattern matching. This returns "" or
##	the associated value.
##
proc assocp {key alist} {
  foreach pair $alist {
    if { [string match [lindex $pair 0] $key] } {
      return [lrange $pair 1 end]
    }
  }
  return {}
}

## proc assoca {key alist}
##	Association list lookup. This returns the pair with the matching key.
##
proc assoca {key alist} {
  foreach pair $alist {
    if { [lindex $pair 0] == $key } {
      return $pair
    }
  }
  return {}
}

## proc assock {key alist}
##	Association list lookup. This returns the key if a pair is found.
##
proc assock {key alist} {
  foreach pair $alist {
    if { [lindex $pair 0] == $key } {
      return $key
    }
  }
  return {}
}

## proc associ {key alist}
##	Association list lookup. This returns index of the matching pair.
##
proc associ {key alist} {
  set pos 0
  foreach pair $alist {
    if { [lindex $pair 0] == $key } {
      return $pos
    }
    incr pos
  }
  return {}
}

## proc position {object list}
##	Return -1 or index of object in list.
##
proc position {object list} {
  set pos 0
  foreach element $list {
    if { $element == $object } {
      return $pos
    }
    incr pos
  }
  return -1
}

## proc list2strings {items}
##	Translate the list of items into a list of strings suitable for
##	sending the result to LISP.
##
proc list2strings {items} {
  set string \"
  append string [join $items \"\ \"] \"
  return $string
}

## proc list2symbols {items}
##	Translate the list of items into a list of symbols suitable for
##	sending the result to LISP.
##
proc list2symbols {items} {
  set string "|"
  append string [join $items "| |"] "|"
  return $string
}

## proc global_eval {form}
##	Evaluate the expression "form" in the global context and return the
##	result on both standard output and from the function.
##
proc global_eval {form} {
  puts stdout [uplevel #0 ${form}]
  flush stdout
}

## proc static {args}
##	Derived from a posting to comp.lang.tcl by Karl Lehenbauer. This
##	provides static variables (well, local variables aliased to
##	specially named global variables).
##

proc static {args} {

  set proc [lindex [info level [expr [info level]-1]] 0]
  foreach descr $args {
    set var [lindex $descr 0]
    set val [lindex $descr 1]
    uplevel 1 "upvar #0 __${proc}:$var $var"
    if { [info globals __${proc}:$var] == "" } {
      uplevel #0 [list set __${proc}:$var $val]
    }
  }
  return
}
