
#---------------------------------------------------------------------------
#
#	File: the-env.tcl
#
#---------------------------------------------------------------------------
#

global env system

# var system(printer)
#	The name of the default printer.
#
if { [info exists env(PRINTER)] } {
  set system(printer)	$env(PRINTER)
} else {
  set system(printer)	"lp"
}

#	The full name of the given user or the argument (if there is
#	no such user in the password file.
#
defmethod env fullname {{user ""}} {
  global env

  if { $user == "" } {
    set user $env(USER)
  }

  set fp [open /etc/passwd r]
  while { [gets $fp line] > -1 } {
    set list [split $line ":"]
    if { [lindex $list 0] == $user && [lindex $list 4] != {} } {
      set user [lindex $list 4]
      break
    }
  }
  close $fp
  return $user
}

# var system(user)
#	The full name of the user this process runs under.
#
set system(user) [env fullname]

#---------------------------------------------------------------------------
#
#	Select a printer for all further output operations
#
#---------------------------------------------------------------------------

#	Allow the user to select amoung various alternatives for a given
#	system resource "what". "what" may be one of "printer" (the default
#	printer).
#	-action - An action invoked on the new system resource when set.
#
defmethod env printer {what args} {
  global system

  case $what in {
  {get} {
      return $system(printer)
    }
  {set} {
      set system(printer) [lindex $args 0]
      return
    }
  {_set} {
      set system(printer) [lindex $args 1]
      set action [lindex $args 0]
      if { $action != {} } {
	eval [concat $action [list $system(printer)]]
      }
      return
    }
  {select} {
      args	action

      Selector new * \
	-layout		center \
	-title		"Available Printers" \
	-initmethod	list \
	-init		[app(getoutput) "[the(command) printers]"] \
	-help		$system(system)/printers \
	-actions	[list	[list Help {} $system(system)/printers] \
				[list Select {} env printer _set $action] \
			]
    }
  }
}
