#---------------------------------------------------------------------------
#
#	Info Box Creation
#
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
#
#	Create a dialog box named 'name' with given geometry and text.
#	The list 'buttons' is a list of button names, labels and actions.
#

defwidget Dialog

defmethod Dialog new {name args} {
  global data

  args	text buttons {textfont large} {timer} {help} wait \
	{grab true} {layout center}

  if { $buttons == {} } {
    set buttons {{Ok}}
  }

  if { [winfo exists $name] } {
    return
  }

  Window ungrab

  Toplevel new $name
  defsuper $name Dialog

  if { $help == "" } {
    Message new *$name -layout {padx 10 pady 10 expand fill} \
	-text $text -textfont $textfont
  } {
    Help new *$name -layout {padx 10 pady 10 expand fill} \
	-help $help -embedded true
  }

  Frame new $name.buttons -layout {bottom fillx}

  foreach desc ${buttons} {
    set symbol [lindex $desc 0]
    set label [lindex $desc 1]
    if { $label == {} } {
      set label $symbol
    }
    Button new *$name.buttons \
	-layout {left expand padx 10 pady 10} \
	-textfont large -text $label \
	-symbolic $symbol \
	-action [list $name _button $symbol [lrange $desc 2 end]]
  }

  $name layout $layout
  set data($name) Dismiss

  if { $timer == "true" } {
    $name timeoutGrab
  } elseif { $grab == "true" } {
    $name grab
  }

  if { $wait == "true" } {
    tkwait window $name
    set result $data($name)
    unset data($name)
    return $result
  } {
    return $name
  }
}

defmethod Dialog _button {button action} {
  global data

  $self ungrab
  set data($self) $button

  set result {}
  if { $action != {} } {
    set result [eval [concat $action [list $button]]]
  }
  if { $result == {} } {
    $self Dismiss
  }
}

Window addDemo Dialog

defmethod Dialog demo {} {

  set result \
	[Dialog new * -layout center -text "Warning! You may have mail!" \
	  -timer true -textfont huge -wait true]
  puts stdout "Dialog: $result"
}
