%
% TclVogle.T
%
\documentstyle{article}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\begin{document}
\title{
    {\rm tcl}{\sc Vogle}
    A set of Tcl extensions for drawing 2d and 3d graphics 
}
\author{Mike Hoegeman, {\tt mh@awds.imsd.contel.com}}
\date{}
\maketitle

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\parindent 0pt
\parskip 6pt
\newcommand{\tclVogle}{{\rm tcl}{\sc Vogle}}
\newcommand{\Tk}{{\sc Tk}}
\newcommand{\X}{{\tt X}}
\newcommand{\Tcl}{{\sc Tcl}}
\newcommand{\Vogle}{{\sc Vogle}}
\newcommand{\NULLret}{{\rm ---}}
\newcommand{\BooleanArg}{{\tt true|false}}

% Indent : indent the supplied text one level
% #1 = text to indent
\newcommand{\Indent}[1]{\begin{quote} #1 \end{quote}}

% USE: format for the Usage section of command entries
% #1 = return value 
% #2 = function name
% #3 = arguments
% #4 = one line description, (for quick reference)
\newenvironment{USE}[4]{{\sc Usage:} \begin{quote} {\tt #1} $\Leftarrow$ {\bf #2} {\tt #3} \end{quote}}{}

% OA: format an optional argument description
% #1 = argument to format
\newcommand{\OA}[1]{{\sf ?}#1{\sf ?}}

% TclList: format a tcl list (not a TeX/LaTex list), the list should 
% not include the curlies. TclList will put them in.
% #1 = list to be formatted
\newcommand{\TclList}[1]{\{#1\}}

% TypeWriter Line
\newcommand{\TL}[1]{\begin{quote} {\tt #1} \end{quote}}

% Command Definition
% #1 = command name
\newenvironment{CD}[1]{\subsection{#1}}{}

% #1 = intro
\newenvironment{EG}[1]{Example: #1}{}

% Description
% #1 - one line description (used by quick reference)
\newenvironment{DESC}{{\sc Description}\begin{quote}}{\end{quote}}

% Generic Section
\newenvironment{GS}[1]{{\sc #1}: \begin{quote}}{\end{quote}}

% See Also
\newenvironment{SEE}{{\sc See Also:} \begin{quote}}{\end{quote}}

% See also Item
% #1 = topic
% #2 = category
\newcommand{\SI}[2]{{\bf #1} (#2)\ }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\section{Suggested Reading}

    The user should first read at least the introductory usenix papers
    on Tk X11 toolkit and Tcl embeddable command language before
    reading this document. They are present in the Tcl and Tk source
    distributions.

%% It also advisable to at least skim through the Tk graphic widget
%% documentation which is a companion to this document.

\section{Acknowledgements}
    This document for the most part is an adaptation of the
    \Vogle\ C library manual page. 
    
    The explanation of the g\_ortho command was adapted from a posting
    to comp.sys.sgi by Kurt Akeley (kurt@sgi.com)

\section{Notation in this document}

    \subsection{The Usage: Section}

	When a usage section for a command is supplied if will be of
	the form.

	\USE{returnValue}{procName}{args}{{\it description}}

	If the empty string is supplied as a return value, then
	a $\Leftarrow$ Will be placed in the returnValue area. 
    
	Arguments that are optional will have question marks placed around
	them like so.

	\Indent{	
	    \OA{optionalArgument}
	}

	Numerical values like x, y, or z can be expressed as floating
	point values unless otherwise indicated.  

    \subsection{The See Also: Section}

	In the See Also: section, topics have the form
	\Indent{ 
	    \SI{topicName1}{category} 
	}

	For example a reference to the Tk bind command would be.

	\Indent{
	    \SI{bind}{Tk}
	}

	A refence to a the unix system call bind would be.

	\Indent{
	    \SI{bind}{2}
	}

	For section 2 of the unix manual. 
	
	Almost all the the g\_{\em XXX} \tclVogle\ commands have a
	closely corresponding \Vogle C library function of the same name
	(minus the `g\_' prefix). In the interest of brevity, these
	will not be mentioned in the See Also: sections.

\section{Device Related Commands}

\begin{CD}{g\_init}
    \USE{\NULLret}{g\_init}{deviceName}{
	(Re)-Initialize deviceName
    }

    \begin{DESC}
	(Re)-Initialize the \Vogle\ device deviceName. For example, to
	initialize the \Vogle\ postscript device.

	\TL{g\_init postscript}

	In the case of a \Tk\ graphic widget device. The instantiation of
	a graphic widget with

	\TL{graphic .myGraphicWidget -command {paintme} ...}

	Does an implicit 

	\TL{g\_init .myGraphicWidget}
      
	The postscript device is also automatically g\_init-ed upon the
	creation of first tk graphic widget. This is so a user of \Tk\ 
	graphic widgets can switch to the postscript device at any time
	to produce hardcopy output without worrying about whether the
	postscript device is initialized of not.

    \end{DESC}


    \begin{GS}{Available Devices}
	Although which devices available may vary depending on your
	site.  The following devices have been implemented via the
	\tclVogle\  package

	\begin{description}
	    \item[.{\it graphicName}] {\Tk\ X11 toolkit graphics widget}

	    \item[postscript]	{Postscript.}

	    \item[ppostscript]	{Landscape version of postscript.}

	    \item[hpgl]		{HP graphics language and compatibles.
				 This includes many HP printer products.}

	    \item[dxy]		{Roland DXY plotter language.}
	\end{description}

	There are other softcopy devices available with the \Vogle\ C
	library such as cga,ega,vga, for the PC. sun for sunview
	windows, etc..  See the \Vogle\ C library documentation for what
	devices are available.
    \end{GS}

    \begin{SEE}
	\SI{g\_newdev}{\tclVogle}
	\SI{g\_getdev}{\tclVogle}
	\SI{g\_exit}{\tclVogle}
	\SI{g\_output}{\tclVogle}
	\SI{graphic}{\Tk}
    \end{SEE}
\end{CD}

\begin{CD}{g\_exit}
    \USE{\NULLret}{g\_exit}{deviceName}{
	Reset the current \Vogle\ graphics device.
    }

    \begin{DESC}
	Reset the current \Vogle\ graphics device.  In the case of the
	postscript device for example, this will cause the output file
	to which the postscript stream is being sent to be closed.

	For a \Tk\ graphics widget \Vogle\ device, g\_exit does'nt do
	much of anything since there is no real notion of resetting for
	a graphics widget. 
	
	In most cases, it only makes sense to call this command when
	the current \Vogle\ device is a hardcopy oriented one such as
	postscript or hpgl.  
    \end{DESC}

    \begin{SEE}
	\SI{g\_init}{\tclVogle}
    \end{SEE}
\end{CD}


\begin{CD}{g\_output}
    \USE{\NULLret}{g\_output}{fileName}{
	Set output file for next \Vogle\ device.
    }

    \begin{DESC}
	g\_output concerns \Vogle\ devices which normally write to stdout.
	These are usually hardcopy devices such as the postscript device. 
	
	g\_output indicates that the next device of this style that is
	initialized should direct it's output to fileName instead of stdout.
    \end{DESC}

    \begin{SEE}
	\SI{g\_init}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_newdev}
    \USE{\NULLret}{g\_newdev}{deviceName} {
	Switch to deviceName, preserving the current viewport.
    }
    \begin{DESC}
	Re-intialize \Vogle\ to use a new device without changing
	the current viewport attributes.
    \end{DESC}
    \begin{SEE}
	\SI{g\_init}{\tclVogle}
	\SI{g\_exit}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_getdev}
    \USE{deviceName}{g\_getdev}{}{
	Return name of current \Vogle\ device.
    }

    \begin{DESC}
	g\_getdev returns the name of the current \Vogle\ graphics
	device.
    \end{DESC}

    \begin{SEE}
	\SI{g\_init}{\tclVogle}
	\SI{g\_newdev}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_getdepth}
    \USE{depth}{g\_getdepth}{}{
	Return number of bit planes for current device
    }
    \begin{DESC}
	g\_getdepth returns the number of bit planes for the current 
	\Vogle\ device. 
    \end{DESC}

    \begin{EG}{
	Below is an example using g\_getdepth how you can determine
	whether the current device is monochrome or not.
    }
    \begin{verbatim}
	if {[g_getdepth]==1} {
	    puts stderr "device [g_getdev] is monochrome"
	} else {
	    puts stderr "device [g_getdev] is grayscale or color"
	}
    \end{verbatim}
    \end{EG}

    \begin{SEE}
	\SI{g\_color}{\tclVogle}
    \end{SEE}
\end{CD}

\section{General commands}

\begin{CD}{g\_clear}
    \USE{\NULLret}{g\_clear}{}{
	Clear the screen using the current color.
    }
    \begin{DESC}
	Flood the device with the current color. Clipping areas,
	viewports, etc. are ignored.
    \end{DESC}
    \begin{SEE}
	\SI{g\_color}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_color}
    \USE{\NULLret}{g\_color}{colorName}{
	Set the current color.
    }
    \begin{DESC}
	Set the current color. The Default colors are:
	\begin{description}
	    \item[black]	{0}
	    \item[red]		{1}
	    \item[green]	{2}
	    \item[yellow]	{3}
	    \item[blue]		{4}
	    \item[magenta]	{5}
	    \item[cyan]		{6}
	    \item[white]	{7}
	\end{description}

	{\bf Experimental} If the current device is a \Tk graphic
	widget, then {\em colorName} can be any name present in the \X\
	color database. If the color from some reason cannot be
	allocated from the \X\ server, then the color is set to white
	instead.

	{\bf Note:} If colors are set while contructing an object, you
	must ensure that during construction the current device is same
	one in which the object will be rendered. This is because each
	graphic widget has it's own vogle $\Leftarrow$ $\Rightarrow$
	\X\ color translation table. It is generally a good idea not to
	use g\_color when constructing objects which will be used by
	more than one \Vogle\ device.

    \end{DESC}
    \begin{SEE}
	None.
    \end{SEE}
\end{CD}

\begin{CD}{g\_clipping}
    \USE{\NULLret}{g\_clipping}{boolean}{
	Turn clipping on/off.
    }
    \begin{DESC}
	If {\em boolean} if true turn clipping on. If it is false
	turn clipping off.
    \end{DESC}
    \begin{SEE}
	\SI{g\_viewport}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Viewport commands}

\begin{CD}{g\_viewport}
    \USE{\NULLret}{g\_viewport}{left right bottom top}{
	Set the current viewport using screen coordinates.
    }
    \begin{DESC}
	g\_viewport sets the current viewport using screen coordinates.
	{\em left} and {\em right} are the bounds in the X dimension
	for the viewport. {\em bottom} and {\em top} are the bounds in
	the Y dimension. 
	


    \end{DESC}
    \begin{SEE}
	\SI{g\_pushviewport}{\tclVogle}
	\SI{g\_popviewport}{\tclVogle}
	\SI{g\_getviewport}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_pushviewport}
    \USE{\NULLret}{g\_pushviewport}{}{
	Push the current viewport onto the viewport stack.
    }
    \begin{DESC}
	Each vogle device posseses a viewport stack. g\_pushviewport is
	the operator for pushing the current viewport onto the stack.

	The existence of a viewport stack allows the caller to reset
	the viewport for a sequence of calls without disturbing
	whatever the current viewport is by using sequences of...

	\begin{verbatim}
	    g_pushviewport
	    g_viewport left right bottom top
	    g_popviewport
	\end{verbatim}
	commands.

    \end{DESC}
    \begin{SEE}
	\SI{g\_viewport}{\tclVogle}
	\SI{g\_popviewport}{\tclVogle}
	\SI{g\_getviewport}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_popviewport}
    \USE{\NULLret}{g\_popviewport}{}{
	pop an element off the viewport stack
    }
    \begin{DESC}
	g\_popviewport pops the topmost element from the viewport stack
	and makes it the current viewport. It is an error to pop a non
	existent viewport element.
    \end{DESC}
    \begin{SEE}
	\SI{g\_pushviewport}{\tclVogle}
	\SI{g\_viewport}{\tclVogle}
	\SI{g\_getviewport}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_getviewport}
    \USE{\TclList{left right bottom top}}{g\_getviewport}{}{
	Get the current viewport.
    }
    \begin{DESC}
	g\_getviewport returns as a tcl list the current viewport.
	The list consists of four elements and have the same meaning
	and order as the parameters one supplies for the g\_viewport
	command.
    \end{DESC}

    \begin{GS}{BUGS} 
	You should be able to optionally give g\_getviewport a set of
	variable names and have it use those to place the viewport 
	specifications into.
    \end{GS}

    \begin{SEE}
	\SI{g\_pushviewport}{\tclVogle}
	\SI{g\_viewport}{\tclVogle}
	\SI{g\_getviewport}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_getaspect}
    \USE{aspect}{g\_getaspect}{}{
	Get the aspect ration for the current \Vogle\ device.
    }
    \begin{DESC}
	Get the aspect ratio for the current \Vogle\ device. It is
	returned as a floating point ratio of the width over the height
	of the current \Vogle\ device.
    \end{DESC}
    \begin{SEE}
	\SI{config}{\Tk}
	\SI{winfo}{\Tk}
    \end{SEE}
\end{CD}

\begin{CD}{g\_getfactors}
    \USE{\TclList{wFactor hFactor}}{g\_getfactors}{\OA{wVar} \OA{hVar}}{
	Return the width and height factor. 
    }
    \begin{DESC}
	Return the width and height factor of the current \Vogle\ device.
	The width factor is defined as.
	\begin{verbatim}
	    widthOfDevice / min(widthOfDevice, heightOfDevice)
	\end{verbatim}
	The height factor is defined as.
	\begin{verbatim}
	    heightOfDevice / min(widthOfDevice, heightOfDevice)
	\end{verbatim}

    \end{DESC}
    \begin{SEE}
	\SI{config}{\Tk}
	\SI{winfo}{\Tk}
    \end{SEE}
\end{CD}

\section{Attribute stack commands}

\begin{CD}{g\_pushattributes}
    \USE{\NULLret}{g\_pushattributes}{}{
	Push the top graphic-attribute stack element.
    }
    \begin{DESC}
	\Vogle\ has a graphic attributeList stack. a attributeList
	describes all the painting oriented attributes of the current 
	graphics state. This includes.

	\begin{itemize}
	    \item	color
	    \item	fillstyle
	    \item	hatchstyle
	    \item	textCentering
	    \item	textKerning
	    \item	textHeight
	    \item	textWidth
	    \item	textFont
	\end{itemize}

	g\_pushattributes places  copy of the current attributeList
	on the top of the attribute stack.

    \end{DESC}
    \begin{SEE}
	\SI{g\_popattributes}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_popattributes}
    \USE{\NULLret}{g\_popattributes}{}{
	pop (then use) the top attributeList stack element.
    }
    \begin{DESC}
	g\_popattributes restores the attributes to what they were
	prior to the last call to g\_pushattributes. It is an error
	to pop an empty attribute stack.
    \end{DESC}

    \begin{SEE}
	\SI{g\_popattributes}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Projection commands}

\begin{CD}{g\_ortho}
    \USE{\NULLret}{g\_ortho}{left right top bottom \OA{near} \OA{far}}{
	Define a parallel projection.
    }
    \begin{DESC}
	Define a parallel projection. If near and far are supplied then
	the projection is done for three dimensions. Otherwise it is done
	only in two dimensions.

	g\_ortho specifies a rectilinear mapping from eye-coordinates
	to NDC coordinates.  Think of the coordinates you specify as
	defining a box around the object(s) that you intend to draw.
	Then remember that the near and far specifications are
	distances, not absolute coordinates, that correspond to
	eye-coordinates that are negated.  For example, the ortho
	specification

	\begin{verbatim}
	    g_ortho 1 2 3 4 5 6
	\end{verbatim}

	Specifies an eye-coordinate box of the volume 

	\begin{verbatim}
	    (1 <= x <= 2), (3 <= y <=4), (-5 >= z >= -6).  
	\end{verbatim}

	Anything drawn within this box will be rendered to the window
	(given that you make no other changes to the matrix).

	Since NDC coordinates are mapped to the full window by default,
	your specification of ortho() need not be related to the size
	of the window.

    \end{DESC}
    \begin{SEE}
	\SI{ortho}{\Vogle}
	\SI{ortho2}{\Vogle}
    \end{SEE}
\end{CD}



\begin{CD}{g\_perspective}
    \USE{\NULLret}{g\_perspective}{fieldOfView aspect near far}{
	Specify a perspective viewing pyramid in world coordinates.
    }
    \begin{DESC}
	Specify a perspective viewing pyramid in world coordinates by
	giving  field of view, aspect ratio, and the distance from the
	eye of the near and far clipping planes.
    \end{DESC}

    \begin{SEE}
	\SI{g\_window}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_window}
    \USE{\NULLret}{g\_window}{left right top bottom near far}{
	Specify a perspective viewing pyramid (via a window) in world
	coordinates.
    }
    \begin{DESC}
	Specify a perspective viewing pyramid in world coordinates by
	describing the rectangle closest to the eye (i.e. the near
	clipping plane) and the distances to the near and far clipping
	planes.
    \end{DESC}
    \begin{SEE}
	\SI{g\_perspective}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Matrix stack commands}

\begin{CD}{g\_pushmatrix}
    \USE{\NULLret}{g\_pushmatrix}{}{
	Push the current transform matrix on the the stack.
    }
    \begin{DESC}
	Push the current transform matrix on the the stack.
    \end{DESC}
    \begin{SEE}
	\SI{g\_popmatrix}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_popmatrix}
    \USE{\NULLret}{g\_popmatrix}{}{
	Pop the current transform matrix off the the stack.
    }

    \begin{DESC}
	Retrieve the top element from the transformation matrice stack
	and make it the current transformation matrice. It is an error
	to pop an empty stack.
    \end{DESC}

    \begin{SEE}
	\SI{g\_pushmatrix}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Viewpoint Commands}

\begin{CD}{g\_polarview}
    \USE{\NULLret}{g\_polarview}{distance azimuth increment twist}{
	Specify the viewers position in polar coordinates.
    }
    \begin{DESC}
	Specify the viewers position in polar coordinates.
    \end{DESC}
\end{CD}

\begin{CD}{g\_up}
    \USE{\NULLret}{g\_up}{}{
	Make sure the Y axis is pointing up.
    }
    \begin{DESC}
	Sometimes the g\_up call is needed to make sure the Y axis is
	pointing up. Sometimes the g\_lookat function can turn the Y
	axis upside down if the line of sight crossing the appropriate
	axis.
    \end{DESC}
    \begin{SEE}
	\SI{g\_lookat}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_lookat}
    \USE{\NULLret}{g\_lookat}{viewX viewY viewZ posX posY posZ twist}{
	specify view position by viewpoint and reference point
    }
    \begin{DESC}
	g\_lookat specifies the viewers position by giving a viewpoint
	and a reference point in world coordinates.  A twist about the
	line of sight may also be given.
    \end{DESC}
\end{CD}

\section{Move commands}

\begin{CD}{g\_move}
    \USE{\NULLret}{g\_move}{x y \OA{z}}{
	set the graphics position
    }
    \begin{DESC}
	g\_move moves the current graphics position to point 
	{\tt x,y,z} using world coordinates. The {\tt z} is optional in
	which case it is given a default value of 0. The move is an
	absolute one from the origin.
    \end{DESC}
    \begin{SEE}
	\SI{g\_rmove}{\tclVogle}
	\SI{g\_rsmove}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_rmove}
    \USE{\NULLret}{g\_rmove}{x y \OA{z}}{
	set the graphics position relative to the current position.
    }
    \begin{DESC}
	g\_rmove moves the current graphics position to point {\tt x,y,z} 
	using world coordinates. The {\tt z} is optional in
	which case it is given a default value of 0. The move is an
	relative one from whatever the current position is.
    \end{DESC}
    \begin{SEE}
	\SI{g\_move}{\tclVogle}
	\SI{g\_smove}{\tclVogle}
	\SI{g\_rsmove}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_smove}
    \USE{\NULLret}{g\_smove}{x y}{
	set the graphics position
    }
    \begin{DESC}
	g\_smove moves the current graphics position to point {\tt x,y} 
	using screen coordinates.  The move is a absolute one from the 
	origin.
    \end{DESC}
    \begin{SEE}
	\SI{g\_rmove}{\tclVogle}
	\SI{g\_rsmove}{\tclVogle}
	\SI{g\_move}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_rsmove}
    \USE{\NULLret}{g\_rsmove}{x y}{
	Set the graphics position in screen coordinates relative to the 
	current position.
    }
    \begin{DESC}
	g\_rsmove moves the current graphics position to point {\tt x,y} 
	using screen coordinates.  The move is a relative one from whatever 
	the current position is.
    \end{DESC}
    \begin{SEE}
	\SI{g\_move}{\tclVogle}
	\SI{g\_smove}{\tclVogle}
	\SI{g\_rmove}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Drawing commands}

\begin{CD}{g\_draw}
    \USE{\NULLret}{g\_draw}{x y \OA{z}}{
	draw from graphics position to x y z
    }
    \begin{DESC}
	Draw from the current graphics position in world coordinates
	to x y z. If z is not supplied a default of 0 is used. x y z is
	measured from the origin.
    \end{DESC}
    \begin{SEE}
	\SI{g\_rdraw}{\tclVogle}
	\SI{g\_sdraw}{\tclVogle}
	\SI{g\_rsdraw}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_rdraw}
    \USE{\NULLret}{g\_rdraw}{x y \OA{z}}{
	relative draw from graphics position to x y z
    }
    \begin{DESC}
	Draw from the current graphics position in world coordinates
	to x y z. If z is not supplied a default of 0 is used. x y z
	is measured relative to the current graphics position.
    \end{DESC}
    \begin{SEE}
	\SI{g\_draw}{\tclVogle}
	\SI{g\_sdraw}{\tclVogle}
	\SI{g\_rsdraw}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_sdraw}
    \USE{\NULLret}{g\_sdraw}{x y}{
	screen coordinates draw from graphics position to x y
    }
    \begin{DESC}
	Draw from the current graphics position in screen coordinates
	to x y. x y is measured from the origin.
    \end{DESC}
    \begin{SEE}
	\SI{g\_rdraw}{\tclVogle}
	\SI{g\_draw}{\tclVogle}
	\SI{g\_rsdraw}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_rsdraw}
    \USE{\NULLret}{g\_rsdraw}{x y}{
	relative screen coordinates draw from graphics position to x y
    }
    \begin{DESC}
	Draw from the current graphics position in world coordinates
	to x y. x y is measured relative to the current graphics position.
    \end{DESC}
    \begin{SEE}
	\SI{g\_draw}{\tclVogle}
	\SI{g\_sdraw}{\tclVogle}
	\SI{g\_rdraw}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Arcs and circles} 

\begin{CD}{g\_circleprecision}
    \USE{\NULLret}{g\_circleprecision}{numberOfSegments}{
	Set precision to use in circle drawing
    }
    \begin{DESC}
	g\_circleprecision designates the number of lines segments to
	use in drawing a circle. The {\tt numberOfSegments} argument
	should be a positive integer value.
    \end{DESC}
    \begin{SEE}
	\SI{g\_arc}{\tclVogle}
	\SI{g\_circle}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_arc}
    \USE{\NULLret}{g\_arc}{x y radius startAngle endAngle}{
	draw an arc in world units.
    }
    \begin{DESC}
	Draw an arc in world units. The origin of the arc is placed at
	{\tt x,y} and is swept through from {\tt startAngle} to 
	{\tt endAngle}.
    \end{DESC}
    \begin{SEE}
	\SI{g\_sector}{\tclVogle}
	\SI{g\_circle}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_sector}
    \USE{\NULLret}{g\_sector}{x y radius startAngle endAngle} {
	draw a sector in world units.
    }
    \begin{DESC}
	Draw an sector in world units. The origin of the arc is placed at
	{\tt x,y} and is swept through from {\tt startAngle} to 
	{\tt endAngle}. A sector is drawn using polygon attributes such
	as polyfill and polyhatch.
    \end{DESC}
    \begin{SEE}
	\SI{g\_arc}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_circle}
    \USE{\NULLret}{g\_circle}{x y radius}{
	draw a circle
    }
    \begin{DESC}
	g\_circle draws a circle of {\tt radius} centered at the 
	point {\tt x y} in world units.
    \end{DESC}
    \begin{SEE}
	\SI{g\_circleprecision}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Rectangle and Polygon commands}

\begin{CD}{g\_rect}
    \USE{\NULLret}{g\_rect}{x y x2 y2}{
	draw a rectangle
    }
    \begin{DESC}
	g\_rect draws a rectangle in world units with opposite corners at 
	{\tt x y} and {\tt x2 y2}
    \end{DESC}
    \begin{SEE}
	\SI{g\_rectangle}{\tclVogle}
	\SI{g\_polygon}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_polyfill}
    \USE{\NULLret}{g\_polyfill}{\BooleanArg}{
	turn on/off filling of polygons
    }
    \begin{DESC}
	{\BooleanArg} is a boolean value which designates
	whether polygon type operations are to be filled or not.
	True indicates fill. False means no fill.
    \end{DESC}
    \begin{SEE}
	\SI{g\_polyhatch}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_polyhatch}
    \USE{\NULLret}{g\_polyhatch}{\BooleanArg}{
	{\BooleanArg} is a boolean value which designates whether polygon 
	type operations are to be hatched or not. True indicates hatch. 
	False means no hatch. Turning hatching on automatically turns off 
	filling polygons.
    }
    \begin{DESC}
	turn on/off hatching of polygons
    \end{DESC}
    \begin{SEE}
	\SI{g\_hatchangle}{\tclVogle}
	\SI{g\_hatchpitch}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_hatchangle}
    \USE{\NULLret}{g\_hatchangle}{angle}{
	set the line angle for hatching
    }
    \begin{DESC}
	g\_hatchangle sets the angle for the lines drawn while hatch filling
	polygon style operations.
    \end{DESC}
    \begin{SEE}
	\SI{g\_hatchpitch}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_hatchpitch}
    \USE{\NULLret}{g\_hatchpitch}{angle}{
	set the line pitch for hatching
    }
    \begin{DESC}
	g\_hatchpitch sets the pitch for the lines drawn while hatch filling
	polygon style operations.
    \end{DESC}
    \begin{SEE}
	\SI{g\_hatchangle}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_poly}
    \USE{\NULLret}{g\_poly}{x y z...xN yN zN}{
	draw a N sided polygon in world units
    }
    \begin{DESC}
	Construct a 2 dimensional polygon in world units with points 
	{\tt x y z} through {\tt xN yN zN}.
    \end{DESC}
    \begin{SEE}
	\SI{g\_poly2}{\tclVogle}
	\SI{g\_makepoly}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_poly2}
    \USE{\NULLret}{g\_poly}{x y...xN yN}{
	2d version of g\_poly
    }
    \begin{DESC}
	Construct a 2 dimensional polygon in world units with points 
	{\tt x y} through {\tt xN yN}.
    \end{DESC}
    \begin{SEE}
	\SI{g\_poly}{\tclVogle}
	\SI{g\_makepoly}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_makepoly}
    \USE{\NULLret}{g\_makepoly}{}{
	start construction of a polygon
    }
    \begin{DESC}
	{\bf g\_makepoly} starts construction of a polygon which will be 
	constructed by a series of {\bf g\_move g\_draw} commands.
	The polygon is completed by then calling {\bf g\_closepoly}.
    \end{DESC}
    \begin{SEE}
	\SI{g\_closepoly}{\tclVogle}
	\SI{g\_move}{\tclVogle}
	\SI{g\_draw}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_closepoly}
    \USE{\NULLret}{g\_closepoly}{}{
	end construction of a polygon
    }
    \begin{DESC}
	{\tt g\_closepoly} completes construction of a polygon started
	by {\tt g\_makepoly}.
    \end{DESC}
    \begin{SEE}
	\SI{g\_makepoly}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_backface}
    \USE{\NULLret}{g\_backface}{\BooleanArg}{
	turn backfacing on or off
    }
    \begin{DESC}
	{\bf g\_backface} turns on culling of backface polygons if {\BooleanArg}
	is true. A value of false turns off backface culling.
    \end{DESC}
    \begin{SEE}
	\SI{g\_backfacedir}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_backfaceclockwise}
    \USE{\NULLret}{g\_backfaceclockwise}{\BooleanArg}{
	set direction of backfacing.
    }
    \begin{DESC}
	If {\BooleanArg} is true then the direction of backfacing is
	set to be clockwise. If it is false the the direction is 
	counterclockwise.
    \end{DESC}
    \begin{SEE}
	\SI{g\_backface}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Text commands}

\begin{CD}{g\_font}
    \USE{\NULLret}{g\_font}{fontName}{
	set the current font
    }
    \begin{DESC}

	\Vogle\ supports hardware and software fonts. The software
	fonts are based on the character set digitized by Dr Allen V.
	Hershey while working at the U. S. National Bureau of
	Standards.  Exactly what hardware fonts are supported depends
	on the device, but it is guaranteed that the names "large" and
	"small" will result in something readable. 
	
	For Tk Graphic widgets "small" translates to be whatever font
	was set for the graphic widget either during creation or via a
	subsequent {\it widgetName} {\bf config -font} {\it fontName}
	command.

	Text is always assumed to be drawn parallel to the (x, y)
	plane, using whatever the current z coordinate is. The
	following software fonts are supported:

\begin{verbatim}
	astrology       cursive         cyrillic        futura.l
	futura.m        gothic.eng      gothic.ger      gothic.ita
	greek           markers         math.low        math.upp
	meteorology     music           script          symbolic
	times.g         times.i         times.ib        times.r
	times.rb        japanese
\end{verbatim}

	A markers font {\tt markers} is also provided for doing markers -
	you need to have centertext on for this to give sensible
	results - with the markers starting at 'A' and 'a'.

	If the environment variable {\bf VFONTLIB} is set \Vogle\
	looks for the software fonts in the directory given by this
	value.
    \end{DESC}

\end{CD}

\begin{CD}{g\_numchars}
    \USE{numberOfCharacters}{g\_numchars}{}{
	return number of characters in current font
    }
    \begin{DESC}
	Return the number of characters in the current font. Applicable
	only to software fonts.
    \end{DESC}
\end{CD}

\begin{CD}{g\_textsize}
    \USE{\NULLret}{g\_textsize}{width height}{
	scale the size of the current soft font.
    }
    \begin{DESC}
	Set the maximum size of a character in the current font. Width
	and height are values in world units. This only applies to
	software text. This must be done after the font being scaled is
	loaded.
    \end{DESC}
\end{CD}

\begin{CD}{g\_textangle}
    \USE{\NULLret}{g\_textangle}{angle}{
	set angle of soft text.
    }
    \begin{DESC}
	Set the text angle. This angles strings and chars. This routine
	only affects software text.
    \end{DESC}
\end{CD}

\begin{CD}{g\_fixedwidth}
    \USE{\NULLret}{g\_fixedwidth}{\BooleanArg}{
	Turns fixedwidth text on or off.
    }
    \begin{DESC}

    Turns fixedwidth text on or off. A True value for {\BooleanArg} is
    on. Causes all text to be printed as if the font was fixedwidth
    style font. This command only affects software text.

    \end{DESC}
\end{CD}

\begin{CD}{g\_centertext}
    \USE{\NULLret}{g\_centertext}{\BooleanArg}{
	center and text that is drawn
    }
    \begin{DESC}
	If {\BooleanArg} is true then. Text is drawn centered on the
	current graphics position. Otherwise test is drawn left
	justified to the current graphics position. This command only
	applies to soft fonts.
    \end{DESC}
\end{CD}

\begin{CD}{g\_getcharsize}
    \USE{\TclList{width height}}{g\_getcharsize}{char \OA{wVar} \OA{hVar}}{
	set the size of the supplied character.
    }
    \begin{DESC}
	Get the width and height of character {\tt char}. At the moment
	the height returned is always that of the difference between
	the maximum descender and ascender. If char is more than one
	char all characters past the first are ignored (bug?).
    \end{DESC}
\end{CD}

\begin{CD}{g\_getfontsize}
    \USE{\TclList{width height}}{g\_fontsize}{\OA{wVar} \OA{hVar}}{
	Get the maximum width and height of a character in current font
    }
    \begin{DESC}
	Get the maximum width and height of a character in the current font
    \end{DESC}
    \begin{SEE}
	\SI{g\_getcharsize}{\tclVogle}
    \end{SEE}
\end{CD}


\begin{CD}{g\_drawstr}
    \USE{\NULLret}{g\_drawstr}{string}{
	draw string at the current graphics position
    }
    \begin{DESC}
	Draw the text in {\tt string} at the current position.
    \end{DESC}
\end{CD}

\begin{CD}{g\_strlength}
    \USE{\NULLret}{g\_strlength}{string}{
	return length of string in world units.
    }
    \begin{DESC}
	{\tt g\_strlength} return the length of {\tt string} in world units.
    \end{DESC}
    \begin{SEE}
	\SI{g\_getcharsize}{\tclVogle}
	\SI{g\_getfontsize}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_boxtext}
    \USE{\NULLret}{g\_boxtext}{x y w h string}{
	draw string in box of dimension x y w h
    }
    \begin{DESC}
	Draw {\tt string} so that it fits in the imaginary box defined
	with bottom left hand corner at {\tt x, y} width {\tt w}, and height 
	{\tt h}. This only applies to software text
    \end{DESC}
    \begin{SEE}
	\SI{g\_drawtext}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_boxfit}
    \USE{\NULLret}{g\_boxfit}{w h numberOfChars}{
	scale text to fit in bounding box for any string n chars in length
    }
    \begin{DESC}
	Set scale for text so that a string of the biggest characters
	in the font will fit in a box w by h. w and h are values
	in world units.  This only applies to software text.
    \end{DESC}
\end{CD}

\section{Transformation commands}

    Transformation commands are for altering the current transformation
    matrice. This matrix is what is used to map screen units into world
    units.

    With the exeception of {\bf g\_identtrans}, all transformations are
    cumulative, so if you rotate something and then do a translate you
    are translating relative to the rotated axes. If you need to
    preserve the current transformation matrix use {\bf
    g\_pushmatrix()} do the drawing, and then call {\bf popmatrix} to
    get back where you were before.

\begin{CD}{g\_identtrans}
    \USE{\NULLret}{g\_identtrans}{}{
	Replace the current transform with the identity matrix.
    }
    \begin{DESC}
	{\bf g\_identtrans} {\em resets} the current transform to
	the identity matrix. This means that screen units and world
	units become equivalent. This function is handy 
	when a set of drawing commands needs a particular transform
	relative to screen coordinates. It relieves the code from having
	to undo any transform currently in place.

    \begin{EG}{
	Below is an example using of how this is done.
    } \begin{verbatim}
	g_pushmatrix
	g_identtrans
	    .
	    ... whatever temporary well known transform is needed
	    .
	    ... whatever drwing commands are desired
	    .
	g_popmatrix
    \end{verbatim} \end{EG}

    \end{DESC}
\end{CD}

\begin{CD}{g\_translate}
    \USE{\NULLret}{g\_translate}{x y {\OA z}}{
	translate the current transform
    }
    \begin{DESC}
	{\bf g\_translate} alters the current transform such that
	any point plotted is removed a distance {\bf (x,y,z)} from
	where it would of been prior to performing the transform.
    \end{DESC}
\end{CD}

\begin{CD}{g\_scale}
    \USE{\NULLret}{g\_scale}{xScale yScale {\OA zScale}}{
	scale the current transform. 
    }
    \begin{DESC}
	{\bf g\_scale} scales the current transform up {\tt xScale} units in
	the {\it X} dimension {\tt yScale} units in the {\it Y} dimension 
	and {\tt zScale} units in the {\it Z} dimension.
    \end{DESC}
\end{CD}


\begin{CD}{g\_rotate}
    \USE{\NULLret}{g\_rotate}{angle axis}{
	rotate the current transform around an axis
    }
    \begin{DESC}
	Rotate the current transform {\tt} angle degrees around
	{\tt axis} which is designated as either {\bf x}, {\bf y}, 
	or {\bf z}
    \end{DESC}
\end{CD}

\section{Point commands}

\begin{CD}{g\_point}
    \USE{\NULLret}{g\_point}{x y \OA{z}}{
	draw a point
    }
    \begin{DESC}
	Draw a point at {\tt x y z} in world units. {\tt z} is set to 0.0
	if it is not specified.
    \end{DESC}
\end{CD}

\section{Object commands}

    Objects are graphical entities created by the drawing routines 
    called between {\bf makeobj} and {\bf closeobj}.

    Objects may be called from within other objects. When an object is
    created most of the calculations required by the drawing routines
    called within it are done up to where the calculations involve the
    current transformation matrix. So if you need to draw the same
    thing more than one or two times it is faster to use objects than
    to call the appropriate drawing routines each time. Objects also
    have the advantage of being saveable to a file, from where they can
    be reloaded for later reuse.

    In an interpretive environment such as \Tcl\, using objects are
    even more efficient since a sequence of commands need only be
    interpreted once

    Routines which draw or move in screen coordinates, or change
    device, cannot be included in objects.

\begin{CD}{g\_makeobj}
    \USE{\NULLret}{g\_makeobj}{objectID}{
	Begin construction of {\tt objectID}
    }
    \begin{DESC}
	Begin construction of an object using {\tt objectID} as the identifier
	for the object. If an object previously existed as {\tt objectID} it
	is destroyed.
    \end{DESC}
    \begin{SEE}
	\SI{g\_closeobj}{\tclVogle}
	\SI{g\_genobj}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_closeobj}
    \USE{\NULLret}{g\_closeobj}{}{
	close the current object
    }
    \begin{DESC}
	Close the object begun with the {\bf g\_makeobj} command.
    \end{DESC}
    \begin{SEE}
	\SI{g\_makeobj}{\tclVogle}
	\SI{g\_genobj}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_genobj}
    \USE{identifier}{g\_genobj}{}{
	return a unique identifier for use by {\bf g\_makeobj}
    }
    \begin{DESC}
	{\bf g\_genobj} returns a unique identifier for use by 
	{\bf g\_makeobj}. This is the preferred method in assigning
	a object identifier.
    \end{DESC}
    \begin{EG}{
	Below is an example using of how this is done.
    } \begin{verbatim}
	g_makeobj [set my objectID [g_genobj]]
	    .
	    ... various g_whatever operations here ...
	    .
	g_closeobj
    \end{verbatim} \end{EG}
    \begin{SEE}
	\SI{g\_makeobj}{\tclVogle}
	\SI{g\_genobj}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_getopenobj}
    \USE{identifier}{g\_getopenobj}{}{
	return the Id for the current object under construction
    }
    \begin{DESC}
	Return the identifier for the object currently under construction.
    \end{DESC}
    \begin{SEE}
	\SI{g\_makeobj}{\tclVogle}
	\SI{g\_genobj}{\tclVogle}
	\SI{g\_closeobj}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_loadobj}
    \USE{\NULLret}{g\_loadobj}{objectID fileName}{
	Load the object in fileName into objectID.
    }
    \begin{DESC}
	Load the object in fileName into objectID.  if object with ID
	{\tt objectID} does not exist.  a new one is made. If it does
	exists is is overwritten.
    \end{DESC}
    \begin{SEE}
	\SI{g\_saveobj}{\tclVogle}
	\SI{g\_genobj}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_saveobj}
    \USE{\NULLret}{g\_saveobj}{objectID fileName}{
	Save objectID into fileName
    }
    \begin{DESC}
	Save the object objectID into fileName. This call does {\em not}
	save objects called inside object n.
    \end{DESC}
    \begin{SEE}
	\SI{g\_loadobj}{\tclVogle}
    \end{SEE}
\end{CD}

\section{Double Buffering}

    Where possible \Vogle\ allows for front and back buffers to enable
    things like animation and smooth updating of the screen. The
    command {\bf g\_backbuffer} is used to initialise double
    buffering.  The Tk graphic \Vogle\ device supports double buffering
    via offscreen {\bf X} pixmaps.

\begin{CD}{g\_backbuffer}
    \USE{\NULLret}{g\_backbuffer}{}{
	draw in the offscreen buffer
    }
    \begin{DESC}
	Tell \Vogle\ to draw in the offscreen buffer. This does nothing if 
	double buffering is not supported by the underlying \Vogle\ 
	device.
    \end{DESC}
    \begin{SEE}
	\SI{g\_frontbuffer}{\tclVogle}
	\SI{g\_swapbuffers}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_frontbuffer}
    \USE{\NULLret}{g\_frontbuffer}{}{
	draw in the onscreen buffer
    }
    \begin{DESC}
	Tell \Vogle\ to draw in the onscreen buffer. 
    \end{DESC}
    \begin{SEE}
	\SI{g\_backbuffer}{\tclVogle}
	\SI{g\_swapbuffers}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_swapbuffers}
    \USE{\NULLret}{g\_swapbuffers}{}{
	Swap" the front and back buffers". 
	blit the offscreen buffer onscreen.
    }
    \begin{DESC}
	'Swap' the front and back buffers. In may cases this may not be
	a true swap. For example, most X related devices this will most
	likely just blit the offscreen buffer onscreen.
    \end{DESC}
    \begin{SEE}
	\SI{g\_backbuffer}{\tclVogle}
	\SI{g\_frontbuffer}{\tclVogle}
    \end{SEE}
\end{CD}

%% 

\section{Other commands}

\begin{CD}{g\_getgp}
    \USE{\TclList{x y z}}{g\_getgp}{\OA{xVar} \OA{yVar} \OA{zVar}}{
	Return the current in world coordinates.
    }
    \begin{DESC}
	g\_getgp (get graphics position) returns as a list the current x
	y z graphics position in world coordinates.

	The xVar, yVar, and zVar are all optional arguments.

	If xVar is supplied, then the x value for the current
	graphics position is also placed into the local variable
	xVar.

	If yVar is supplied, then the y value for the current
	graphics position is also placed into the local variable
	yVar.

	If zVar is supplied, then the z value for the current
	graphics position is also placed into the local variable
	zVar.
    \end{DESC}
    \begin{SEE}
	\SI{g\_toworld}{\tclVogle}
	\SI{g\_toscreen}{\tclVogle}
    \end{SEE}
\end{CD}

\begin{CD}{g\_toscreen}
    \USE{\TclList{x y z}}{g\_toscreen}{xArg yArg \OA{xVar} \OA{yVar}}{
	Return the current graphics position in screen coordinates.
    }
    \begin{DESC}
	g\_toscreen returns as a list the current x y z graphics position
	in screen coordinates of the values xArg yArg which are
	regarded as device coordinates. In the case of a \Tk\ Graphics
	device, the device coordinates are the X11 coordinates for the
	corresponding \Tk\ drawing widget
    \end{DESC}
    \begin{SEE}
	\SI{g\_toworld}{\tclVogle}
	\SI{g\_getgp}{\tclVogle}
	\SI{bind}{\Tk}
    \end{SEE}
\end{CD}

\begin{CD}{g\_toworld}

    \USE{\TclList{x y z}}{g\_toworld}{xArg yArg \OA{xVar} \OA{yVar}}{
	Return the current graphics position in world coordinates.
    }

    \begin{DESC}
	g\_toworld returns as a list the current x y z graphics position
	in world coordinates of the values xArg yArg which are
	regarded as device coordinates. In the case of a \Tk\ Graphics
	device, the device coordinates are the X11 coordinates for the
	corresponding \Tk\ graphics widget
    \end{DESC}

    \begin{SEE}
	\SI{g\_toscreen}{\tclVogle}
	\SI{g\_getgp}{\tclVogle}
	\SI{bind}{\Tk}
    \end{SEE}

\end{CD}

\section{Correspondence}

    Send correspondence to me at the email address

    {\tt mh@awds.imsd.contel.com}
    
    I am interested in any comments good or bad that you might have.

\section{Things to be done}

    Below is the start of a {\it To Do} list. Volunteers for items
    below and others not mentioned are most welcome. I ask that you
    check with me before tackling an item since work on it might
    already be under way.

\subsection{Probably}
\begin{description}
\item[objects]		{there is no way in \Vogle\ to destroy an object. 
			 need to make one}
\item[error\ handling]	{vogle handles errors by just printing the error
			and exiting. Need to provide better handling of 
			non-fatal errors and a way to perform user-defined 
			error handling}
\item[lines]		{Add linewidths linestyles linecaps attributes}
\item[lines]		{add multi line command}
\item[polygon]		{add multi polygon command}
\item[markers]		{Add user defineable markers}
\item[vogle]		{make a some more higher device primitives for devices
			 that can support it like rectangles and circles 
			 for example}.
\item[symbolic\ lines]	{Add user defineable symbolic lines}
\item[accleration]	{Add support for sun's XGL as TK graphic vogle device}
\item[C support]	{Add code to allow C callbacks for the \Tk\ Graphic
			 painting in addition to the \Tcl\ callbacks}
\end{description}

\subsection{Maybe}
\begin{description}
\item[vogl]		{now that open GL exists, use vogl instead of vogle ?? }
\item[color]		{Add colormap double buffering}
\end{description}

%%%%%%%%%%%%%%%%%%%%%%%%%
\end{document}
