.Dd January 30, 1994
.Dt MIDIRECORD N
.Os
.Sh NAME
.Nm midirecord
.Nd "tclmidi command to record a MIDI song"
.Sh SYNOPSIS
.Nm
.Ar RecMidiID
.Op PlayMidiID Op repeat
.Sh DESCRIPTION
.Nm
is a
.Xr tclmidi 1
command that records events from a \%MIDI
device and puts them in a \%MIDI song.
Currently, only MPU-401 compatible cards in UART mode are
supported.
A device driver for the MPU-401 is included with this
release for the following architectures:
.Bl -item -offset indent -compact
.It
BSD/386
.It
386BSD and variants
.It
SVR4
.It
Linux
.El
.Pp
The first argument to
.Nm
is the \%MIDI song descriptor of the record song.
It should be one returned from
.Xr midimake n
or
.Xr midiread n .
The second argument is an optional \%MIDI song descriptor
for a song that should be played while recording.
Furthermore, an optional third argument of ``repeat'' may be specified
so the play song will be repeated.
.Pp
Recording continues until the
.Xr midistop n
command is issued.
.Xr midiwait n
may be used to block until the play song finishes.
.Pp
All recorded events are put into track 0 of the \%MIDI song.
.Sh RETURN VALUES
.Nm
returns immediately with 0
if no \%MIDI devices are available, or
1 if one is.
.Sh BUGS
The MPU-401 device interface
dynamically creates events in the record \%MIDI song
asynchronously.
Since this involves a call to
.Xr malloc 3
which
is not re-entrant, this is a potential hazard.
Until I figure out a way around this, avoid other
calls to
.Xr malloc 3
while recording.
Threads would provide a good way to work around this, but
until they are more common, we'll just have to be careful.
.Sh SEE ALSO
.Xr tclm 1 ,
.Xr midiplay n ,
.Xr midiread n ,
.Xr midimake n ,
.Xr midistop n ,
.Xr midiwait n
.Sh AUTHOR
Mike Durian - durian@boogie.com
