.TH "ipcNewSender" TCL "" "TCL"
.ad b
.SH NAME
ipcNewSender, ipcDestroySender, ipcDestroySenderFromHandle - create and destroy tclIPC senders.
.SH SYNOPSIS
.PP
.nf
.ft CW
#include <tclipc.h>

Sender
ipcNewSender(Tcl_Interp *interp,
               char *label, 
               char *hostName,
               char *portManHost);

int
ipcDestroySender(Tcl_Interp *interp, 
                 Sender sender);

int
ipcDestroySenderFromHandle(Tcl_Interp *interp,
                           char *handle);
.ft R
.fi
'
.SH DESCRIPTION
.PP
These functions allow the C programmer to create and destroy \fBtclIPC\fR senders.
'
.SS ipcNewSender
.PP
Create a new sender.  The sender is an opaque structure.  The PortManager on machine portManHost is contacted and asked to return information on a receiver represented by the label/hostName pair.  hostName can be the string "AnyHost", which indicates that the PortManager should match using only the label and return the first matching entry.
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR -  Any error messages generated will be returned in this interpreter's result.
.br
.PP
\fBo \fIlabel\fR - This string value is used to identify this sender when it is registered with the PortManager.
.br
.PP
\fBo \fIhostName\fR - This machine is the desired location of the target receiver.  hostName can be "AnyHost" if it doesn't matter which machine the receiver with name label is located.
.br
.PP
\fBo \fIportManHost\fR - The name of the machine where the PortManager that should be used to search for this receiver is located.
.br
.RE
.PP
Returns:
.RS 2
Returns NULL if the new sender could not be created.  The result string of the Tcl_Interp is set to the cause.  The successful function call returns a new, connected sender ready to use.
.RE
'
.SS ipcDestroySender
.PP
Delete a sender and the resources associated with the sender.  The input argument is an opaque sender structure.  No PortManager is contacted although the destination receiver is notified of the broken connection.
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR - Any error message will be returned in the result of this interpreter.
.br
.PP
\fBo \fIsender\fR - A sender structure as returned by ipcNewSender.
.br
.RE
.PP
Returns:
.RS 2
TCL_OK if the sender was destroyed or TCL_ERROR if an error was generated during the destruction.
.RE
'
.SS ipcDestroySenderFromHandle
.PP
Delete a sender and the resources associated with the sender.  The input argument is an IPC handle name.  The sender connection is notified of the broken connection.
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR - Any error message will be returned in the result of this interpreter.
.br
.PP
\fBo \fIhandle\fR - A string-valued IPC handle as returned by the TCL \fBsender new\fR command.  This is an Extended-TCL handle.
.RE
.PP
Returns:
.RS 2
TCL_OK if the sender was destroyed or TCL_ERROR if an error was generated during the destruction.
.RE
'
