/* 
 * tmTclCommands.c --
 *
 *	This file contains the loader for the commands recognised
 *	by the moat interpreter to give Motif support.
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.

 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header$";
#endif
#include "tm.h"
#include "tmFuncs.h"

#include <X11/Intrinsic.h>
#include <Xm/ArrowB.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Command.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>


/*
 * The following structure defines all of the commands supported by
 * Tm, and the C procedures that execute them.
 */

typedef struct {
    char *name;			/* Name of command. */
    int (*cmdProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	    int argc, char **argv));
				/* Command procedure. */
    int (*widgetCmdProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	    int argc, char **argv));
				/* Widget Command procedure. */
} TmCmd;

TmCmd commands[] = {
    /*
     * Commands that are part of the intrinsics:
     */

    /*
     * Widget-creation commands.
     */
    {ArrowButton,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {BulletinBoard,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {BulletinBoardDialog, Tm_DialogCmd, Tm_AnyWidgetCmd},
    {CascadeButton,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {Command,		Tm_AnyCmd, Tm_CommandWidgetCmd},
    {DialogShell,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {DrawingArea,	Tm_AnyCmd, Tm_DrawnWidgetCmd},
    {DrawnButton,	Tm_AnyCmd, Tm_DrawnWidgetCmd},
    {ErrorDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {FileSelectionBox,	Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {FileSelectionDialog, Tm_DialogCmd, Tm_AnyWidgetCmd},
    {Form,		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {FormDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {Frame,		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {InformationDialog, Tm_DialogCmd, Tm_AnyWidgetCmd},
    {Label,		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {List,		Tm_AnyCmd, Tm_ListWidgetCmd},
    {MainWindow,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {MenuBar,		Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {MessageBox,	Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {MessageDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {OptionMenu,	Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {PanedWindow,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {PopupMenu,		Tm_RowColumnCmd, Tm_PopupMenuWidgetCmd},
    {PromptDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {PulldownMenu,	Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {PushButton,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {QuestionDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {RowColumn,		Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {Scale,		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {ScrollBar,		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {ScrolledList,	Tm_ScrolledCmd, Tm_ListWidgetCmd},
    {ScrolledText,	Tm_ScrolledCmd, Tm_TextWidgetCmd},
    {ScrolledWindow,	Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {SelectionBox,	Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {SelectionDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {Separator,		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {Text,		Tm_AnyCmd, Tm_TextWidgetCmd},
    {TextField,		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {ToggleButton,	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {TopLevelShell,	Tm_AnyCmd, Tm_ShellWidgetCmd},
    {WarningDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {WorkingDialog,	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {(char *) NULL,	(int (*)()) NULL, (Tm_WidgetCmdProc) NULL}
};

void Tm_LoadWidgetCommands (interp)
    Tcl_Interp *interp;
{
    register TmCmd *cmdPtr;

    /*
     * Bind in Tm's commands.
     */

    for (cmdPtr = commands; cmdPtr->name != NULL; cmdPtr++) {
	Tcl_CreateCommand(interp, cmdPtr->name, cmdPtr->cmdProc,
		(ClientData) cmdPtr->widgetCmdProc, (void (*)()) NULL);
    }
}

