/* 
 * tmCommands.c --
 *
 *	This module implements the tcl widget commands
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header";
#endif

#include "tm.h"
#include "tmFuncs.h"
#ifndef MOTIF11
#include <Xm/DragDrop.h>
#endif
#include <Xm/Command.h>
#include <Xm/List.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
		
/*--------------------------------------------------------------
 *
 * Tm_AnyWidgetCmd --
 *
 *	This procedure is invoked to process the Tcl command
 *	that corresponds to a widget managed by this module.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

int
Tm_AnyWidgetCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Information about button widget. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w = wPtr->widget;
    char c;
    Arg args[TM_MAXARGS];
    int num_args;
    int bool_val;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }
    c = argv[1][0];


    if ((c == 'c') && (strcmp(argv[1], "callActionProc") == 0)) {
	XEvent xev;
	char *action;
	char *params[TM_NUM_PARAMS];
	Cardinal num_params;

	if (argc < 3) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s callActionProc \
action", argv[0]);
	    goto error;
	}

	if (Tm_MakeXEvent(wPtr->widget, interp, &xev, argc-3, argv+3) == TCL_ERROR)
	   return TCL_ERROR;
	Tm_ClearResult(interp);
	Tm_StartSavingResult(interp);
	if (Tm_ParseAction(argv[2], &action, params, &num_params) != TCL_OK) {
	    Tm_StopSavingResult(interp);
	    XtFree(action);
	    sprintf(interp->result, "parse error in action \"%.50s\"", argv[2]);
	    return TCL_ERROR;
	}

	XtCallActionProc(wPtr->widget, action, &xev, params, num_params);
	
	XtFree(action);
	Tm_StopSavingResult(interp);
	Tcl_SetResult(interp, Tm_Result(interp), TCL_VOLATILE);

	return TCL_OK;
    } else

    if ((c == 'd') && (strcmp(argv[1], "destroyWidget") == 0)) {
	/* destroy - most stuff done in DestroyWidgetHandler */

	XtDestroyWidget(wPtr->widget);
    } else

#ifndef MOTIF11
    if ((c == 'd') && (strcmp(argv[1], "dragStart") == 0)) {
        Arg args[TM_MAXARGS];
        int num_args;
	Widget w;
	extern XEvent *Tm_HackXEvent;	/* global hack to get event right here */
	extern Tm_Widget *Tm_HackDragWidgetPtr; /* hack to get wPtr into StrFunc
					converter and to ConvertProcHandler */

/*
	Tm_DropSiteSetValues(wPtr->pathName, interp, wPtr->widget,
                                argv+2, argc-2, args, &num_args);
*/
	Tm_HackDragWidgetPtr = wPtr;

	w = XmDragStart(wPtr->widget, Tm_HackXEvent, NULL, 0);
	Tm_SetValues(wPtr->pathName, interp, w, w, XtClass(w),
				argv+2, argc-2, args, &num_args);
	XtSetValues(w, args, num_args);
 
    } else

    if ((c == 'd') && (strcmp(argv[1], "dropSiteRegister") == 0)) {
        Arg args[TM_MAXARGS];
        int num_args;

	Tm_DropSiteSetValues(wPtr->pathName, interp, wPtr->widget,
                                argv+2, argc-2, args, &num_args);
	XmDropSiteRegister(wPtr->widget, args, num_args);
 
    } else
#endif

    if ((c == 'g') && (strcmp(argv[1], "getGC") == 0)) {
	if (argc < 4) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s setValues \
-option value...", argv[0]);
	    goto error;
	}
	interp->result =
	    Tm_GetGC(wPtr->pathName, interp, (Widget) wPtr->widget, 
				XtClass(wPtr->widget), argv+2, argc-2);
    } else

    if ((c == 'g') && (strcmp(argv[1], "getValues") == 0)) {
	if (argc < 4) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s setValues \
-option value...", argv[0]);
	    goto error;
	}
	if (Tm_GetValues(wPtr->pathName, interp, (Widget) wPtr->widget, 
			XtClass(wPtr->widget), argv+2, argc-2) == TCL_ERROR)
	    return TCL_ERROR;
    } else

    if ((c == 'i') && (strcmp(argv[1], "isComposite") == 0)) {
	if (XtIsComposite(wPtr->widget)) {
	    interp->result = "true";
	} else {
	    interp->result = "false";
	}
    } else

    if ((c == 'i') && (strcmp(argv[1], "isConstraint") == 0)) {
	if (XtIsConstraint(wPtr->widget)) {
	    interp->result = "true";
	} else {
	    interp->result = "false";
	}
    } else

    if ((c == 'i') && (strcmp(argv[1], "isManaged") == 0)) {
	if (XtIsManaged(wPtr->widget)) {
	    interp->result = "true";
	} else {
	    interp->result = "false";
	}
    } else

    if ((c == 'i') && (strcmp(argv[1], "isSensitive") == 0)) {
	if (XtIsSensitive(wPtr->widget)) {
	    interp->result = "true";
	} else {
	    interp->result = "false";
	}
    } else

    if ((c == 'i') && (strcmp(argv[1], "isShell") == 0)) {
	if (XtIsShell(wPtr->widget)) {
	    interp->result = "true";
	} else {
	    interp->result = "false";
	}
    } else

    if ((c == 'm') && (strcmp(argv[1], "manageChild") == 0)) {
	/* manageChild */
	XtManageChild(wPtr->widget);
    } else

    if ((c == 'm') && (strcmp(argv[1], "mapWidget") == 0)) {
	XtMapWidget(wPtr->widget);
    } else

    if ((c == 'p') && (strcmp(argv[1], "parent") == 0)) {
	Tcl_SetResult(interp, XtNewString(wPtr->parent), 
			TCL_DYNAMIC);
    } else

    if ((c == 'p') && (strcmp(argv[1], "processTraversal") == 0)) {
	XmTraversalDirection direction;

	if (argc != 3) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s processTraversal \
direction", argv[0]);
	    goto error;
	}

	if (strcmp(argv[2], "current") == 0) {
	    direction = XmTRAVERSE_CURRENT;
	} else
	if (strcmp(argv[2], "down") == 0) {
	    direction = XmTRAVERSE_DOWN;
	} else
	if (strcmp(argv[2], "home") == 0) {
	    direction = XmTRAVERSE_HOME;
	} else
	if (strcmp(argv[2], "left") == 0) {
	    direction = XmTRAVERSE_LEFT;
	} else
	if (strcmp(argv[2], "next") == 0) {
	    direction = XmTRAVERSE_NEXT;
	} else
	if (strcmp(argv[2], "next_tab_group") == 0) {
	    direction = XmTRAVERSE_NEXT_TAB_GROUP;
	} else
	if (strcmp(argv[2], "prev") == 0) {
	    direction = XmTRAVERSE_PREV;
	} else
	if (strcmp(argv[2], "prev_tab_group") == 0) {
	    direction = XmTRAVERSE_PREV_TAB_GROUP;
	} else
	if (strcmp(argv[2], "right") == 0) {
	    direction = XmTRAVERSE_RIGHT;
	} else
	if (strcmp(argv[2], "up") == 0) {
	    direction = XmTRAVERSE_UP;
	} else {
	    sprintf(interp->result, "unknown traversal option \"%s\"", argv[2]);
	    return TCL_ERROR;
	} 	
	
	XmProcessTraversal(w, direction);
	return TCL_OK;
    } else

    if ((c == 'r') && (strcmp(argv[1], "realizeWidget") == 0)) {
	XtRealizeWidget(wPtr->widget);
    } else

    if ((c == 'r') && (strcmp(argv[1], "resources") == 0)) {
	Tm_ResourceList(interp, wPtr->widget, XtClass(wPtr->widget));
    } else

    if ((c == 's') && (strcmp(argv[1], "setSensitive") == 0)) {
	/* set Sensitive */
	if (argc < 3) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s setSensitive \
-option value", argv[0]);
	    goto error;
	}
	if (Tcl_GetBoolean(interp, argv[2], &bool_val) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XtSetSensitive(wPtr->widget, bool_val);
    } else

    if ((c == 's') && (strcmp(argv[1], "setValues") == 0)) {
	if (argc < 4) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s setValues \
-option value...", argv[0]);
	    goto error;
	}
	if ( ! XtIsShell(wPtr->widget)) {
	    /* this case to prevent Xt errors on XtParent of "." */
	    if (Tm_SetValues(wPtr->pathName, interp, wPtr->widget,
			XtParent(wPtr->widget), 
			XtClass(wPtr->widget), argv+2,
			argc-2, args, &num_args) == TCL_ERROR)
		return TCL_ERROR;
	} else {
	    if (Tm_SetValues(wPtr->pathName, interp, wPtr->widget,
			wPtr->widget, 
			XtClass(wPtr->widget), argv+2,
			argc-2, args, &num_args) == TCL_ERROR)
		return TCL_ERROR;
	}
	XtSetValues(wPtr->widget, args, num_args);
    } else
    if ((c == 'u') && (strcmp(argv[1], "unmanageChild") == 0)) {
	/* unmanage child */
	XtUnmanageChild(wPtr->widget);
    } else

    if ((c == 'u') && (strcmp(argv[1], "unmapWidget") == 0)) {
	XtUnmapWidget(wPtr->widget);
    } else

    if (strstr(argv[1], "Callback") != NULL) {
	Tm_ClientData *client_data;

	client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
	client_data->callback_func = XtNewString(argv[2]);
	client_data->widget_info = wPtr;
	XtAddCallback(wPtr->widget, argv[1], Tm_WidgetCallbackHandler,
		(XtPointer) client_data);
    } else {
	goto error;
    }
    return TCL_OK;

    error:
    sprintf(interp->result, "%s: unknown option \"%s\"", argv[0], argv[1]);
    return TCL_ERROR;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_CommandWidgetCmd --
 *
 *	This function processes the commands that may be applied
 *	to a command widget.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_CommandWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w;
    char c;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }

    w = wPtr -> widget;

    c = argv[1][0];
    if ((c == 'a') && (strcmp(argv[1], "appendValue") == 0)) {
	XrmValue from, toItem;
	XmString xmstr;

	if (argc != 4) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s appendValue command\"",
		argv[0]);
	    return TCL_ERROR;
	}

	from.addr = argv[2];
	from.size = strlen(argv[2]) + 1;
	toItem.addr = (caddr_t) &xmstr;
	toItem.size = sizeof(XmString *);
	XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmCommandAppendValue(w, *(XmString *) toItem.addr);
    } else

    if ((c == 'e') && (strcmp(argv[1], "error") == 0)) {
        XrmValue from, toItem;
        XmString xmstr;

        if (argc != 4) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s error msg\"",
                argv[0]);
            return TCL_ERROR;
        }

        from.addr = argv[2];
        from.size = strlen(argv[2]) + 1;
        toItem.addr = (caddr_t) &xmstr;
        toItem.size = sizeof(XmString *);
        XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

        XmCommandError(w, *(XmString *) toItem.addr);
    } else

    if ((c == 's') && (strcmp(argv[1], "setValue") == 0)) {
        XrmValue from, toItem;
        XmString xmstr;

        if (argc != 4) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setValue command\"",
                argv[0]);
            return TCL_ERROR;
        }

        from.addr = argv[2];
        from.size = strlen(argv[2]) + 1;
        toItem.addr = (caddr_t) &xmstr;
        toItem.size = sizeof(XmString *);
        XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

        XmCommandSetValue(w, *(XmString *) toItem.addr);
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}



/*
 *--------------------------------------------------------------
 *
 * Tm_ListWidgetCmd --
 *
 *	This function processes the commands that may be applied
 *	to a list widget.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_ListWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w;
    char c;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }

    w = wPtr -> widget;

    c = argv[1][0];

    if ((c == 'a') && (strcmp(argv[1], "addItem") == 0)) {
	/* add item */
	XrmValue from, toItem;
	int position;
	XmString xmstr;

	if (argc != 4) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s addItem item position\"",
		argv[0]);
	    return TCL_ERROR;
	}

	if (Tcl_GetInt(interp, argv[3], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}

	from.addr = argv[2];
	from.size = strlen(argv[2]) + 1;
	toItem.addr = (caddr_t) &xmstr;
	toItem.size = sizeof(XmString *);
	XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmListAddItem(w, *(XmString *) toItem.addr, position);
	/* don't free this sucker! DestroyWidget will look after it!!!
	    XmStringFree(*(XmString *) toItem.addr);
	 */
/*
	xmstr = XmStringCreateLocalized(argv[2]);
	XmListAddItem(w, xmstr, position);
	XmStringFree(xmstr);
*/
    } else

    if ((c == 'a') && (strcmp(argv[1], "addItemUnselected") == 0)) {
	/* add item */
	XrmValue from, toItem;
	int position;
	XmString xmstr;

	if (argc != 4) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s addItem item position\"",
		argv[0]);
	    return TCL_ERROR;
	}

	if (Tcl_GetInt(interp, argv[3], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}

	from.addr = argv[2];
	from.size = strlen(argv[2]) + 1;
	toItem.addr = (caddr_t) &xmstr;
	toItem.size = sizeof(XmString *);
	XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmListAddItemUnselected(w, *(XmString *) toItem.addr, position);
	/* don't free this sucker! DestroyWidget will look after it!!!
	    XmStringFree(*(XmString *) toItem.addr);
	 */
    } else

#ifndef MOTIF11
    if ((c == 'd') && (strcmp(argv[1], "deleteAllItems") == 0)) {
	XmListDeleteAllItems(w);
    } else
#endif

    if ((c == 'd') && (strcmp(argv[1], "deleteItem") == 0)) {
	XrmValue from, toItem;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s deleteItem item\"",
		argv[0]);
	    return TCL_ERROR;
	}
	from.addr = argv[2];
	from.size = strlen(argv[2]) + 1;
	toItem.addr = NULL;
	XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmListDeleteItem(w, *(XmString *) toItem.addr);

	/* don't free this sucker! DestroyWidget will look after it!!!
	    XmStringFree(*(XmString *) toItem.addr);
	 */
    } else

    if ((c == 'd') && (strcmp(argv[1], "deletePosition") == 0)) {
	int position;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s deletePosition position\"",
		argv[0]);
	    return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XmListDeletePos(w, position);
    } else

    if ((c == 'd') && (strcmp(argv[1], "deselectAllItems") == 0)) {
	XmListDeselectAllItems(w);
    } else

    if ((c == 'd') && (strcmp(argv[1], "deselectItem") == 0)) {
	XrmValue from, toItem;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s deselectItem item\"",
		argv[0]);
	    return TCL_ERROR;
	}
	from.addr = argv[2];
	from.size = strlen(argv[2]) + 1;
	toItem.addr = NULL;
	XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmListDeselectItem(w, *(XmString *) toItem.addr);

	/* don't free this sucker! DestroyWidget will look after it!!!
	    XmStringFree(*(XmString *) toItem.addr);
	 */
    } else

    if ((c == 'd') && (strcmp(argv[1], "deselectPosition") == 0)) {
	int position;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s deselectPosition position\"",
		argv[0]);
	    return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XmListDeselectPos(w, position);
    } else

    if ((c == 'i') && (strcmp(argv[1], "itemExists") == 0)) {
	XrmValue from, toItem;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s itemExists item\"",
		argv[0]);
	    return TCL_ERROR;
	}
        from.addr = argv[2];
        from.size = strlen(argv[2]) + 1;
        toItem.addr = NULL;
        XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	if (XmListItemExists(w, *(XmString *) toItem.addr)) {
	    sprintf(interp->result, "true");
	} else {
	    sprintf(interp->result, "false");
	}
    } else

#ifndef MOTIF11
    if ((c == 'i') && (strcmp(argv[1], "itemPosition") == 0)) {
	XrmValue from, toItem;
	int position;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s itemPosition item\"",
                argv[0]);
            return TCL_ERROR;
        }
        from.addr = argv[2];
        from.size = strlen(argv[2]) + 1;
        toItem.addr = NULL;
        XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	position = XmListItemPos(w, *(XmString *)toItem.addr);
	sprintf(interp->result, "%d", position);
    } else
#endif

#ifndef MOTIF11
    if ((c == 'p') && (strcmp(argv[1], "positionSelected") == 0)) {
        int position;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s positionSelected position\"",
                argv[0]);
            return TCL_ERROR;
        }
        if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
            return TCL_ERROR;
        }

	if (XmListPosSelected(w, position)) {
	    strcpy(interp->result, "true");
	} else {
	    strcpy(interp->result, "false");
	}
    } else
#endif

    if ((c == 's') && (strcmp(argv[1], "selectItem") == 0)) {
        XrmValue from, toItem;
	int call_callback;

        if (argc != 4) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s selectItem item notify\"",
                argv[0]);
            return TCL_ERROR;
        }
        from.addr = argv[2];
        from.size = strlen(argv[2]) + 1;
        toItem.addr = NULL;
        XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

        if (Tcl_GetBoolean(interp, argv[3], &call_callback) == TCL_ERROR) {
            return TCL_ERROR;
        }

	XmListSelectItem(w, *(XmString *) toItem.addr, call_callback);
    } else

    if ((c == 's') && (strcmp(argv[1], "selectPosition") == 0)) {
	int position;
	int call_callback;

	if (argc != 4) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s selectPosition position call_callback\"",
		argv[0]);
	    return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	if (Tcl_GetBoolean(interp, argv[3], &call_callback) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XmListSelectPos(w, position, call_callback);
    } else

    if ((c == 's') && (strcmp(argv[1], "setBottomItem") == 0)) {
	XrmValue from, toItem;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s setBottomItem item\"",
		argv[0]);
	    return TCL_ERROR;
	}
        from.addr = argv[2];
        from.size = strlen(argv[2]) + 1;
        toItem.addr = NULL;
        XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmListSetBottomItem(w, *(XmString *) toItem.addr);
    } else

    if ((c == 's') && (strcmp(argv[1], "setBottomPosition") == 0)) {
	int position;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setBottomPosition item\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XmListSetBottomPos(w, position);
    } else

    if ((c == 's') && (strcmp(argv[1], "setItem") == 0)) {
	XrmValue from, toItem;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s setItem item\"",
		argv[0]);
	    return TCL_ERROR;
	}
        from.addr = argv[2];
        from.size = strlen(argv[2]) + 1;
        toItem.addr = NULL;
        XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmListSetItem(w, *(XmString *) toItem.addr);
    } else

    if ((c == 's') && (strcmp(argv[1], "setPosition") == 0)) {
	int position;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setPosition position\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}

	XmListSetPos(w, position);
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_RootCmd --
 *
 *	This function processes the commands that may be applied
 *	to the toplevel widget `.'. In addition to all the normal
 *	commands, the extra ones are the Xt ones that use the
 *	AppContext - in tclMotif, we only have one of these, so
 *	it is sensible to attach them to `.'.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_RootCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w;
    char c;
    XtAppContext appContext;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }

    w = wPtr -> widget;
    appContext = XtWidgetToApplicationContext(wPtr->widget);

    c = argv[1][0];

    if ((c == 'a') && (strcmp(argv[1], "addInput") == 0)) {
	Tm_InputData *input;
	int filenum;
	char *end;
	XtInputId inputId;
	char ch;

	if (argc < 4) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s fileID \
permissions tcl_code", argv[0]);
	    return TCL_ERROR;
	}

	input = (Tm_InputData *) XtMalloc(sizeof(Tm_InputData));
	input->interp = interp;
	input->command = XtNewString(argv[4]);

	/* determine file number */
	if (strcmp(argv[2], "stdin") == 0) {
	    filenum = 0;
	} else
	if (strcmp(argv[2], "stdout") == 0) {
	    filenum = 1;
	} else
	if (strcmp(argv[2], "stderr") == 0) {
	    filenum = 2;
	} else
	if (strncmp(argv[2], "file", 4) == 0) {
	    end = argv[2] + 4;
	    if (sscanf(end, "%d", &filenum) < 1) {
		sprintf(interp->result, "unknow file number \"%s\"", argv[2]);
		return TCL_ERROR;
	    };
	} else {
	    Tcl_SetResult(interp, "unknown file", TCL_STATIC);
	    return TCL_ERROR;
	}

	if (strlen(argv[3]) != 1) {
	    Tcl_SetResult(interp, "addInput: only one of r,w,x", TCL_STATIC);
	    return TCL_ERROR;
	}
	
	ch = argv[3][0];
	if (ch != 'r' && ch != 'w' && ch != 'x') {
	    Tcl_SetResult(interp, "addInput: use only r,w,x as modes", TCL_STATIC);
	    return TCL_ERROR;
	}

	/* determine modes */
	if (ch == 'r') {
	    inputId = XtAppAddInput(appContext, filenum, (XtPointer) XtInputReadMask,
			Tm_InputHandler, input);
	} else
	if (ch == 'w') {
	    inputId = XtAppAddInput(appContext, filenum, (XtPointer) XtInputWriteMask,
			Tm_InputHandler, input);
	} else
	if (ch == 'x') {
	    inputId = XtAppAddInput(appContext, filenum, (XtPointer) XtInputExceptMask,
			Tm_InputHandler, input);
	}
	
	/* simple type check: prefix Id with "inputId-" */
	sprintf(interp->result, "inputId-%lu", inputId);
#	ifdef DEBUG
	    fprintf(stderr, "adding input %lu\n", inputId);
#	endif
	return TCL_OK;
    } else

    if ((c == 'a') && (strcmp(argv[1], "addTimer") == 0)) {
	Tm_TimerData *timer;
	XtIntervalId timerId;
	unsigned long interval;

	if (argc < 3) {
	    sprintf(interp->result,
			"wrong # args: should be \"%.50s addTimer interval proc \"",
			argv[0]);
	    return TCL_ERROR;
	}

	sscanf(argv[2], "%lu", &interval);

	timer = (Tm_TimerData *) XtMalloc(sizeof(Tm_TimerData));
	timer->interp = interp;
	timer->command = XtNewString(argv[3]);
	timerId = XtAppAddTimeOut(appContext, interval,
                        Tm_TimerHandler, timer);

	sprintf(interp->result, "timerId-%lu", timerId);
	return TCL_OK;
    } else

    if ((c == 'g') && (strcmp(argv[1], "getAppResources") == 0)) {
	if (argc < 3) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s getAppResources \
resourceList\"", argv[0]);
	    return TCL_ERROR;
	}
	return(Tm_GetAppResources(interp, w, argv[2]));
    } else

    if ((c == 'p') && (strcmp(argv[1], "processEvent") == 0)) {
	XtAppProcessEvent(appContext, XtIMAll);
    } else

    if ((c == 'r') && (strcmp(argv[1], "removeInput") == 0)) {
	XtInputId inputId;

	
	if (argc < 3) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s removeInput \
inputID\"", argv[0]);
	    return TCL_ERROR;
	}

	if (sscanf(argv[2], "inputId-%lu", &inputId) < 1) {
	    sprintf(interp->result, "removeInput: illegal inputId \"%s\"",
			argv[2]);
	    return TCL_ERROR;
	}
	XtRemoveInput(inputId);
    } else

    if ((c == 'r') && (strcmp(argv[1], "removeTimer") == 0)) {
	XtIntervalId timerId;

	
	if (argc < 3) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s removeTimer \
timerID\"", argv[0]);
	    return TCL_ERROR;
	}

	if (sscanf(argv[2], "timerId-%lu", &timerId) < 1) {
	    sprintf(interp->result, "removeTimer: illegal timerId \"%s\"",
			argv[2]);
	    return TCL_ERROR;
	}
	XtRemoveTimeOut(timerId);
    } else

    if ((c == 'm') && (strcmp(argv[1], "mainLoop") == 0)) {
	XtAppMainLoop(XtWidgetToApplicationContext(wPtr->widget));

    } else {
        return Tm_ShellWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_DrawingWidgetCmd --
 *
 *	This function processes the commands that may be applied
 *	to a drawing widget such as DrawnButton and DrawingArea.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_DrawnWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w;
    char c;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }

    w = wPtr -> widget;

    c = argv[1][0];

    if ((c == 'd') && (strcmp(argv[1], "drawImageString") == 0)) {
/*
	void *p;
*/
	long p;
	GC gc;
	int x, y;
	Window win;
	Display *display;
	int length;
	char *string;

        if (argc != 6) {
    	    sprintf(interp->result,
		    "wrong # args: should be \"%.50s drawImageString gc x y string\"",
		    argv[0]);
	    return TCL_ERROR;
        }
/*	%p may be broken on the Sun? So fit it into an XtArgVal
	sscanf(argv[2], "%p", &p);
*/
	if (sscanf(argv[2], "gc-%lu", &p) < 1) {;
	    sprintf(interp->result, "drawImageString: illegal gc \"%s\"",
			argv[2]);
	    return TCL_ERROR;
	}
	gc = (GC) p;
	Tcl_GetInt(interp, argv[3], &x);
	Tcl_GetInt(interp, argv[4], &y);
	string = argv[5];
	length = strlen(string);

	display = XtDisplay(w);
	win = XtWindow(w);

	XDrawImageString(display, win, gc, x, y, string, length); 
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_TextWidgetCmd --
 *
 *	handles the methods that may be requested of Text widgets.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_TextWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w = wPtr->widget;
    Display *display;
    Time timeStamp;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }
    
    display = XtDisplay(wPtr->widget);
    timeStamp = XtLastTimestampProcessed(display);

    if (strcmp(argv[1], "losingFocusCallback") == 0) {
        Tm_ClientData *client_data;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s losingFocusCallback callback\"",
                argv[0]);
            return TCL_ERROR;
        }
        client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
        client_data->callback_func = XtNewString(argv[2]);
        client_data->widget_info = wPtr;

	XtAddCallback(wPtr->widget, XmNlosingFocusCallback,
			Tm_TextVerifyCallbackHandler, (XtPointer) client_data);
    } else

    if (strcmp(argv[1], "modifyVerifyCallback") == 0) {
        Tm_ClientData *client_data;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s modifyVerifyCallback callback\"",
                argv[0]);
            return TCL_ERROR;
        }
        client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
        client_data->callback_func = XtNewString(argv[2]);
        client_data->widget_info = wPtr;

	XtAddCallback(wPtr->widget, XmNmodifyVerifyCallback,
			Tm_TextVerifyCallbackHandler, (XtPointer) client_data);
    } else

    if (strcmp(argv[1], "motionVerifyCallback") == 0) {
        Tm_ClientData *client_data;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s motionVerifyCallback callback\"",
                argv[0]);
            return TCL_ERROR;
        }
        client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
        client_data->callback_func = XtNewString(argv[2]);
        client_data->widget_info = wPtr;

	XtAddCallback(wPtr->widget, XmNmotionVerifyCallback,
			Tm_TextVerifyCallbackHandler, (XtPointer) client_data);
    } else

    if (strcmp(argv[1], "clearSelection") == 0) {
	XmTextClearSelection(wPtr->widget, timeStamp);
    } else

    if (strcmp(argv[1], "copy") == 0) {
	XmTextCopy(wPtr->widget, timeStamp);
    } else

    if (strcmp(argv[1], "cut") == 0) {
	XmTextCut(wPtr->widget, timeStamp);
    } else

#ifndef MOTIF11
    if (strcmp(argv[1], "disableRedisplay") == 0) {
	XmTextDisableRedisplay(w);
    } else
#endif

#ifndef MOTIF11
    if (strcmp(argv[1], "enableRedisplay") == 0) {
	XmTextEnableRedisplay(w);
    } else
#endif

#ifndef MOTIF11
    if (strcmp(argv[1], "findString") == 0) {
	long start;
	char *string;
	XmTextDirection direction;
	long position;
	char pos_str[16];

        if (argc != 6) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s findString start string direction position\"",
                argv[0]);
            return TCL_ERROR;
        }
	if (sscanf(argv[2], "%ld", &start) < 1) {
	    sprintf(interp->result, "non-integer start param for %.50s findString",
		argv[0]);
	    return TCL_ERROR;
	}
	string = argv[3];
	if (strcmp(argv[4], "forward") == 0) {
	    direction = XmTEXT_FORWARD;
	} else
	if (strcmp(argv[4], "backward") == 0) {
	    direction = XmTEXT_BACKWARD;
	} else {
	    sprintf(interp->result, "%.50s findString: direction must be forward or backward",
		argv[0]);
	    return TCL_ERROR;
	}
	
	if (XmTextFindString(w, start, string, direction, &position)) {
	    sprintf(interp->result, "true");
	    sprintf(pos_str, "%ld", position);
	    if (Tcl_SetVar(interp, argv[5], pos_str, 0) == NULL) {
		return TCL_ERROR;
	    } else
		return TCL_OK;
	} else {
	    sprintf(interp->result, "false");
	    return TCL_OK;
	}
    } else
#endif

    if (strcmp(argv[1], "getEditable") == 0) {
	if (XmTextGetEditable(w)) {
	    interp->result = "true";
	} else {
	    interp->result = "false";
	}
	return TCL_OK;
    } else

    if (strcmp(argv[1], "getInsertionPosition") == 0) {
	XmTextPosition pos;

	pos = XmTextGetInsertionPosition(w);
	sprintf(interp->result, "%ld", pos);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "getLastPosition") == 0) {
	XmTextPosition pos;

	pos = XmTextGetLastPosition(w);
	sprintf(interp->result, "%ld", pos);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "getSelection") == 0) {
	char *sel;

	sel = XmTextGetSelection(w);
	Tcl_SetResult(interp, sel, TCL_VOLATILE);
	XtFree(sel);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "getSelectionPosition") == 0) {
	XmTextPosition left, right;
	char buf[16];

        if (argc != 4) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s getSelectionPosition left right\"",
                argv[0]);
            return TCL_ERROR;
        }
	if (XmTextGetSelectionPosition(w, &left, &right)) {
	    interp->result = "true";
	} else {
	    interp->result = "false";
	}
	sprintf(buf, "%ld", left);
	Tcl_SetVar(interp, argv[2], buf, 0);
	sprintf(buf, "%ld", right);
	Tcl_SetVar(interp, argv[3], buf, 0);

	return TCL_OK;
    } else

    if (strcmp(argv[1], "getString") == 0) {
	char *str;

	str = XmTextGetString(wPtr->widget);
	Tcl_SetResult(interp, str, TCL_VOLATILE);
	XtFree(str);
    } else

#ifndef MOTIF11
    if (strcmp(argv[1], "getSubstring") == 0) {
	XmTextPosition start;
	int num_chars;
	int buffer_size;
	char *buffer;
	int ret;

        if (argc != 5) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s getSubstring start num_chars buffer\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (sscanf(argv[2], "%ld", &start) < 1) {
	    sprintf(interp->result, "%.50s getSubstring: bad num_chars",
		argv[0]);
	    return TCL_ERROR;
	}
	if (sscanf(argv[3], "%ld", &num_chars) < 1) {
	    sprintf(interp->result, "%.50s getSubstring: bad num_chars",
		argv[0]);
	    return TCL_ERROR;
	}

	/* MB_CUR_MAX defaults to zero on Sun */
	if (MB_CUR_MAX >= 1) {
	    buffer_size = num_chars * MB_CUR_MAX + 1;
	} else {
	    buffer_size = num_chars + 1;
	}
	buffer = XtMalloc(buffer_size);
	
	ret = XmTextGetSubstring(w, start, num_chars, buffer_size, buffer);
	Tcl_SetVar(interp, argv[4], buffer, 0);

	if ( ret == XmCOPY_SUCCEEDED) {
	    interp->result = "succeeded";
	} else
	if (ret == XmCOPY_TRUNCATED) {
	    interp->result = "truncated";
	} else
	if (ret == XmCOPY_FAILED) {
	    interp->result = "failed";
	}

	XtFree(buffer);
	return TCL_OK;
    } else
#endif

    if (strcmp(argv[1], "getTopCharacter") == 0) {
	XmTextPosition pos;

	pos = XmTextGetTopCharacter(w);
	sprintf(interp->result, "%ld", pos);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "insert") == 0) {
	XmTextPosition pos;

        if (argc != 4) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s insert position value\"",
                argv[0]);
            return TCL_ERROR;
        }
	
	if (sscanf(argv[2], "%ld", &pos) < 1) {
	    sprintf(interp->result, "%.50s insert: bad position", argv[0]);
	    return TCL_ERROR;
	}
	
	XmTextInsert(w, pos, argv[3]);

	return TCL_OK;
    } else

    if (strcmp(argv[1], "paste") == 0) {
	XmTextPaste(wPtr->widget);
    } else

    if (strcmp(argv[1], "remove") == 0) {
	XmTextRemove(wPtr->widget);
    } else

    if (strcmp(argv[1], "replace") == 0) {
	XmTextPosition from, to;

        if (argc != 5) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s replace from to value\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (sscanf(argv[2], "%ld", &from) < 1) {
	    sprintf(interp->result, "%.50s replace: bad from value", argv[0]);
	    return TCL_ERROR;
	}
	if (sscanf(argv[3], "%ld", &to) < 1) {
	    sprintf(interp->result, "%.50s replace: bad to value", argv[0]);
	    return TCL_ERROR;
	}
	
	XmTextReplace(w, from, to, argv[4]);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "scroll") == 0) {
	int lines;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s scroll lines\"",
                argv[0]);
	    return TCL_ERROR;
	}
    
	if (Tcl_GetInt(interp, argv[2], &lines) != TCL_OK) {
	    return TCL_ERROR;
	}
	XmTextScroll(w, lines);
        return TCL_OK;
    } else

    if (strcmp(argv[1], "setAddMode") == 0) {
	int state;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setAddMode boolean\"",
                argv[0]);
	    return TCL_ERROR;
	}

	if (Tcl_GetBoolean(interp, argv[2], &state) != TCL_OK) {
	    return TCL_ERROR;
	}

	XmTextSetAddMode(w, state);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "setEditable") == 0) {
	int editable;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setEditable boolean\"",
                argv[0]);
	    return TCL_ERROR;
	}

	if (Tcl_GetBoolean(interp, argv[2], &editable) != TCL_OK) {
	    return TCL_ERROR;
	}

	XmTextSetEditable(w, editable);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "setHighlight") == 0) {
	XmTextPosition left, right;
	XmHighlightMode mode;

        if (argc != 5) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setHighlight left right mode\"",
                argv[0]);
	    return TCL_ERROR;
	}

	if (sscanf(argv[2], "%ld", &left) < 1) {
	    sprintf(interp->result, "%.50s setHighlight: bad \"left\" value", argv[0]);
	    return TCL_ERROR;
	}
	if (sscanf(argv[3], "%ld", &right) < 1) {
	    sprintf(interp->result, "%.50s setHighlight: bad \"right\" value", argv[0]);
	    return TCL_ERROR;
	}

	if (strcmp(argv[4], "normal") == 0) {
	    mode = XmHIGHLIGHT_NORMAL;
	} else
	if (strcmp(argv[4], "selected") == 0) {
	    mode = XmHIGHLIGHT_SELECTED;
	} else
	if (strcmp(argv[4], "secondary_selected") == 0) {
	    mode = XmHIGHLIGHT_SECONDARY_SELECTED;
	} else {
	    sprintf(interp->result, "%.50s setHighlight: bad \"highlight\" value", argv[0]);
	    return TCL_ERROR;
	}
	    
	XmTextSetHighlight(w, left, right, mode);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "setInsertionPosition") == 0) {
	XmTextPosition pos;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setInsertionPosition position\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (sscanf(argv[2], "%ld", &pos) < 1) {
	    sprintf(interp->result, "%.50s setInsertionPosition: bad \"position\" value", argv[0]);
	    return TCL_ERROR;
	}

	XmTextSetInsertionPosition(w, pos);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "setSelection") == 0) {
	XmTextPosition first, last;
	Time tim;

        if (argc != 4) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setSelection first last\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (sscanf(argv[2], "%ld", &first) < 1) {
	    sprintf(interp->result, "%.50s setSelection: bad \"first\" value", argv[0]);
	    return TCL_ERROR;
	}
	if (sscanf(argv[3], "%ld", &last) < 1) {
	    sprintf(interp->result, "%.50s setSelection: bad \"last\" value", argv[0]);
	    return TCL_ERROR;
	}

	tim = XtLastTimestampProcessed(XtDisplay(w));

	XmTextSetSelection(w, first, last, tim);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "setSource") == 0) {
	XmTextPosition top, position;
	XmTextSource source;
	Widget w_old;
	Tm_Widget *info;

        if (argc != 5) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setSource source top position\"",
                argv[0]);
            return TCL_ERROR;
        }

	info = Tm_WidgetInfoFromPath(interp, argv[2]);
	if (info == NULL) {
	    sprintf(interp->result, "%.50s setSource: bad \"widget\" value", argv[0]);
	    return TCL_ERROR;
	}
	w_old = info->widget;
	source = XmTextGetSource(w_old);
	    
	if (sscanf(argv[3], "%ld", &top) < 1) {
	    sprintf(interp->result, "%.50s setSource: bad \"top\" value", argv[0]);
	    return TCL_ERROR;
	}
	if (sscanf(argv[4], "%ld", &position) < 1) {
	    sprintf(interp->result, "%.50s setSource: bad \"position\" value", argv[0]);
	    return TCL_ERROR;
	}

	XmTextSetSource(w, source, top, position);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "setString") == 0) {
        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setString value\"",
                argv[0]);
            return TCL_ERROR;
        }
	
	XmTextSetString(w, argv[2]);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "setTopCharacter") == 0) {
	XmTextPosition top;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s setTopCharacter top\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (sscanf(argv[2], "%ld", &top) < 1) {
	    sprintf(interp->result, "%.50s setTopCharacter: bad \"top\" value", argv[0]);
	    return TCL_ERROR;
	}

	XmTextSetTopCharacter(w, top);
	return TCL_OK;
    } else

    if (strcmp(argv[1], "showPosition") == 0) {
	XmTextPosition pos;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s showPosition position\"",
                argv[0]);
            return TCL_ERROR;
        }

	if (sscanf(argv[2], "%ld", &pos) < 1) {
	    sprintf(interp->result, "%.50s showPosition: bad \"position\" value", argv[0]);
	    return TCL_ERROR;
	}

	XmTextShowPosition(w, pos);
	return TCL_OK;
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_PopupMenuWidgetCmd --
 *
 *	handles the methods that may be requested of Popup menus.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_PopupMenuWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w = wPtr->widget;
    XEvent *event;

    if (strcmp(argv[1], "menuPosition") == 0) {
        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s menuPosition event\"",
                argv[0]);
            return TCL_ERROR;
        }
	if (sscanf(argv[2], "event-%lu", &event) < 1) {
            sprintf(interp->result,
                "wrong event arg: should be \"%.50s menuPosition event\"",
                argv[0]);
            return TCL_ERROR;
	}
	XmMenuPosition(w, event);
	return TCL_OK;
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_ShellWidgetCmd --
 *
 *	handles the methods that may be requested of Shells
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_ShellWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w = wPtr->widget;

    if (strcmp(argv[1], "popup") == 0) {
/*	should we allow grab type to be set?
        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s menuPosition event\"",
                argv[0]);
            return TCL_ERROR;
        }
*/
	XtPopup(w, XtGrabNone);
	return TCL_OK;
    } else
    if (strcmp(argv[1], "popup") == 0) {
	XtPopdown(w);
	return TCL_OK;
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}
