#include <stdio.h>
#include <tcl.h>
#include <ctype.h>
#include "ppm.h"

static void eatwhitespace (file)
     FILE* file;
{
   int ch;
   do {
      ch = getc (file);
      if (ch == '#') {
	 do {
	    ch = getc (file);
	 } while (ch != '\n' && ch != EOF);
      }
   } while (isspace (ch) && ch != EOF);
   ungetc (ch, file);
}
     
int readppminit (file, colsP, rowsP, maxvalP, formatP)
/*  -----------
 *
 *  Reads the header of a ppm file and retrieves the basic
 *  parameters. Returns 1 if OK and 0 if error.
 */
     FILE* file;
     int* colsP;
     int* rowsP;
     int* maxvalP;
     int* formatP;
{
   *formatP = getc(file)*256 + getc(file);
   eatwhitespace (file);
   fscanf (file, "%d", colsP);
   eatwhitespace (file);
   fscanf (file, "%d", rowsP);
   eatwhitespace (file);
   fscanf (file, "%d", maxvalP);
   return getc (file)!= EOF; 
}

int writeppminit (file, cols, rows, maxval, format)
/*  -----------
 *
 *  writes the header of a ppm file and with a raster's basic
 *  parameters. Returns 1 if OK and 0 if error.
 */
     FILE* file;
     int cols;
     int rows;
     int maxval;
     int format;
{
   if (format != RPPM_FORMAT && format != PPM_FORMAT ||
       format == RPPM_FORMAT && maxval > 255) {
      return 0;
   }
   return fprintf (file, "P%c\n%d %d\n%d\n", (char)(format%256), cols, rows, 
		   maxval) != EOF;
}

int writeppmrow (file, pixelrow, cols, maxval, format)
/*  -----------
 *
 *  writes an array of pixels into ppm file 'file' in either raw or 
 *  cooked 'format'.
 */
     FILE* file;
     pixel* pixelrow;
     int cols, maxval, format;
{
   int result = 1;
   if (format == RPPM_FORMAT) {
      result = fwrite ((char*)pixelrow, 3, cols, file);
   }
   else if (format == PPM_FORMAT) {
      while (cols-- && result != EOF) {
	 result = fprintf (file, "%d %d %d", (int)(pixelrow->r),
			   (int) (pixelrow->g), (int) (pixelrow->b));
	 pixelrow++;
      }
   }
   else return 0;
   return result != EOF;
}
     
 

int readppmrow (file, pixelrow, cols, maxval, format)
/*  ----------
 *
 *  Reads from 'file' a row of 'cols' pixels into array 'pixrow'. 
 *  format should be one of RPPM_FORMAT or PPM_FORMAT
 */
     FILE* file;
     pixel* pixelrow;
     int cols, maxval, format;
{
   int result = 1;
   int r, g, b, i;
   unsigned char *graybuf;

   if (format == RPPM_FORMAT) {
      result = fread ((char*)pixelrow, 3, cols, file);
   }
   else if (format == RPGM_FORMAT) {
      result = fread ((char*)pixelrow, 1, cols, file);
      graybuf = (unsigned char*) pixelrow;
      for (i = cols-1; i >= 0; --i) {
	 pixelrow [i].r = pixelrow [i].g = pixelrow [i].b = graybuf [i]*255/maxval;
      }
   }
   else if (format == PPM_FORMAT) {
      while (cols-- && result != EOF) {
	 result = fscanf (file, "%d%d%d", &r, &g, &b);
	 pixelrow->r = r*255/maxval;
	 pixelrow->g = g*255/maxval;
	 pixelrow->b = b*255/maxval;
	 pixelrow++;
      }
   }
   else if (format == PGM_FORMAT) {
      while (cols-- && result != EOF) {
	 result = fscanf (file, "%d", &r);
	 pixelrow->r = pixelrow->g = pixelrow->b = r*255/maxval;
	 pixelrow++;
      }
   }
   else return 0;
   return result != EOF;
}
	 
     


   
  
