/* 
 * tkXText16.c --
 *
 *	Written by Kazuro Furukawa, Kek, Apr.1.1993.
 *	display 16bit characters
 *
 *	this module includes functions which are front-end to 
 *	8bit and 16bit versions of text handling routines.
 *	TkFont16Check()
 *	TkXTextWidth()
 *	TkXTextExtents()
 *	TkXDrawString()
 *	Tkisspace()
 *	TkAllocChars16()
 *	TkFreeChars16()
 *
 *	Modified by K.F, Apr.13.1993. add shift-JIS conversion.
 */

#ifndef lint
static char tkxtext16_what[] = "tkXText16.c, V1.7, 93/04/1, K.Furukawa, Kek";
#endif

#include <ctype.h>
#undef FONT16
#include "tkInt.h"

#ifdef SHIFTJIS

/* tksjis2euc  --  convert shift-JIS kanji to EUC kanji */

void
tksjis2euc(str)
    char *str;
{
    unsigned char sfb, ssb;			/* source first/second bytes */
    unsigned char rfb, rsb;			/* result first/second bytes */

    sfb = *(unsigned char *)str;
    ssb = *(unsigned char *)(str+1);

    {
	if ( sfb >= 0x81 && sfb <= 0x9f )  {	/* check first byte */
    	    if ( ssb >= 0x40 && ssb <= 0x7e )  {
		rfb = ( sfb<<1 ) - 0xe1 + 0x80;	/* put first */
    	    	rsb = ssb - 0x1f + 0x80;	/* put second */
    	    }
    	    else if ( ssb >= 0x80 && ssb <= 0x9e )  {
		rfb = ( sfb<<1 ) - 0xe1 + 0x80;	/* put first */
    	    	rsb = ssb - 0x20 + 0x80;	/* put second */
    	    }
    	    else if ( ssb >= 0x9f && ssb <= 0xfc )  {
		rfb = ( sfb<<1 ) - 0xe0 + 0x80;	/* put first */
    	    	rsb = ssb - 0x7e + 0x80;	/* put second */
    	    }
    	    else  {				/* second byte out of range */
		rfb = 0x21;			/* put a space character */
		rsb = 0x21;
	    }
    	}
	else if ( sfb >= 0xe0 && sfb <= 0xfc )  {	/* check first byte */
    	    if ( ssb >= 0x40 && ssb <= 0x7e )  {
		rfb = ( sfb<<1 ) - 0x161 + 0x80;	/* put first */
    	    	rsb = ssb - 0x1f + 0x80;	/* put second */
    	    }
    	    else if ( ssb >= 0x80 && ssb <= 0x9e )  {
		rfb = ( sfb<<1 ) - 0x161 + 0x80;	/* put first */
    	    	rsb = ssb - 0x20 + 0x80;	/* put second */
    	    }
    	    else if ( ssb >= 0x9f && ssb <= 0xfc )  {
		rfb = ( sfb<<1 ) - 0x160 + 0x80;	/* put first */
    	    	rsb = ssb - 0x7e + 0x80;	/* put second */
    	    }
    	    else  {				/* second byte out of range */
		rfb = 0x21;			/* put a space character */
		rsb = 0x21;
	    }
    	}
    	else  {					/* first byte out of range */
	    rfb = 0x21;				/* put a space character */
	    rsb = 0x21;
    	}
    }
    *(unsigned *)str = rfb;
    *(unsigned *)(str+1) = rsb;
}

/* tkeuc2sjis  --  convert EUC kanji to shift-JIS kanji */

void
tkeuc2sjis(str)
    char *str;
{
    unsigned char sfb, ssb;			/* source first/second bytes */
    unsigned char rfb, rsb;			/* result first/second bytes */

    sfb = *(unsigned char *)str;
    ssb = *(unsigned char *)(str+1);

    if ( sfb >= 0x21 && sfb <= 0x5e )  {	/* check first byte */
    	if ( sfb & 0x01 )  {			/* first byte odd */
    	    if ( ssb >= 0x21 && ssb <= 0x5f )  {
		rfb = ( sfb>>1 ) + 0x71;	/* put first */
    	    	rsb = ssb + 0x1f;	/* put second */
    	    }
    	    else if ( ssb >= 0x60 && ssb <= 0x7e )  {
		rfb = ( sfb>>1 ) + 0x71;	/* put first */
    	    	rsb = ssb + 0x20;	/* put second */
    	    }
    	    else  {				/* second byte out of range */
		rfb = 0x81;		/* put a space character */
		rsb = 0x40;
	    }
    	}
    	else  {					/* first byte even */
    	    if ( ssb >= 0x21 && ssb <= 0x7e )  {
		rfb = ( sfb>>1 ) + 0x70;	/* put first */
    		rsb = ssb + 0x7e;	/* put second */
    	    }
    	    else  {				/* second byte out of range */
		rfb = 0x81;		/* put a space character */
		rsb = 0x40;
	    }
    	}
    }
    else if ( sfb >= 0x5f && sfb <= 0x7e )  {	/* check first byte */
    	if ( sfb & 0x01 )  {			/* first byte odd */
    	    if ( ssb >= 0x21 && ssb <= 0x5f )  {
		rfb = ( sfb>>1 ) + 0xb1;	/* put first */
    	    	rsb = ssb + 0x1f;	/* put second */
    	    }
    	    else if ( ssb >= 0x60 && ssb <= 0x7e )  {
		rfb = ( sfb>>1 ) + 0xb1;	/* put first */
    	    	rsb = ssb + 0x20;	/* put second */
    	    }
    	    else  {				/* second byte out of range */
		rfb = 0x81;		/* put a space character */
		rsb = 0x40;
	    }
    	}
    	else  {					/* first byte even */
    	    if ( ssb >= 0x21 && ssb <= 0x7e )  {
		rfb = ( sfb>>1 ) + 0xb0;	/* put first */
    		rsb = ssb + 0x7e;	/* put second */
    	    }
    	    else  {
		rfb = 0x81;		/* put a space character */
		rsb = 0x40;
	    }
    	}
    }
    else  {					/* first byte out of range */
	rfb = 0x81;		/* put a space character */
	rsb = 0x40;
    }

    *(unsigned *)str = rfb;
    *(unsigned *)(str+1) = rsb;
}
#endif /* SHIFTJIS */

/* tkmakestring16  --  create XChar2b string for 16bit text handling */

XChar2b *
tkmakestring16(string, length, glgr)
    char string[];
    int length;
    int glgr;
{
    XChar2b *string16, *tp;

    length /= 2;

    tp = string16 = (XChar2b *)ckalloc(sizeof(XChar2b) * (length+1));

    while(length--)  {
#ifdef SHIFTJIS
	tksjis2euc(string);			/* convert shift-JIS to EUC */
#endif
	tp->byte1 = *string++ - glgr;
	(tp++)->byte2 = *string++ - glgr;
    }
    tp->byte1 = 0;
    tp->byte2 = 0;
    return string16;
}

/* TkFont16Check  --  check if the font is 8bit or 16bit */

int
TkFont16Check(font_struct)
    XFontStruct *font_struct;
{
    register int i;
    if((i=font_struct->max_byte1) == 0)  return 0;		/* 8bit */
    else if(i <0x80)  return 1;					/* 16bit GL */
    else return 2;						/* 16bit GR */
}

/* TkXTextWidth  --  front-end for XTextWidth or XTextWidth16 */

int
TkXTextWidth(font_struct, string, length)
    XFontStruct *font_struct;
    char string[];
    int length;
{
    XChar2b *string16;
    int tmp;
    static char kanjiA[] = {0xb0, 0xa1, 0};	/* kanji a */

    switch (TkFont16Check(font_struct)) {
    case 0:
	return XTextWidth(font_struct, string, length);
    case 1:
	tmp = 0x80;
	break;
    case 2:
	tmp = 0;
    }
    /* sometime tk trys to measure the size of a character using "0". */
    /* if this is the case, I asume that it corresponds to the half */
    /* width of the kanji a. in future with compound text I must treat */
    /* precisely */
    if (length == 1 && string[0] == '0')  {
	string16 = tkmakestring16(kanjiA, 2, tmp);
	tmp = XTextWidth16(font_struct, string16, 1) / 2;
    }  else  {
	string16 = tkmakestring16(string, length, tmp);
	tmp = XTextWidth16(font_struct, string16, length/2);
    }
    ckfree(string16);
#ifdef DEBUG
    printf("tw16: %d '%s'\n", length, string);
    printf("tw16: width %d\n", tmp);
#endif
    return tmp;
}

/* TkXTextExtents  --  front-end for XTextExtents or XTextExtents16 */

void
TkXTextExtents(font_struct, string, length,
	       direction_hint, font_ascent, font_descent, overall)
    XFontStruct *font_struct;
    char string[];
    int length;
    int *direction_hint, *font_ascent, *font_descent;
    XCharStruct *overall;
{
    XChar2b *string16;

    switch (TkFont16Check(font_struct)) {
    case 0:
	XTextExtents(font_struct, string, length,
		     direction_hint, font_ascent, font_descent, overall);
	return;
    case 1:
	string16 = tkmakestring16(string, length, 0x80);
	break;
    case 2:
	string16 = tkmakestring16(string, length, 0);
    }
    XTextExtents16(font_struct, string16, length/2,
		   direction_hint, font_ascent, font_descent, overall);
    ckfree(string16);
#ifdef DEBUG
    printf("te16: %d '%s'\n", length, string);
    printf("te16: width %d\n", overall->lbearing + overall->rbearing);
#endif
}

/* TkXDrawString  --  front-end for XDrawString or XDrawString16 */

void
TkXDrawString(font_struct, display, window, gc, x, y, string, length)
    XFontStruct *font_struct;
    Display *display;
    Drawable window;
    GC gc;
    int x, y;
    char string[];
    int length;
{
    XChar2b *string16;

    switch (TkFont16Check(font_struct)) {
    case 0:
	XDrawString(display, window, gc, x, y, string, length);
	return;
    case 1:
	string16 = tkmakestring16(string, length, 0x80);
	break;
    case 2:
	string16 = tkmakestring16(string, length, 0);
    }
    XDrawString16(display, window, gc, x, y, string16, length/2);
    ckfree(string16);
#ifdef DEBUG
    printf("ds16: %d '%s'\n", length, string);
#endif
}

/* Tkisspace  --  8bit version of isspace */

int
Tkisspace(a)
    char a;
{
    return (isascii(a) && isspace(a));
}

/* TkAllocChars16  --  allocate 16bit string and convert 8bit string */

/* this procedure converts alphanumeric characters to 16bit equivalent. */
/* in future, this should be improved. */

char *
TkAllocChars16(string, length)
    char *string;
    int *length;
{
    char *string16, *str;
    int leng = *length;
    str = string16 = (char *)ckalloc(leng*2+1);		/* max. number of ch */
    while (leng--)  {
	if (isascii(*string) && isalnum(*string))  {
	    *str++ = 0xa3;
	    *str++ = *string++ | 0x80;
#ifdef SHIFTJIS
	    tkeuc2sjis(str-2);			/* convert EUC to shift-JIS */
#endif
	}  else  {
	    *str++ = *string++;
	}
    }
    *length = str - string16;
    *str++ = NULL;
    return string16;
}

/* TkFreeChars16  --  free 16bit string */

void
TkFreeChars16(string)
    char *string;
{
    ckfree(string);
}

