'\" $Id: narray.man,v 1.5 1994/08/04 23:29:31 sls Exp $
'\"
'\" This software is copyright (C) 1994 by the Lawrence Berkeley Laboratory.
'\" 
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that: (1) source code distributions
'\" retain the above copyright notice and this paragraph in its entirety, (2)
'\" distributions including binary code include the above copyright notice and
'\" this paragraph in its entirety in the documentation or other materials
'\" provided with the distribution, and (3) all advertising materials mentioning
'\" features or use of this software display the following acknowledgement:
'\" ``This product includes software developed by the University of California,
'\" Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
'\" the University nor the names of its contributors may be used to endorse
'\" or promote products derived from this software without specific prior
'\" written permission.
'\" 
'\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
'\" WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
'\" MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
'\" 
'\" The man page macros are:
'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS narray cmds narray NArray
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
narray \- create and manipulate multi-dimensional arrays
.SH SYNOPSIS
\fBnarray create \fIarrayName\fR \fIdim0 \fR?\fIdim1 ...\fR?

\fBnarray ncload \fIarrayName\fR \fIfilename variable\fR
.BE

.SH DESCRIPTION
This command creates multi-dimensional floating-point arrays in Tcl.
In addition to setting and getting the value of array elements,
functions can be mapped over array elements.  These functions can use
variables local to the narray.  If this extension has been compiled
with netCDF support then arrays may be loaded and saved to netCDF
files.

This manual page documents version 0.5 of the narray extension.
.SH NARRAY CREATION
Narray's can be created with the following commands:
.TP
\fBnarray create \fIarrayName\fR \fIdim0 \fR?\fIdim1 ...\fR?
Creates a command \fIarrayName\fR that represent a multi-dimensional
array with dimensions of length \fIdim0 \fR?\fIdim1 ...\fR?.  Returns
\fIarrayName\fR.
.TP
\fBnarray ncload \fIarrayName\fR \fIfilename variable\fR
Create a command \fIarrayName\fR by loading the variable
\fIvariable\fR from the netCDF file \fIfilename\fR.  The elements of
\fIvariable\fR will be converted to \fBNArrayFloat\fR's, sometimes this
will mean some loss of precision.  Returns \fIarrayName\fR.
.SH NARRAY LAYOUT AND INDEXES
An narray is stored in memory as a vector of \fBNArrayFloat\fR's
(usually \fBfloat\fR's -- see \fBnarray.h\fR).  An index into a
narray, \fIindex0 \fR?\fIindex1 ...\fR? references the \fIindex0\fR +
?\fIindex1\fR * \fIdim0\fR + \fI...\fR? element.  Each \fIindexN\fR can
be greater than \fIdimN\fR or even negative, as long as the sum
\fIindex0\fR + ?\fIindex1\fR * \fIdim0\fR + \fI...\fR? is within the
bounds of the vector.  In addition, there may be fewer indexes than
dimensions.
.SH NARRAY LANGUAGE
The \fIarrayName\fR \fBmap\fR command compiles and applies a sequence
of code to each element in a narray.  Statements in the language 
are seperated by semi-colons or by newlines.  The narray language
includes standard math (including \fB+=, -=, *=, /=\fR and \fB?:\fR).
\fB=\fR is used for assignment.  The following forms may appear on the
left hand side of an assigment:
.TP 20
\fIvar\fR
The variable \fIvar\fR.  Variables may contain numeric values only.
.TP 20
\fB[\fR?\fIindex0, index1, ...\fR?\fB]\fR
The current element, modified by \fIindex0, index1, ...\fR.
For example, \fB[]\fR is the current element,
\fB[-1]\fR is the previous element, and \fB[0,1]\fR is
the element in the same column but next row in a 2D matrix.
.TP 20
\fB\fIarray_var\fB[\fR?\fIindex0, index1, ...\fR?\fB]\fR
Accesses elements of the narray \fIarray_var\fR.
.LP
The value of variables and array elements may be referenced by
prefixing a \fB$\fR to them.  For example, \fB$foo\fR is the value of
the variable \fBfoo\fR.  In addtion \fB@\fIN\fR may be used to
reference the value of the \fIN\fR'th index of the current element.
For example, \fB@0\fR is the column number and \fB@1\fR is the row
number (for a 2D matrix.)
.LP
Funtions may be called as \fIfunc\fB(\fR?\fIarg0, ...\fR?\fB)\fR
Strings enclosed by "'s may be passed to functions.  The following
functions are availabe:
.TP
\fBsin(\fIx\fB)\fR
The sine of \fIx\fR.
.TP
\fBcos(\fIx\fB)\fR
The cosine of \fIx\fR.
.TP
\fBtan(\fIx\fB)\fR
The tangent of \fIx\fR.
.TP
\fBasin(\fIx\fB)\fR
The arc sine of \fIx\fR.
.TP
\fBacos(\fIx\fB)\fR
The arc cosine of \fIx\fR.
.TP
\fBatan(\fIx\fB)\fR
The arg tangent of \fIx\fR.
.TP
\fBsinh(\fIx\fB)\fR
The hyperbolic sine of \fIx\fR.
.TP
\fBcosh(\fIx\fB)\fR
The hyperbolic cosine of \fIx\fR.
.TP
\fBtanh(\fIx\fB)\fR
The hyperbolic tangent of \fIx\fR.
.TP
\fBexp(\fIx\fB)\fR
\fBe ^ \fIx\fR.
.TP
\fBlog(\fIx\fB)\fR
The natural log of \fIx\fR.
.TP
\fBlog10(\fIx\fB)\fR
The base 10 log of \fIx\fR.
.TP
\fBsqrt(\fIx\fB)\fR
The square root of \fIx\fR.
.TP
\fBceil(\fIx\fB)\fR
The smallest integral value not less than \fIx\fR.
.TP
\fBfloor(\fIx\fB)\fR
The largest integral value not greater than \fIx\fR.
.TP
\fBatan2(\fIx, y\fB)\fR
The arc tangent function of two variables.
.TP
\fBpow(\fIx, y\fB)\fR
\fIx\fR raised to the \fIy\fR power.
.TP
\fBfmod(\fIx, y\fB)\fR
The floating-point remainder of \fIx\fR / \fIy\fR.
.TP
\fBprintf(\fIformat_string, ?arg?, ...\fB)\fR
A limited form of printf that understands the d, f, g, and s formats.
.TP
\fBfprintf(\fIfile_number, format_string, ?arg?, ...\fB)\fR
Like \fBprintf\fR, but output goes to the file handle identified by
\fIfile_number\fR.  Tcl's file handles are of the form
\fBfile\fIfile_number\fR.
.TP
\fBtcl_eval(\fIstring, ?arg?, ...\fB)\fR
Concatenate \fIstring\fR and
any arguments (numeric arguments are converted to strings and preceded
by a space) and evaulate in Tcl in the current context.
.SH NARRAY COMMAND
The \fBnarray\fR command creates a new Tcl command whose name is the
same as the name of the narray.  This command may be used to invoke
various operations on the narray.  It has the following general form:
.DS C
\fIarrayName option \fR?\fIarg arg ...\fR?
.DE

The following commands are possible for narray's:
.TP
\fIarrayName\fR \fBaref \fIindex0 \fR?\fIindex1 ...\fR?
Return the element at \fIindex0 \fR?\fIindex1 ...\fR?.
.TP
\fIarrayName\fR \fBaset \fIindex0 \fR?\fIindex1 ...\fR? \fIvalue\fR
Set the element at \fIindex0 \fR?\fIindex1 ...\fR? to \fIvalue\fR.
.TP
\fIarrayName\fR \fBvref \fIvariable\fR
Return the value of the variable \fIvariable\fR.
.TP
\fIarrayName\fR \fBvset \fIvariable value\fR
Set the variable \fIvariable\fR to \fIvalue\fR.
.TP
\fIarrayName\fR \fBvars\fR
Return a list of variables in \fIarrayName\fR.
.TP
\fIarrayName\fR \fBmap \fIcode \fR?\fI{array_var0 array0} ...\fR?
Compile \fIcode\fR and apply it to each element of \fIarrayName\fR.
Make the narray \fIarray0\fR available to \fIcode\fR as
\fIarray_var0\fR.
.TP
\fIarrayName\fR \fBdimensions\fR
Return the dimensions of \fIarrayName\fR.
.TP
\fIarrayName\fR \fBstatus\fR
Return some status information about \fIarrayName\fR (currently, the
kilobytes used by the narray and its debug status.)
.TP
\fIarrayName\fR \fBdebug\fR \fIlevel\fR
Set the debug flags of \fIarrayName\fR to \fIlevel\fR.  The debug
flags are a bitwise OR of:
.DS C
1 Print parsing information
2 Trace stack machine execution 
4 Print compiled code before executing it
.DE
.TP
\fIarrayName\fR \fBncsave\fR \fIfilename variable_name dim0_name \fR?\fIdim1_name ...\fR?
Save \fIarrayName\fR to the netCDF file
\fIfilename\fR.  The netCDF file will contain the one variable
\fIvariable_name\fR and have dimensions named \fIdim0_name
\fR?\fIdim1_name ...\fR?.  The type of \fIvariable_name\fR will be the
same type as \fBNArrayFloat\fR.  Any previous file \fIfilename\fR will
be clobbered.
.SH VARIABLES
The following variables are set by this extension:
.TP
\fBnarray_library\fR
The location of the Tcl library.  This can be overridden by the
environment variable \fBNARRAY_LIBRARY\fR.
.TP
\fBnarray_version\fR
The version number of the narray extension, in the form
\fImajor\fR.\fIminor\fR.
.SH LIBRARY COMMANDS
The file \fBnarray.tcl\fR contains these useful library routines:
.TP
\fBpnarray \fIarrayName\fR
Print the narray \fIarrayName\fR.
.TP
\fBnarray_delete \fIarrayName\fR
Delete the narray \fIarrayName\fR.  This is the same as \fBrename
\fIarrayName \fB{}\fR.
.SH BUGS AND QUIRKS
Simple expressions must end with a semi-colon or newline.  For
example, \fIarrayName\fR \fBmap { sum += $[]; }\fR will compile, but
\fIarrayName\fR \fBmap { sum += [] }\fR is a syntax error.

Strings are not first-class -- they can only appear as literals in
function calls.  If you want strings, use Tcl and \fBtcl_eval\fR.

The parser/code generator does not use a representation that makes for
easy optimizations.

The parser doesn't attempt to generate useful error messages.  Use
\fBdebug\fR level 1 to track down syntax errors.

The bytecode interpreter was developed in an ad hoc fashion and without
(much) regard to performance.

Most of the code was written for ease-of-implementation rather than doing
things the "right" way.

There are spotty run-time checks.  There is no stack underflow
checking, and only scattered type checking.
.SH AUTHOR
Sam Shen <slshen@lbl.gov> -- Please send me any comments, suggestions,
and bug reports/fixes.
.PP
