'\" 
'\" Copyright 1993 David Herron.
'\" Permission to use, copy, modify and distribute this software
'\" and its documentation for any purpose and without fee is
'\" hereby granted, provided that the above copyright notice
'\" appear in all copies.  David Herron makes no representations
'\" about the suitability of this software for any purpose save
'\" printing it out and using the paper as bird cage lining.
'\" 
.\" $Id: interpBase.man,v 1.3 1993/06/08 06:15:19 david Exp $
.\"
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"     Replacement for .TH in other man pages.  See below for valid
.\"     section names.
.\"
.\" .AP type name in/out [indent]
.\"     Start paragraph describing an argument to a library procedure.
.\"     type is type of argument (int, etc.), in/out is either "in", "out",
.\"     or "in/out" to describe whether procedure reads or modifies arg,
.\"     and indent is equivalent to second arg of .IP (shouldn't ever be
.\"     needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"     Give maximum sizes of arguments for setting tab stops.  Type and
.\"     name are examples of largest possible arguments that will be passed
.\"     to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"     Start box enclosure.  From here until next .BE, everything will be
.\"     enclosed in one large box.
.\"
.\" .BE
.\"     End of box enclosure.
.\"
.\" .VS
.\"     Begin vertical sidebar, for use in marking newly-changed parts
.\"     of man pages.
.\"
.\" .VE
.\"     End of vertical sidebar.
.\"
.\" .DS
.\"     Begin an indented unfilled display.
.\"
.\" .DE
.\"     End of indented unfilled display.
.\"
'\"     # Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"     # Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1  \\fI\\$2\\fP    (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1  \\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"     # define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"     # BS - start boxed text
'\"     # ^y = starting y location
'\"     # ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"     # BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"     Draw four-sided box normally, but don't draw top of
.\"     box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"     # VS - start vertical sidebar
'\"     # ^Y = starting y location
'\"     # ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"     # VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"     # Special macro to handle page bottom:  finish off current
'\"     # box/sidebar if in box/sidebar mode, then invoked standard
'\"     # page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"     Draw three-sided box if this is the box's first page,
.\"     draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h
'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"     # DS - begin display
.de DS
.RS
.nf
.sp
..
'\"     # DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS interpBase cmds
.BS
.SH NAME
interpBase \- Basic procedures for object oriented programming using \fIminterp\fP
.SH SYNOPSIS
\fBMethod\fP \fIname args body\fP
.br
\fB-export\fP \fIvariable-name\fP
.br
\fB-unexport\fP \fIvariable-name\fP
.br
\fB-set\fP \fIvariable-name value\fP
.br
\fB-get\fP \fIvariable-name\fP
.br
\fB-unset\fP \fIvariable-name\fP
.br
\fB-import\fP \fIdestination-interpretor source-interpretor function-names\fP
.br
\fB-importAll\fP \fIdestination-interpretor source-interpretor\fP
.br
\fB-chain\fP  \fIdestination-interpretor source-interpretor\fP
.br
\fBgen_interp_name \fIbasename\fP
.br
\fBadd_module_directory \fIdirs\fP
.br
\fBload_module \fImodule-name\fP
.br
\fBTkChain\fP
.BE

.SH DESCRIPTION
.PP
\fIInterpBase\fP provides the basis for object oriented programming
in TCL using \fIminterp\fP facilities.

The definition is stored in \fIinterpBaseC.tcl\fP.  When executed
it creates an interpretor named \fIInterpBase\fP.

.SH COMMANDS
.PP
.TP
\fBMethod\fP \fIname args body\fP
Creates a procedure which is added to the \fIMethod\fP list.

.TP
\fB-export\fP \fIvariable-name ...\fP
Maintains a list of variable names (the \fIexport list\fP)
which are to be accessible to other interpretors.  The variable
name may be given as \fIarray-name(index)\fP.  See \fB-set\fP and
friends below.

.TP
\fB-unexport\fP \fIvariable-name ...\fP
Removes a variable from the \fIexport list\fP.

.TP
\fB-exported\fP
Return a TCL list containing names of the currently exported variables.

.TP
\fB-set\fP \fIvariable-name value\fP
Sets the value of the variable.  If it is not in the \fIexport list\fP
then an error is returned.

.TP
\fB-get\fP \fIvariable-name\fP
Retrieves the value of the variable.  If it is not in the \fIexport list\fP
then an error is returned.

.TP
\fB-unset\fP \fIvariable-name\fP
Destroys the variable.  If it is not in the \fIexport list\fP
then an error is returned.

.TP
\fB-import\fP \fIdestination-interpretor source-interpretor function-names\fP
Creates functions in \fIsource-interpretor\fP which retrieves the
real function from \fIdestination-interpretor\fP for execution.  It does
this for every function in \fIfunction-names\fP.  The resulting function
executes \fBin\fP in \fIdestination-interpretor\fP.

.TP
\fB-importAll\fP \fIdestination-interpretor source-interpretor\fP
Like \fB-import\fP but automatically does it for all commands in
the source interpretor.

.TP
\fB-chain\fP \fIdestination-interpretor cmds\fP
Creates functions in the interpretor which actually executes in
\fIdestination-interpretor\fP.

.TP
\fBgen_interp_name \fIbasename\fP
Generates a unique interpreter name for the given basename.  It appends
a number, incrementing the number on every call until it creates
a unique name.

.TP
\fBadd_module_directory \fIdirs\fP
Adds the named directory to the list of directories which can satisfy
\fBload_module\fP requests.  When a directory is added, the \fIminterpIndex\fP
file there is read and the \fImodule-name\fP to \fIfile-name\fP mapping
information is remembered.

.TP
\fBload_module \fImodule-name\fP
If the an interpreter named \fImodule-name\fP already exists, then
nothing happens.  To find the file containing code to initialize
the interpreter, the \fImodule-name\fP to \fIfile-name\fP mapping information
(created through \fBadd_module_directory\fP calls) is consulted.  If
there is a mapping, the resulting file is \fBsource\fP\&'d.

.TP
\fBTkChain\fP
List of command names in the TK extension to TCL.  It is intended to
be used as such:
.DS
\ \ \ \ -chain MainInterp [InterpBase -get TkChain]
.DE

.SH KEYWORDS
multiple interpretors, encapsulation, abstraction, modularity, object oriented

.SH AUTHOR
David Herron <david@davids.mmdf.com (home)>

.SH BUGS
Knock on wood ...
