'\"
'\" MAN PAGE:  drag&drop widget
'\"     SCCS:  %W% (%G%)
'\" 
'\" Man page formatting taken from...
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
.\"
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS drag&drop cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
drag&drop \- facilities for handling drag&drop data transfers
.SH SYNOPSIS
\fBdrag&drop source
.br
\fBdrag&drop source \fIwindow \fR?\fIoptions\fR?
.sp
\fBdrag&drop target
.br
\fBdrag&drop target \fIwindow \fRhandler ?{\fIdataType command\fR} ...?
.sp
\fBdrag&drop target \fIwindow \fRhandle \fIdataType
.sp
\fBdrag&drop drag \fIwindow x y
.br
\fBdrag&drop drop \fIwindow x y
.br
.VS
\fBdrag&drop active
.VE
.br
\fBdrag&drop location \fR?\fIx y\fR?
.BE

.SH DESCRIPTION
.PP
The \fBdrag&drop\fR command provides access to a set of facilities
for managing drag-and-drop data transfers.  Any of the usual Tk widgets can
be registered to participate in the drag-and-drop process.  Widgets
registered as a drag&drop \fIsource\fP can export data to other widgets
registered as a drag&drop \fItarget\fP.  Note that a particular widget
can be registered as a source, as a target, or as both.
.PP
The drag-and-drop process begins when the user clicks and holds a mouse
button in a source window; a token window appears with an icon or message
to represent the data being transferred.  As the user moves the mouse pointer,
the token window follows along, acting as a movable packet of data.
Whenever the mouse pointer falls on a target window, the border of the
token window is changed to its active state.  When the mouse button is
released over a target window, a TCL routine is invoked to send the data
to the desired application.  If this communication process fails,
a rejection symbol (a circle with a line through it) is displayed
on the token window to indicate failure.
.PP
The details of the communication process are fully configurable by the
application developer.  The general philosophy, however, is that the
sender should invoke a series of commands in the remote application to
transfer data into a buffer, and then request that the receiver "handle"
the data.  For example, the sender might invoke a command like
\fB"receive_number 12.3"\fP in the target application.  This command
could be implemented as follows:
.sp
.nf
.RS
\fBproc receive_number {num} {
    global Number
    set Number $num
}\fP
.RE
.fi
.sp
The sender would then request that the target "handle" a number.  This
separation between the data sent and the means of handling it is crucial.
It allows the developer a simple means of having several targets that all
receive numbers but use them in different ways.
.PP
To help in the interpretation of data, the \fBdrag&drop\fR command
provides a means of defining different "handler" commands in the target
widget.  New handlers are defined using the \fBdrag&drop ... handler\fR
command, and a specific handler is invoked (at the end of a send procedure)
via the \fBdrag&drop ... handle \fIdataType\fR command.
.PP
This introduction was presented as a brief overview of the communication
process; further details are presented below:
.TP
\fBdrag&drop source\fR
Returns a list of path names for widgets registered as drag&drop
sources.  Returns an empty string if no widgets have been registered.
.TP
\fBdrag&drop source \fIwindow \fR?\fIoptions\fR?
Registers a new drag&drop source window with the given options, or
modifies the options for an existing window:
.RS
.TP
\fB\-button \fIn\fR
Specifies the mouse button (integer \fIn\fP) that will invoke the
drag-and-drop operation on the source window.  Bindings for this button
are automatically added to the widget for the \fBdrag&drop drag\fR and
\fBdrag&drop drop\fR operations.
.VS
.TP
\fB\-rejectbg \fIcolor\fR
Specifies the color used to draw the background of the rejection symbol
on the token window.  The rejection symbol (a circle with a line through
it--the international "no") appears whenever communication fails.
.TP
\fB\-rejectfg \fIcolor\fR
Specifies the color used to draw the foreground of the rejection symbol
on the token window.
.TP
\fB\-rejectstipple \fIpattern\fR
Specifies a stipple pattern used to draw the foreground of the rejection
symbol on the token window.
.VE
.TP
\fB\-sendcmd \fIprefix\fR
Specifies a TCL command which will send data to another application
containing the drag&drop target.
.VS
Three arguments (the target interpreter name, target drag&drop widget name,
and the result of the token command) are appended to the command before it is
executed.  Typically this command is the name of a procedure (taking the
three communication parameters) which will invoke a series of send commands
to the target application.
.VE
The final command is usually a
\fBdrag&drop ... handle\fR command (described below) requesting the
target application to look for and process a certain data type.
The return value from the \fB\-sendcmd\fR command is unimportant, but
if the communication fails, it should return an error condition.  Any
such error is intercepted within the \fBdrag&drop drop\fR command, and
causes the rejection symbol to be posted to indicate failure.
.TP
\fB\-tokenactivebg \fIcolor\fR
Specifies the color used to draw the border of the token window in
its active state; the token window is "active" whenever it is over
another drag&drop target window.
.TP
\fB\-tokenactiverelief \fIcolor\fR
Specifies 3-D effect used to draw the border of the token window in
its active state; the token window is "active" whenever it is over
another drag&drop target window.  Acceptable values are \fBraised\fR,
\fBsunken\fR and \fBflat\fR.
.TP
\fB\-tokenborderwidth \fIpixels\fR
Specifies the width in pixels of the border around the token window.
This border is used to indicate when the token is over another
drag&drop target site.  The value may have any of the forms acceptable
to Tk_GetPixels.
.TP
\fB\-tokenbg \fIcolor\fR
Specifies the color used to draw the border of the token window in
its normal state; the token window is "normal" whenever it is \fInot\fP over
another drag&drop target window.
.TP
\fB\-tokencmd \fIprefix\fR
Specifies a TCL command used to update the appearance of the token window.
This command is automatically invoked by the \fBdrag&drop drag\fP command
whenever the token window is about to be mapped for a drag operation.
One argument (the name of the token window frame) is appended to the
command before it is executed.  Typically, this command is the name of a
procedure (taking the token window argument) which will pack a label--or
update the text of a label--in the token window.
.VS
The token command can also be used in conjunction with the
\fBdrag&drop location\fR command to determine the part of a widget that
a user has selected and extract a value from the widget.  This is particularly
useful when the drag&drop source is a listbox or canvas widget.
Since the return value from this command is automatically passed as an
argument to the send command, it can be used to communicate the value
selected.
If the token command returns an error, the drag operation is quietly aborted.
This can be used to disallow drag&drop operations from certain
parts of a widget, if the drag position is inappropriate.
.VE
.TP
\fB\-tokenrelief \fIcolor\fR
Specifies 3-D effect used to draw the border of the token window in
its normal state; the token window is "normal" whenever it is \fInot\fR over
another drag&drop target window.  Acceptable values are \fBraised\fR,
\fBsunken\fR and \fBflat\fR.
.RE
.sp
.TP
\fBdrag&drop target\fR
Returns a list of path names for widgets registered as drag&drop
targets.  Returns an empty string if no widgets have been registered.
.TP
\fBdrag&drop target \fIwindow \fRhandler ? {\fIdataType command\fR} ... ?
Registers a new drag&drop target window with the given handlers, or
modifies the handlers for an existing window.  If no handlers are
specified, this command returns the current list of recognized
\fIdataType\fR strings.  Each handler definition is a list with two elements,
making an association between the \fIdataType\fR string (a symbolic name
representing the type of data) and the \fIcommand\fR used to handle that data.
The \fIcommand\fR is actually invoked whenever a \fBdrag&drop ... handle\fR
command is issued by the \fB\-sendcmd\fR of the source widget.
.TP
\fBdrag&drop target \fIwindow \fRhandle \fIdataType
Searches for the given \fIdataType\fR name among the handlers registered
for the target \fIwindow\fR, and invokes the appropriate \fIcommand\fR.
If the \fIdataType\fR name is not recognized, this command returns an
error.  Typically, this command is invoked within the \fB\-sendcmd\fR
proc of the source application, to request that the target application
recognize and use the data that has been sent.
.TP
\fBdrag&drop drag \fIwindow x y\fR
Marks the start of (or movement during) a drag&drop operation.  If
the token window is unmapped when this command is invoked, then the
\fB\-tokencmd\fR for the source \fIwindow\fR is executed and (if
successful) the token window is mapped.  On subsequent calls, the
token window is moved to the new \fIx y\fR location.  This command is
automatically bound to <ButtonPress-\fIn\fR> and <B\fIn\fR-Motion>
events for \fB\-button \fIn\fR of the source widget.
.TP
\fBdrag&drop drop \fIwindow x y\fR
Marks the end of a drag&drop operation.  If the mouse pointer is
over a target window, then the \fB\-sendcmd\fR of the source window
is invoked to handle the data transfer.  If the data transfer is
successful, then the token window is unmapped; otherwise, a rejection
symbol is drawn on the token window, and the window is unmapped after
a small delay.
.VS
.TP
\fBdrag&drop active\fR
Returns "1" if a drag&drop operation is in progress, and "0" otherwise.
A drag&drop operation officially starts after the token command has
been executed successfully, and ends after the send command has been
executed (successfully or otherwise).
.VE
.TP
\fBdrag&drop location \fR?\fIx y\fR?
Used to set or query the pointer location during a drag&drop
event.  The \fIx y\fR arguments specify the current location; if these
arguments are missing, then the last reported (x,y) location is returned
as a list with two elements.  This command is issued automatically
within the \fBdrag&drop drag\fR and \fBdrag&drop drop\fR commands, to
keep track of pointer movement.

.SH KEYWORDS
drag&drop, send, bind, widget
