'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/menu.man,v 1.4 91/10/31 14:12:19 ouster Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS barchart cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
barchart \- Create and manipulate graph widgets

.SH SYNOPSIS
\fBbarchart\fI \fIpathName \fR[\fIoptions\fR]
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBfont\fR	\fBforeground\fR	\fBgeometry\fR
\fBrelief\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBdoubleBuffered\fR
Class:	\fBNone\fR
Command-Line Switch:	\fB\-doublebuffered or \-dbl\fR
.fi
.IP
Specifies that an off-screen pixmap should be used when displaying 
the graph.  This option slows the overall speed of redrawing the graph,
but reduces the flashing involved with many redraws. 
The argument must be a boolean value (see \fBTcl_GetBoolean\fR for further 
information). By the default, this option is \fBtrue\fR.
.LP
.nf
Name:	\fBlegendPosition\fR
Class:	\fBLegendPosition\fR
Command-Line Switch:	\fB\-legendposition\fR
.fi
.IP
Specifies the position of the legend in screen coordinates.  The position
given represents the upper left corner of the legend. The format of the
position is "@x,y", where x and y are the screen coordinates.  If the
position is the empty string, the legend will be displayed in the right 
margin (which is automatically extended to accommodate the legend).
The default position is the empty string.
.LP
.nf
Name:	\fBlegendBorderWidth\fR
Class:	\fBBorderWidth\fR
Command-Line Switch:	\fB\-legendborderwidth or \-lbd\fR
.fi
.IP
Specifies a non-negative integer value indicating the width (in pixels)
of the 3-D border to draw around the outside of the legend (if such a
border is being drawn;  the \fBlegendrelief\fR option determines
this).  
.LP
.nf
Name:	\fBlegendRelief\fR
Class:	\fBRelief\fR
Command-Line Switch:	\fB\-legendrelief or \-lrelief\fR
.fi
.IP
Specifies the 3-D effect desired for the legend.  Acceptable
values are \fBraised\fR, \fBsunken\fR, and \fBflat\fR.  The value
indicates how the interior of the legend should appear relative
to the graph;  for example, \fBraised\fR means the legend 
should appear to protrude from the graph, relative to
the surface of the graph.
.LP
.nf
Name:	\fBlegendBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB\-legendbackground or \-lbg\fR
.fi
.IP
Specifies the background color to use when displaying the
legend.
.LP
.nf
Name:	\fBnumberFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB\-numberfont\fR
.fi
.IP
Specifies the font to use when drawing numeric labels inside the \fBbarchart\fR
widget.
.LP
.nf
Name:	\fBshowLegend\fR
Class:	\fBShowLegend\fR
Command-Line Switch:	\fB\-showlegend\fR
.fi
.IP
Specifies if the legend will be shown when displaying the graph.
The argument specifies a boolean value (see \fBTcl_GetBoolean\fR 
for further information). The default value is \fBtrue\fR.
.LP
.nf
Name:	\fBtitle\fR
Class:	\fBTitle\fR
Command-Line Switch:	\fB\-title\fR
.fi
.IP
Specifies a string to be used as the title displaying the graph.
If the argument is an empty string, no title will be displayed.
.LP
.nf
Name:	\fBxLabel\fR
Class:	\fBLabel\fR
Command-Line Switch:	\fB\-xlabel\fR
.fi
.IP
Specifies a string to be used as the X coordinate axis label. 
If the argument is an empty string, no X axis label will be displayed.
.LP
.nf
Name:	\fBxRotation\fR
Class:	\fBRotation\fR
Command-Line Switch:	\fB\-xrotation\fR
.fi
.IP
Specifies the rotation of the X axis tick labels.  Currently, only
right angle rotations are performed. The default rotation is 90 degrees.
.LP
.nf
Name:	\fByLabel\fR
Class:	\fBLabel\fR
Command-Line Switch:	\fB\-ylabel\fR
.fi
.IP
Set the Y axis label. An empty string indicates no label is to
be present.
.LP
.nf
Name:	\fByLogScale\fR
Class:	\fBLogScale\fR
Command-Line Switch:	\fB\-ylogscale\fR
.fi
.IP
Specifies the scale (log/linear) of the Y coordinate axis.  
If the argument is \fBtrue\fR, the Y axis will be displayed with logarithmic
scale. The argument must be a boolean value (see \fBTcl_GetBoolean\fR 
for further information).  By default, the scale is linear.
.LP
.nf
Name:	\fByMinimum\fR
Class:	\fBMinimum\fR
Command-Line Switch:	\fB\-yminimum\fR
.fi
.IP
Specifies the minimum of the range of the Y coordinate values.
If the argument is the empty string, the minimum is determined from
the data of the bars to be displayed. 
.LP
.nf
Name:	\fByMaximum\fR
Class:	\fBMaximum\fR
Command-Line Switch:	\fB\-ymaximum\fR
.IP
Specifies the maximum of the range of the Y coordinate values.
If the argument is the empty string, the maximum is determined from
the data of the bars to be displayed. 
.LP
.nf
Name:	\fBySubTicks\fR
Class:	\fBSubTicks\fR
Command-Line Switch:	\fB\-ysubticks\fR
.fi
.IP
Set the number of minor ticks to be displayed on the Y axis.
By default, the number of minor ticks is 5.
.LP
.nf
Name:	\fByStepSize\fR
Class:	\fBStepSize\fR
Command-Line Switch:	\fB\-ystepsize\fR
.fi
.IP
Set the step size for the major ticks on the Y axis.  The requested
step size value is applied only when it makes sense, otherwise the 
step size is calculated based upon the extents of the data.  The two
cases where this can occur is when the step size is less than or equal to 
zero or is greater than the range of values for the axis. By default, 
the step size is 0.0, and the axis step size is automatically calculated.
.LP
.BE
.SH INTRODUCTION
.PP
The \fBbarchart\fR command creates a new window (given by the 
\fIpathName\fR argument) and makes it into a \fBbarchart\fR widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the graph such as its colors and font.
The \fBbarchart\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
The \fBbarchart\fR widget plots single variable data with an 
optional legend in a window.  
.PP
The barchart is a widget that displays a collection of bars and tags.
Bars and tags are not distinct widgets; the entire graph is one widget.
Initially the \fBbarchart\fR widget has no bars or tags.
.SH "BARS"
A bar is a value and a set of configuration options which determine how the 
bar is displayed.  Bars are created by the \fBinsert\fP widget command. 
The configuration options may be specified as the bar is created or later 
by the \fBbarconfigure\fR widget command.  There is also an internal
list of bar names which controls which bars are to be displayed.
By default, each new bar is added to this list.  However, the \fBshow\fR
command allows the use to specify which bars are to be displayed.
The \fBnames\fR commands returns a list of all bars.
.SH "TAGS"
A tag is a text string or bitmap displayed on the graph.
Tags are created by the \fBnewtag\fR widget command.  The coordinate
of the tag must be specified.  This coordinate is a x,y value of
the graph (not a screen coordinate).
Like bars, tags are draw only is their coordinates fall with the 
range of the axis limits.  Tags may also be rotated at right angles. 
Please note however, that since the tag is rotated each time the graph 
is displayed, it is much slower to rotate a tag from its default of 
zero degrees.
.PP
Tags can be used to annotate or highlight areas of the graph.
They may also be associated with a particular bar, so that they are 
drawn only when the bar is visible. Tags are the first items drawn 
when the graph is displayed, so that bars, symbols, legend, and 
axes always appear in front of them.  
.SH "WIDGET COMMANDS"
.PP
The \fBbarchart\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for \fBbarchart\fR widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBbarchart\fR
command.
.TP
\fIpathName \fBdelete \fIbarName\fR
Delete the bar named \fIbarName\fP from the graph. If the bar
is currently displayed, the graph will be redrawn.
.TP
\fIpathName \fBinsert \fIbarName ?option value option value...?\fR
Create or replace a bar named \fIbarName\fP in the \fBbarchart\fR widget.
By default, the bar is added to the list of bars to be displayed.
If additional arguments are present, they specify any of the following
options:
.RS
.TP
\fB\-background \fIvalue\fR
Specifies the background color of the bar.
.TP
\fB\-foreground \fIvalue\fR
Specifies the foreground color of the bar.
.TP
\fB\-stipple \fI@string\fR
Specifies the bitmap to use as a background pattern for the bar.
The argument may be in any of the forms acceptable to \fBTk_GetBitmap\fR.
The empty string indicates a solid pattern. The default is the
empty string.
.TP
\fB\-ydata \fIvalueList\fR
Specifies the y-coordinate values to plotted.
.TP
\fB\-label \fIstring\fR
Specifies the label of the bar as shown in the legend and the x-axis
tick label.  By default, the label is the name of the bar.
.RE
.TP
\fIpathName \fBlimits\fR
Returns a list containing the values representing the Y axis
limits.  The format of the list returned is \fBymin ymax\fR.
.TP
\fIpathName \fBbarconfigure \fIbarName ?options?\fR
This command is similar to the \fBconfigure\fR command, except that
it applies to the options for an individual bar, whereas \fBconfigure\fR
applies to the options for the graph as a whole.
\fIOptions\fR may have any of the values accepted by the \fBinsert\fR
widget command.  If \fIoptions\fR are specified, options are modified
as indicated in the command and the command returns an empty string.
If no \fIoptions\fR are specified, returns a list describing
the current options for entry \fIindex\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).
.TP
\fIpathName \fBlocate \fIx y\fP 
Translate the given x and y screen coordinates to the corresponding 
graph values.  A list of the two translated values is returned.
If a given screen coordinate value does not represent a position 
over the graph, the value return will be either \fBInf\fR or \fB-Inf\fR.
.TP
\fIpathName \fBnames\fR
Return a list of the names of all bars in the widget.
.TP
\fIpathName \fBnewtag \fItagName x y ?option value option value...?\fR
Create or replace a tag named \fItagName\fP at the given \fIx\fR and \fIy\fR
coordinates in the \fBbarchart\fR widget.
If additional arguments are present, they specify any of the following
options:
.RS
.TP
\fB\-anchor \fIdirection\fR
Specifies how the information in a tag (e.g. text or a bitmap)
is to be displayed in the graph widget.
Must be one of the values \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR,
\fBs\fR, \fBsw\fR, \fBw\fR, \fBnw\fR, or \fBcenter\fR.
For example, \fBnw\fR means display the information such that its
top-left corner is at the top-left corner of the widget.
The default anchor is \fBcenter\fR.
.TP
\fB\-background \fIcolor\fR
Specifies the background color of the text string or bitmap when displaying
the tag.
.TP
\fB\-bitmap \fI@file\fR
Specifies the bitmap to use as the tag.
Specifies a bitmap to display in the widget, in any of the forms
acceptable to \fBTk_GetBitmap\fR.
The exact way in which the bitmap is displayed may be affected by
other options such as \fBanchor\fR or \fBrotation\fR.
If this option is specified then it overrides other
options that specify a textual value to display in the widget;
the \fBbitmap\fR option may be reset to an empty string to re-enable
a text display.
.TP
\fB\-font \fIfontName\fR
Specifies the font to use when drawing the tag inside the widget.
The default font is \fI"*-Helvetica-Bold-R-Normal-*-120-*"\fR.
.TP
\fB\-foreground \fIcolor\fR
Specifies the foreground color of the text string or bitmap when displaying
the tag.
.TP
\fB\-bar \fIbarName\fR
Associates the tag with the bar named \fIbarName\fR.  If \fIbarName\fR
is not the empty string, the tag is displayed only if a bar \fIbarName\fR
exists and is being plotted.  This option may be used to annotate a
particular bar.
.TP
\fB\-rotation \fIvalue\fR
Specifies the rotation of the tag. Currently, only right angle rotations 
are performed.  The default rotation is \fIfR.
.TP
\fB\-text \fIstring\fR
.IP
Specifies a string to be displayed as the tag.  The way in which
the string is displayed is determined by other options, 
such as \fBanchor\fR or \fBrotation\fR.
If \fIstring\fR is the empty string, the tag will not be displayed.
.RE
.TP
\fIpathName \fBpostscript \fIfileName\fR
Create a postscript file of the current plot. Returns an empty string.
.TP
\fIpathName \fBshow \fI?nameList?\fR
Reset the list of bars to be displayed.  Only those bars in found
in the list are plotted.  If no \fInameList\fP argument is present, a list of 
the currently visible bars is returned, otherwise returns an empty string.
.TP
\fIpathName \fBtagconfigure \fItagName ?options?\fR
This command is similar to the \fBconfigure\fR command, except that
it applies to the options for an individual tag, whereas \fBconfigure\fR
applies to the options for the graph as a whole.
\fIOptions\fR may have any of the values accepted by the \fBnewtag\fR
widget command.  If \fIoptions\fR are specified, options are modified
as indicated in the command and the command returns an empty string.
If no \fIoptions\fR are specified, returns a list describing
the current options for entry \fIindex\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).
.TP
\fIpathName \fBuntag \fItagName\fR
Delete the tag named \fItagName\fP from the graph. 
.SH KEYWORDS
barchart, widget

.SH BINDINGS
.PP
There are no default bindings. 

.SH BUGS
.PP
There is no way to change the drawing order. Currently the bar chart is
displayed drawing first the tags and then the legend, axes, and finally
the data (bars and/or symbols). For example, this means that there is no way 
to let the legend overlay the axes or data.
.PP
Rotated text is drawn using both the foreground and background (like
XDrawImageString).  This is because it is drawn as a pixmap.
.PP
The \fBpostscript\fR command fails to handle 1) bitmaps (tags and stipples), 
2) background colors for rotated text, and 3) differences between
the PS Adobe fonts and the X11 Adobe fonts.
.PP
Autoscale routines do not use requested min/max limits
as boundaries when the axis is logarithmically scale.  
.PP
Font sizes do not automatically scale with the size of the window.
.PP
The needs to be better log scale mapping for values >= 0.0. Possibly use
linear scale for numbers between 1..-1.

