/*
 * Definitions for a `camera' - a data structure which defines a view
 * in 3D space.
 *
 * Copyright 1992 The Australian National University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, provided that the above copyright
 * notice appears in all copies.  This software is provided without any
 * warranty, express or implied. The Australian National University
 * makes no representations about the suitability of this software for
 * any purpose.
 *
 * Author: Paul Mackerras (paulus@cs.anu.edu.au)
 *
 * $Header: /localdisks/kaffa/cap/CaVis/src/tk2.3/RCS/tkCamera.h,v 1.1 1992/09/17 01:34:58 paulus Exp paulus $
 */

typedef double	vector[3];

typedef struct {
    vector	at;		/* world coords in center of field of view */
    vector	view;		/* direction camera is from at point */
    vector	up;		/* direction which -> vertically up in image */
    double	view_distance;	/* distance from camera to at point */
    double	view_angle;	/* angle (degrees) spanned by viewport */
    double	xmax;		/* maximum |x|/|z| */
    double	ymax;		/* maximum |y|/|z| */
    double	zmin;		/* minimum Z of visible objects */
    double	zmax;		/* maximum Z of visible objects */
    double	xmat[3][4];	/* transformation matrix */
    double	xcenter;	/* canvas coords at center of vport */
    double	ycenter;
    double	xyscale;	/* world -> screen expansion factor */
    int		perspective;	/* perspective (1) / orthogonal (0) view */
    int		uid;		/* unique id, changed when view changes */
} Camera;

/*
 * Generic information for a 3-D item; one of these must appear in
 * the item data structure immediately after the Tk_Item header.
 */
typedef struct Tk_3DItem {
    Tk_Item	*next;		/* in list for a viewport */
    Tk_Item	*prev;		/* (doubly-linked list) */
    Camera	*camera;	/* gives transformation */
} Tk_3DItem;

extern int	Tk_AttachToViewport _ANSI_ARGS_((Tcl_Interp *interp,
		    Tk_Canvas *canvas, int vport_id, Tk_Item *item));

