# ----------------------------------------------------------------------
# Main application window...
# ----------------------------------------------------------------------

proc palette::mk {w} {
frame $w
label $w.sample -text "Color" -borderwidth 3 -relief raised

drag&drop source $w.sample -button 3 \
	-tokencmd {package_rgb $Red $Green $Blue} \
	-sendcmd send_rgb

drag&drop target $w.sample handler {rgb set_color}

message $w.explanation -font -Adobe-times-medium-r-normal--*-120* -aspect 200 \
    -text "Press the third mouse button over a slider or a color sample and drag the token window around.  When the token becomes raised, it is over a target window.  Release the mouse button to drop the token and transfer information.  If the transfer fails, a \"no\" symbol is drawn on the token window.\n\nTry the following:\n- Drop a number from one slider onto another\n- Drop a color sample onto the Foreground/Background targets\n- Drop one of the slider color samples onto the main sample\n- Drop tokens from one palette application onto another"

#
# Red slider...
#
frame $w.red -borderwidth 3 -relief raised
scale $w.red.cntl -label "Red" -orient horizontal -from 0 -to 255 \
	-command set_red
frame $w.red.sample -geometry 20x20 -borderwidth 3 -relief raised
pack append $w.red \
	$w.red.cntl {left expand fillx} \
	$w.red.sample {right filly}

drag&drop source $w.red.sample -button 3 \
	-tokencmd {package_rgb $Red 0 0} \
	-sendcmd send_rgb

drag&drop target $w.red.sample handler \
	{number {set_red $Number}} \
	{rgb {set_red $NewR}}

drag&drop source $w.red.cntl -button 3 \
	-tokencmd "package_number [$w.red.cntl get]" \
	-sendcmd send_number

drag&drop target $w.red.cntl handler \
	{number {set_red $Number}} \
	{rgb {set_red $NewR}}

#
# Green slider...
#
frame $w.green -borderwidth 3 -relief raised
scale $w.green.cntl -label "Green" -orient horizontal -from 0 -to 255 \
	-command set_green
frame $w.green.sample -geometry 20x20 -borderwidth 3 -relief raised
pack append $w.green \
	$w.green.cntl {left expand fillx} \
	$w.green.sample {right filly}

drag&drop source $w.green.sample -button 3 \
	-tokencmd {package_rgb 0 $Green 0} \
	-sendcmd send_rgb

drag&drop target $w.green.sample handler \
	{number {set_green $Number}} \
	{rgb {set_green $NewG}}

drag&drop source $w.green.cntl -button 3 \
	-tokencmd "package_number [$w.green.cntl get]" \
	-sendcmd send_number

drag&drop target $w.green.cntl handler \
	{number {set_green $Number}} \
	{rgb {set_green $NewG}}

#
# Blue slider...
#
frame $w.blue -borderwidth 3 -relief raised
scale $w.blue.cntl -label "Blue" -orient horizontal -from 0 -to 255 \
	-command set_blue
frame $w.blue.sample -geometry 20x20 -borderwidth 3 -relief raised
pack append $w.blue \
	$w.blue.cntl {left expand fillx} \
	$w.blue.sample {right filly}

drag&drop source $w.blue.sample -button 3 \
	-tokencmd {package_rgb 0 0 $Blue} \
	-sendcmd send_rgb

drag&drop target $w.blue.sample handler \
	{number {set_blue $Number}} \
	{rgb {set_blue $NewB}}

drag&drop source $w.blue.cntl -button 3 \
	-tokencmd "package_number [$w.blue.cntl get]" \
	-sendcmd send_number

drag&drop target $w.blue.cntl handler \
	{number {set_blue $w $Number}} \
	{rgb {set_blue  $NewB}}

#
# Foreground/Background color inputs...
#
frame $w.inputs
label $w.inputs.bg -text "Background" -borderwidth 3 -relief sunken
label $w.inputs.fg -text "Foreground" -borderwidth 3 -relief sunken
button $w.inputs.quit -text "Quit" -borderwidth 3 -command "destroy ."

drag&drop target $w.inputs.bg handler {rgb "bg_color ."}
drag&drop target $w.inputs.fg handler {rgb "fg_color ."}

pack append $w.inputs \
	$w.inputs.fg {left padx 5 pady 5} \
	$w.inputs.bg {left padx 5 pady 5} \
	$w.inputs.quit {right padx 5 pady 5}

pack append $w \
	$w.sample {top expand fillx filly} \
	$w.explanation {top expand fillx filly} \
	$w.red {top expand fill} \
	$w.green {top expand fill} \
	$w.blue {top expand fill} \
	$w.inputs {top fillx}

global thewidget
set thewidget $w
}

#wm minsize . 200 200
#wm maxsize . 1000 1000


# ----------------------------------------------------------------------
# Setting color samples...
# ----------------------------------------------------------------------
set Red 0
set Green 0
set Blue 0

proc update_main_sample {w} {
	global Red Green Blue
	set color #[dec_to_hex $Red][dec_to_hex $Green][dec_to_hex $Blue]

	if {[expr $Red+$Green+$Blue] > 384} {
		$w.sample config -background $color -foreground black
	} else {
		$w.sample config -background $color -foreground white
	}
}

proc set_red { val} {
	global Red
	global thewidget; set w $thewidget
	set Red $val
	$w.red.cntl set $val
	$w.red.sample config -background #[dec_to_hex $Red]0000
	update_main_sample $w
}

proc set_green {val} {
	global Green
	set Green $val
	global thewidget; set w $thewidget
	$w.green.cntl set $val
	$w.green.sample config -background #00[dec_to_hex $Green]00
	update_main_sample $w
}

proc set_blue {val} {
	global Blue
	set Blue $val
	global thewidget; set w $thewidget
	$w.blue.cntl set $val
	$w.blue.sample config -background #0000[dec_to_hex $Blue]
	update_main_sample $w
}


proc palette::test {} {
palette::mk .p

set_red  0
set_green  0
set_blue  0

pack append . .p top
}
