#ifndef WIDGET_H
#define WIDGET_H

#include <hush/session.h>
#include <stdio.h>


#include <adt/client.h>
#include <hush/action.h>
#include <adt/handler.h>
#include <hush/dv-string.h>

extern kit* thekit();

#ifndef HCLONLY
extern Tk_Window MainWindow;
#endif

class widget : public handler {
protected:
static int widgetno;
virtual char* packcmd() { return "append"; }
//widget(widget&) { }
public:
virtual char* type() { return "widget"; }

//widget() {}
//widget() { sprintf(buf,".widget%d",++widgetno); path(buf); }

widget(char* s) { path(s); tk = thekit(); }
widget(widget* w, char* p) { 
	sprintf(buf,"%s%s",w->path(),p);
	if( buf[0]=='.' && buf[1]=='.' ) path(buf+1); else path(buf);
	tk = thekit();
	}

widget(widget& w) { path(w.path()); tk = thekit(); }

static widget* make(char *s, char* p, char* options = "") {
	char buf[512];
	sprintf(buf,"%s %s %s",s,p,options);
	thekit()->eval( buf );
	return new widget(p);
	}

virtual ~widget() {  ; }

char* info() { return "widget"; }

char* path() { return  _path; }

int eval(char* s) {
     sprintf(buf,"%s %s",path(),s);	
     return tk->eval(buf);
     }

char* result() { return tk->result(); }

char* evaluate(char* cmd) { eval(cmd); return result(); }


void destroy() { 
	sprintf(buf,"destroy %s",path());
	tk->eval( buf );
	}


virtual void configure(char* s) { 
	sprintf(buf,"%s configure %s",path(),s);
	tk->eval( buf );
	}

virtual widget* pack(widget* w, char* options = "{top fillx filly}" ) {
	sprintf(buf,"pack %s %s %s %s",packcmd(), path(), w->path(), options);
	tk->eval(buf);
	return this;
	}

virtual widget* pack(char* w, char* options = "{top fillx filly}" ) {
	sprintf(buf,"pack %s %s %s %s",packcmd(),path(), w, options);
	tk->eval(buf);
	return this;
	}

virtual void place(char* options) {
	sprintf(buf,"place %s %s",path(), options);
	tk->eval(buf);
	}


virtual bind(char *s, char* cmd, char* args = "") {
	action a(cmd);
	return direct(s,a,args);
	}

virtual bind(char *s, command proc, client* data = 0, char* args = "" ) {
	if (!data) data = this;
	action a(tk,proc,data,this);
	return direct(s,a,args);
	}

virtual bind(char *s, handler* h, char* args = "" ) {
	action a(tk,handler_callback,h,this);
	return direct(s,a,args);
	}

virtual bind(char *s, action& a, char* args = "" ) {
        return direct(s,a,args);
	}



void handler(char* cmd, char* args = "") {
	action ac(tk,cmd);
	install(ac,args);
	}

void handler(command proc, client* data = 0, char* args = "" ) {
	if (!data) data = this;
	action ac(tk,proc,data,this);
	install(ac, args);
	}

void handler(class handler* h, char* args = "" ) {
	action ac(tk,handler_callback,h,this);
	install(ac,args);
	}

void handler(action& ac, char* args = "" ) {
	install(ac,args);
	}

void source(char* type, char* args, char* options="") {
	sprintf(buf,"drag&drop source %s -button 3 -tokencmd {package_%s %s} -sendcmd send_%s %s",
	  path(),type,args,type,options);
	  tk->eval( buf );
	  }

void target(char* type, action& ac, char* args, char* options="") {
	sprintf(buf,"drag&drop target %s handler {%s {%s %s}} %s",
	  path(),type,ac.name(),args,options);
	  tk->eval( buf );
	  }

void focus(char* options = "") {
	sprintf(buf,"focus %s %s", options, path()); 
	tk->eval( buf );
	}

void grab(char* options = "") {
	sprintf(buf,"grab %s %s", options, path()); 
	tk->eval( buf );
	}

//class kit* kit() { return tk; }
//void kit(class kit* k) { tk = k; }

void wait() {
	sprintf(buf,"tkwait window %s",path());
	tk->eval( buf );
	}

#ifndef HCLONLY
void map() { Tk_MapWindow( tkwin() ); }
void unmap() { Tk_UnmapWindow( tkwin() ); }

Tk_Window tkwin() { return Tk_NameToWindow(tk->interp(), path(), MainWindow); }
#endif

protected:
void init(char* options) {
	sprintf(buf,"%s %s %s",type(),path(),options);
	tk->eval( buf );
	}

virtual void install(action& , char*) { }

virtual direct(char *s, action& a, char* args = "" ) {
	sprintf(buf,"bind %s %s { %s %s }", path(),s,a.name(),args);
	return tk->eval( buf );
	}


void path( char* s) { dvstring x(s); _path = x; }
void path( widget* w, char* s) { 
	sprintf(buf,"%s%s",w->path(),s);
	dvstring x(buf); _path = x;
	}
char buf[512];
class kit* tk;
private:
dvstring _path;
};

//inline widget* theroot() { return new widget("."); }

#endif
