#source rc.tcl
#source errors.tcl

initGenericRC

set our_conf_type Freeker
set our_id -1

set already_joined 0

set IDLEPROG $gk_library/machineIdleTime

if {[llength $argv] == 0} {
    set target_name $our_conf_type
} else {
    set target_name [lindex $argv 0]
}

set conf_we_monitor -1

PollConferences


proc foundNewConf conf {    global conflist userlist already_joined target_name our_conf_type conf_we_monitor host myport others listselection
    lappend conflist $conf
    set userlist([keylget conf confnum]) {}
    if {([keylget conf confname] == $target_name) && ($already_joined ==0) \
    && ([keylget conf confType] == $our_conf_type)} {
	set already_joined 1
	set conf_we_monitor [keylget conf confnum]
	callJoinConference [keylget conf confnum]
    } else {
	set mehp $host$myport
	if {[keylget conf originator] == $mehp} {
	    callJoinConference [keylget conf confnum]
	    foreach i $others {
		if {[lsearch $listselection [keylget i usernum]] != -1} {
		    keylset i confnum [keylget conf confnum]
		    callJoinConf $i
		}
	    }
	}
    }
    after 200 PollUsers [keylget conf confnum]
}



proc foundNewUser user {    global host myport userlist conf_we_monitor
    set confnum [keylget user confnum]
    lappend userlist($confnum) $user
    if {$confnum == $conf_we_monitor} {
	addCheckBox $user
	joinToRemoteFreek $user
    } else {
	if {([keylget user host]==$host) && ([keylget user port]==$myport)} {
	    createConference [findconfinfo $confnum] [keylget user usernum]
	} else {
	    set mehstprt $host$myport
	    set theconf [findconfinfo $confnum]
	    if {[keylget theconf originator]==$mehstprt} {
	        joinTo [set user] [set user]
	    }
	}
    }
}


proc foundDeletedUser {conf user} {  global userlist conf_we_monitor
    if {$conf == $conf_we_monitor} {
	removeCheckBox $user
	unhookRemoteFreek $user
    } 
    set idx 0; foreach i $userlist($conf) {
	if {[keylget i usernum] == $user} {
	    if {$conf != $conf_we_monitor} {
		toConf $conf "removeUser [list [lindex $userlist($conf) $idx]]"
	    }
	    set userlist($conf) [lreplace $userlist($conf) $idx $idx]
	} else { incr idx }
    }
}


proc foundDeletedConf conf { global conflist userlist
    set idx 0; foreach i $conflist {
	if {[keylget i confnum] == $conf} {
	    set conflist [lreplace $conflist $idx $idx]
	    set userlist($conf) ""
	    toConf $conf "deleteconf"
	} else { incr idx }
    }
}


proc conflist confs {  global already_joined host myport target_name registrar our_conf_type
    updatelist $confs conflist conflist confnum foundNewConf foundDeletedConf
    if {$already_joined == 0} {
	keylset conf confname $target_name confType $our_conf_type \
	    originator $host$myport
	callNewConference $conf
	after 200 PollConferences
    }
}


proc socket_closed filedesc { global conferences
    foreach i $conferences {
	if {[keylget i filedesc] == $filedesc} {
	    userLeft [keylget i confnum] [keylget i usernum]
	}
    }
}







set others ""
proc joinToRemoteFreek user {  global others
    set remote [MakeRPCClient [keylget user host] [keylget user port]]
    keylset user filedesc $remote
    lappend others $user
}

proc unhookRemoteFreek user {  global others
    set i 0; while { $i < [llength $others] } {
        set tmp [lindex $others $i]
        if {[keylget tmp usernum] == $user } {
            set others [lreplace $others $i $i]
        }
        incr i
    }
}

proc makeDropMenu {w} { global gk_library
    frame $w.cmds -borderwidth 3 -relief sunken
    button $w.cmds.postit -bitmap @$gk_library/bitmaps/post.bit -command "doNewConf Posty" 
    button $w.cmds.netfone -bitmap @$gk_library/bitmaps/phone.bit -command "doNewConf NetPhone"
    frame $w.cmds.dnd -borderwidth 2 -relief raised
    button $w.cmds.dnd.b -bitmap @$gk_library/bitmaps/dndflag.bit -borderwidth 0 \
	-command "togglednd $w.cmds.dnd" 
    button $w.cmds.quit -bitmap @$gk_library/bitmaps/quit.bit -command leavingConference
    pack append $w.cmds.dnd $w.cmds.dnd.b top
    pack append $w.cmds \
	$w.cmds.postit {left padx 10 pady 10} \
	$w.cmds.netfone {left  padx 10 pady 10}\
	$w.cmds.dnd {left padx 10 pady 10} \
	$w.cmds.quit {left padx 10 pady 10}
    pack append $w $w.cmds top
}

proc togglednd {w} {
    if {[lindex [$w configure -relief] 4] == "raised"} {
	broadcastUsersStatusHasChanged dontdisturb
	$w configure -relief sunken
    } else {
	broadcastUsersStatusHasChanged oktobug
	$w configure -relief raised
    }
}


set mainframe .mainframe
set userframe $mainframe.userframe
frame $mainframe -width 2c
pack append . $mainframe {top expand fill}
makeDropMenu $mainframe
frame $userframe -relief sunken 
pack append $mainframe $userframe {top expand fillx filly}


set confctr 0
proc getconfnm {} { global confctr; incr confctr; return ".freek$confctr" }

proc doNewConf {confType} {   global host myport
    keylset conf confname [getconfnm] \
	confType $confType \
	originator $host$myport
    callNewConference $conf
    after 100 PollConferences
}


set namewin(-1) ""

proc addCheckBox user {  global userframe host myport our_id namewin
    set usernumb [keylget user usernum]
    # Find the name of the user
    if {([keylget user host] == $host) && ([keylget user port] == $myport)} {
	set username self
	set our_id $usernumb
    } else {
	set username [keylget user username]
    }
    
    if { [winfo exists $userframe.$usernumb] } {return}
    # Create a checkbox of that user and put it on the display
    
    set frm [frame $userframe.$usernumb]
    set namewin($usernumb) $frm
    pack append $frm \
	[label $frm.name -text $username] {left expand fillx}

    bind $frm.name <1> "clicklist $usernumb"
    bind $frm.name <Shift-1> "shftclicklist $usernumb"
    bind $frm.name <2> "shftclicklist $usernumb"
    pack append $userframe $frm {top fillx}

    update
}

proc removeCheckBox user {  global namewin
    pack unpack $namewin($user)
}

proc leavingConference {} {  global conf_we_monitor our_id
    callLeaveConference $conf_we_monitor $our_id
    after 500 PollUsers $conf_we_monitor
    after 1000 {destroy .}
}



set listselection ""
proc addToSelection {usernum} {  global listselection namewin
    set frm $namewin($usernum)
    if {$frm!=""} {
	$frm.name configure -bg #cdb79e
	set listselection [lappend listselection $usernum]
    }
}
proc removeFromSelection {usernum} {  global listselection namewin
    set frm $namewin($usernum)
    if {$frm!=""} {
	$frm.name configure -bg #ffe4c4
	set idx [lsearch $listselection $usernum]
	set listselection [lreplace $listselection $idx $idx]
    }
}
proc clicklist {usernum} {  global listselection
    foreach i $listselection {
	removeFromSelection $i
    }
    addToSelection $usernum
}
proc shftclicklist {usernum} {  global listselection
    if {[lsearch $listselection $usernum] == -1} {
	addToSelection $usernum
    } else {
	removeFromSelection $usernum
    }
}


proc broadcastUsersStatusHasChanged {status} {global others our_id
    foreach i $others {
	RDO [keylget i filedesc] \
	    participantStatusHasChanged $our_id $status
    }
    return ""
}

proc participantStatusHasChanged {usernum status} {global userframe namewin gk_library
    set frm $namewin($usernum)
    case $status in {
	active
	{ 
	    $frm.name configure -font *helvetica*-r-*12* -fg black
	}
	lessactive  
	{
	    $frm.name  configure -font *helvetica*-o-*12* -fg black

	}
	idle
	{
	    $frm.name configure -fg white
	}
	oktobug
	{
	    if {[winfo exists $frm.dnd]} {
		pack unpack $frm.dnd
		destroy $frm.dnd
	    }
	}
	dontdisturb
	{
	    if {![winfo exists $frm.dnd]} {
		pack append $frm [label $frm.dnd -bitmap @$gk_library/bitmaps/dnd.bit] right
		update
	    }
	}

    }
}


proc broadcastStatusAgent {} { global others our_id IDLEPROG
    after 30000 "broadcastStatusAgent"
    set idle [exec $IDLEPROG]
    case $idle {
	0 { set stat active }
	1 { set stat lessactive }
	default { set stat idle}
    }
    broadcastUsersStatusHasChanged $stat
}

after 10000 "broadcastStatusAgent"
