#
# widgets for GK conferences to use
#

proc gkDefaultMenu w {
    frame $w -borderwidth 2 -relief raised
    menubutton $w.fileMenu -menu $w.fileMenu.m -text File -underline 0
    menu $w.fileMenu.m
    $w.fileMenu.m add command -label "Quit" -command "gkProperQuit" -underline 0

    menubutton $w.helpMenu -menu $w.helpMenu.m -text Help -underline 0
    menu $w.helpMenu.m
    $w.helpMenu.m add command -label "About GroupKit" -command "gkAbout"

    menubutton $w.grpMenu -menu $w.grpMenu.m -text Collaboration -underline 0
    menu $w.grpMenu.m
    $w.grpMenu.m add check -label "Show Users" -command "showUsers" -variable gkUsersWindowShowing -underline 5

    pack append $w $w.fileMenu left $w.helpMenu right $w.grpMenu right
}

proc showUsers {} {  global gkUsersWindowShowing ouropts
    if {$gkUsersWindowShowing == 1} {
	if {[winfo exists .gkUsers] == 0} {
	    # creating for the first time
	    toplevel .gkUsers
	    wm protocol .gkUsers WM_DELETE_WINDOW "set gkUsersWindowShowing 0; wm withdraw .gkUsers"
	    label .gkUsers.lbl -text [concat "Others in" [keylget ouropts confname]] -font -Adobe-times-bold-r-normal--*-180*
	    pack append .gkUsers .gkUsers.lbl top
	    foreach i [others] {
		set unum [keylget i usernum]
		label .gkUsers.l$unum -text [keylget i username]
		pack append .gkUsers .gkUsers.l$unum top
	    }
	} else {
	    wm deiconify .gkUsers
	}
    } else {
	if {[winfo exists .gkUsers] == 1} {
	    wm withdraw .gkUsers
	}
    }
}


trace variable deleted_user w gkRemoveUserFromWindow
trace variable new_user w gkAddUserToWindow

proc gkRemoveUserFromWindow args { global deleted_user
    set unum [keylget deleted_user usernum]
    catch {pack unpack .gkUsers.l$unum}
    return ""
}

proc gkAddUserToWindow args { global new_user
    if {[winfo exists .gkUsers] == 1} {
	set unum [keylget new_user usernum]
	label .gkUsers.l$unum -text [keylget new_user username]
	pack append .gkUsers .gkUsers.l$unum top
    }
    return ""
}

proc gkAbout {} {  global gk_library
    if {[winfo exists .about] == 1} { return "" }
    toplevel .about 
    label .about.icon -bitmap @$gk_library/bitmaps/dont_panic.xbm -fg hotpink
    label .about.title -text "GroupKit" -font -Adobe-times-bold-r-normal--*-240*
    message .about.version -text "Version 1.0 Beta \n June 8, 1993" -width 200
    message .about.author -text "For more info, contact Mark Roseman <roseman@cpsc.ucalgary.ca>" -width 300
    button .about.ok -text "Okay" -command "destroy .about"
    pack append .about .about.icon left .about.title top .about.version top .about.author top .about.ok bottom
}

proc gkDefaultRCMenu w {
    frame $w -borderwidth 2 -relief raised
    menubutton $w.fileMenu -menu $w.fileMenu.m -text File -underline 0
    menu $w.fileMenu.m
    $w.fileMenu.m add command -label "Quit" -command "gkProperQuit" -underline 0

    menubutton $w.helpMenu -menu $w.helpMenu.m -text Help -underline 0
    menu $w.helpMenu.m
    $w.helpMenu.m add command -label "About GroupKit" -command "gkAbout"

    pack append $w $w.fileMenu left $w.helpMenu right
}
