/* win.h
**************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.
******************************************************************************/

#ifndef _VTEM_HEADER
#define _VTEM_HEADER
#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <fcntl.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include "compat.h"

#define BITS7 '\177'
#define NUL '\200'

#define BYTE7(X) ((X) & BITS7)


#define FILEMESS(FILENAME,STRING) {	\
  char buf[256];                   	\
  FILE *foo;                       	\
  if ((foo=fopen(FILENAME,"a")) > (FILE *)0) { 	\
    fprintf(foo,"%s",STRING);      	\
    fclose(foo);                   	\
  }                                	\
}

#ifndef DEBUG
#define DEBUG0(LEVEL,STR)                NULL
#define DEBUG1(LEVEL,STR,ARG)            NULL
#define DEBUG2(LEVEL,STR,A1,A2)          NULL
#define DEBUG3(LEVEL,STR,A1,A2,A3)       NULL
#define DEBUG4(LEVEL,STR,A1,A2,A3,A4)    NULL
#define DEBUG5(LEVEL,STR,A1,A2,A3,A4,A5) NULL
#else
#define DEBUG0(LEVEL,STR)                {if(LEVEL<=DEBUG) FILEMESS(WLOG,(sprintf(buf,"%s" ## STR,indent),buf));}
#define DEBUG1(LEVEL,STR,ARG)            {if(LEVEL<=DEBUG) FILEMESS(WLOG,(sprintf(buf,"%s" ## STR,indent,ARG),buf));}
#define DEBUG2(LEVEL,STR,A1,A2)          {if(LEVEL<=DEBUG) FILEMESS(WLOG,(sprintf(buf,"%s" ## STR,indent,A1,A2),buf));}
#define DEBUG3(LEVEL,STR,A1,A2,A3)       {if(LEVEL<=DEBUG) FILEMESS(WLOG,(sprintf(buf,"%s" ## STR,indent,A1,A2,A3),buf));}
#define DEBUG4(LEVEL,STR,A1,A2,A3,A4)    {if(LEVEL<=DEBUG) FILEMESS(WLOG,(sprintf(buf,"%s" ## STR,indent,A1,A2,A3,A4),buf));}
#define DEBUG4(LEVEL,STR,A1,A2,A3,A4)    {if(LEVEL<=DEBUG) FILEMESS(WLOG,(sprintf(buf,"%s" ## STR,indent,A1,A2,A3,A4),buf));}
#define DEBUG5(LEVEL,STR,A1,A2,A3,A4,A5) {if(LEVEL<=DEBUG) FILEMESS(WLOG,(sprintf(buf,"%s" ## STR,indent,A1,A2,A3,A4,A5),buf));}
#endif

#if defined(NLS)
/* There appears to be a bug in setting margins */
#define TMARG(W) (W)->win->_tmarg
#define BMARG(W) (W)->win->_bmarg
#define wsetscroll(W,MT,MB) wsetscrreg(W->win,MT,MB)
#else
#define TMARG(W) (W)->tmarg
#define BMARG(W) (W)->bmarg
#define wsetscroll(W,MT,MB) (TMARG(W)=MT,BMARG(W)=MB)
#endif

#define ECHOP_DEFAULT "0"
#define BREAKS_DEFAULT "0"
#define TABSPACEP_DEFAULT "0"
#define CRNLP_DEFAULT "0"

#define RETRY 1
#define WLOG  "debug.log"
#define FAILURE -1
#ifndef ERR
#define ERR (-1)
#endif
#define STOPPED -1L

#define MAXSESSION 17

#define BEL (7)
#define SI (15)
#define ESC ('\033')
#define MAXTERMARG (10)
#define MAXTERMVAR (26)
#define TERMESC '@'

#define MAXEBITS 64

#define XMAX 256
#define XMIN 0
#define YMAX 128
#define YMIN 0

#define WIN_UNGET_MAX 	(XMAX)
#define WIN_COOKED_MAX 	(XMAX)
#define WIN_TABS_MAX	(XMAX)
#define WIN_RAW_MAX 	(4028)
#define WIN_EXP_MAX 	(4028)
#define WIN_SESSION_MAX (64)

#define WIN_DEFAULT_WINBAR ((char *)-1)

typedef struct TermTabStruct {
    short int termtab;
    char *type;
    char Local;
    char InsertMode;
    char *str_acsc;
    char *str_apstr;
    char *str_batt1;
    char *str_batt2;
    char *str_box1;
    char *str_box2;
    char *str_colb0;
    char *str_colb1;
    char *str_colb2;
    char *str_colb3;
    char *str_colb4;
    char *str_colb5;
    char *str_colb6;
    char *str_colb7;
    char *str_colf0;
    char *str_colf1;
    char *str_colf2;
    char *str_colf3;
    char *str_colf4;
    char *str_colf5;
    char *str_colf6;
    char *str_colf7;
    char *str_if;
    char *str_ip;
    char *str_iprog;
    char *str_kBEG;
    char *str_kCAN;
    char *str_kCMD;
    char *str_kCPY;
    char *str_kCRT;
    char *str_kDC;
    char *str_kDL;
    char *str_kEND;
    char *str_kEOL;
    char *str_kEXT;
    char *str_kFND;
    char *str_kHLP;
    char *str_kHOM;
    char *str_kIC;
    char *str_kLFT;
    char *str_kMOV;
    char *str_kMSG;
    char *str_kNXT;
    char *str_kOPT;
    char *str_kPRT;
    char *str_kPRV;
    char *str_kRDO;
    char *str_kRES;
    char *str_kRIT;
    char *str_kRPL;
    char *str_kSAV;
    char *str_kSPD;
    char *str_kUND;
    char *str_ka1;
    char *str_ka3;
    char *str_kb2;
    char *str_kbeg;
    char *str_kbs;
    char *str_kbtab;
    char *str_kc1;
    char *str_kc3;
    char *str_kcan;
    char *str_kcbt;
    char *str_kclo;
    char *str_kclr;
    char *str_kcmd;
    char *str_kcpn;
    char *str_kcpy;
    char *str_kcrt;
    char *str_kctab;
    char *str_kcub1;
    char *str_kcud1;
    char *str_kcuf1;
    char *str_kcuu1;
    char *str_kdch1;
    char *str_kdl1;
    char *str_kdo;
    char *str_ked;
    char *str_kel;
    char *str_kend;
    char *str_kent;
    char *str_kext;
    char *str_kf0;
    char *str_kf1;
    char *str_kf2;
    char *str_kf3;
    char *str_kf4;
    char *str_kf5;
    char *str_kf6;
    char *str_kf7;
    char *str_kf8;
    char *str_kf9;
    char *str_kf10;
    char *str_kf11;
    char *str_kf12;
    char *str_kf13;
    char *str_kf14;
    char *str_kf15;
    char *str_kf16;
    char *str_kf17;
    char *str_kf18;
    char *str_kf19;
    char *str_kf20;
    char *str_kf21;
    char *str_kf22;
    char *str_kf23;
    char *str_kf24;
    char *str_kf25;
    char *str_kf26;
    char *str_kf27;
    char *str_kf28;
    char *str_kf29;
    char *str_kf30;
    char *str_kf31;
    char *str_kf32;
    char *str_kf33;
    char *str_kf34;
    char *str_kf35;
    char *str_kf36;
    char *str_kf37;
    char *str_kf38;
    char *str_kf39;
    char *str_kf40;
    char *str_kf41;
    char *str_kf42;
    char *str_kf43;
    char *str_kf44;
    char *str_kf45;
    char *str_kf46;
    char *str_kf47;
    char *str_kf48;
    char *str_kf49;
    char *str_kf50;
    char *str_kf51;
    char *str_kf52;
    char *str_kf53;
    char *str_kf54;
    char *str_kf55;
    char *str_kf56;
    char *str_kf57;
    char *str_kf58;
    char *str_kf59;
    char *str_kf60;
    char *str_kf61;
    char *str_kf62;
    char *str_kf63;
    char *str_kfnd;
    char *str_khlp;
    char *str_khome;
    char *str_khts;
    char *str_kich1;
    char *str_kil1;
    char *str_kind;
    char *str_kll;
    char *str_kmov;
    char *str_kmpf1;
    char *str_kmpf2;
    char *str_kmpf3;
    char *str_kmpf4;
    char *str_kmpf5;
    char *str_kmpt1;
    char *str_kmpt2;
    char *str_kmpt3;
    char *str_kmpt4;
    char *str_kmpt5;
    char *str_kmrk;
    char *str_kmsg;
    char *str_knl;
    char *str_knp;
    char *str_knpn;
    char *str_knxt;
    char *str_kopn;
    char *str_kopt;
    char *str_kpcmd;
    char *str_kpp;
    char *str_kppn;
    char *str_kpquit;
    char *str_kprt;
    char *str_kprv;
    char *str_krdo;
    char *str_kref;
    char *str_kres;
    char *str_krfr;
    char *str_kri;
    char *str_krmir;
    char *str_krpl;
    char *str_krst;
    char *str_ksav;
    char *str_kscl;
    char *str_kscr;
    char *str_kslt;
    char *str_kspd;
    char *str_ktab;
    char *str_ktbc;
    char *str_kund;
    char *str_lf0;
    char *str_lf10;
    char *str_lf1;
    char *str_lf2;
    char *str_lf3;
    char *str_lf4;
    char *str_lf5;
    char *str_lf6;
    char *str_lf7;
    char *str_lf8;
    char *str_lf9;
    char *str_pad;
    char *str_rf;
    char *str_rmp;
    char *str_use;
    char *str_xoffc;
    char *str_xonc;
    char bool_am;
    char bool_bw;
    char bool_chts;
    char bool_cmdch;
    char bool_da;
    char bool_db;
    char bool_eo;
    char bool_eslok;
    char bool_gn;
    char bool_hc;
    char bool_hpAutoKbdLock;
    char bool_hpAutoLinefeed;
    char bool_hpAutoTerm;
    char bool_hpBlockMode;
    char bool_hpCapsLock;
    char bool_hpClearTerm;
    char bool_hpDispFuns;
    char bool_hpFormatMode;
    char bool_hpInhibitDC2;
    char bool_hpInhibitEOLWrap;
    char bool_hpInhibitHandshake;
    char bool_hpKbdLock;
    char bool_hpKeys;
    char bool_hpMemLock;
    char bool_hpPageMode;
    char bool_hpSPOW;
    char bool_hpTransmitFuns;
    char bool_hs;
    char bool_hz;
    char bool_in;
    char bool_km;
    char bool_labels;
    char bool_mc5i;
    char bool_mir;
    char bool_mrcup;
    char bool_msgr;
    char bool_npc;
    char bool_nrrmc;
    char bool_nxon;
    char bool_os;
    char bool_ul;
    char bool_xenl;
    char bool_xhp;
    char bool_xon;
    char bool_xsb;
    char bool_xt;
    int int_cols;
    int int_it;
    int int_lh;
    int int_lines;
    int int_lm;
    int int_lw;
    int int_nlab;
    int int_pb;
    int int_vt;
    int int_wsl;
    int int_xmc;
  } TermTab;

/* some definitions for event lines to check */
typedef char *NAME;
typedef void (*FPTR)();
typedef int (*IFPTR)();
typedef short Bool;
typedef int PID, GID, FileDesc;
typedef struct SessionStruct {
/*  WINDOW 	*win; */
  struct _win_st *win;
  FileDesc	fd;
  FILE		*outp, *inp; 
  PID 		pid;
  short 	tabs[WIN_TABS_MAX], tmarg, bmarg, rmarg, lmarg;
  long 		save_x, save_y, num, x, y, rows, columns;
  Bool		save_blink, save_bold, save_reverse, save_underline;
  Bool     	wrap, input_p, input_cached_p, dribble_p;
  Bool		echop, crnlp, tabspacep, breaksp;
  char		*raw_log_filename, *cooked_log_filename;
  FILE		*raw_log, *cooked_log;
  TermTab	*term, *termOriginal;
  long		cookedIndex;
  char		*rawBuff; /* Read Raw Into Buf */
  long		rawIndex, rawEnd, rawMax;
  long		expIndex;
  struct {
   long minrow, maxrow, mincol, maxcol;
  } pad;
} SESSION;

extern long MaxSession;
extern long WinbarP;
extern int loguser; /* was QuietP; */
extern char charyx();
extern char Buffer[];
extern char *indent;
extern long InitScr, ChildDiedP;
extern long winbar();
extern SESSION *CurrSession, *Sessions[];
extern char *ExpectLogDir;
extern char *ExpectDir;
extern SESSION *Session;
/** Runtime Routines **/
extern DoDribble(), Undribble();
extern fatal();
extern char *ScreenDumpContents();
extern struct _win_st	*stdscr, *curscr;
extern char *SetStatusLine();
extern double TimevalToDouble(), TimeOfDay();
extern struct timeval *DoubleToTimeval();
extern int loguser;
extern char *getenv();
extern char *get_var();
extern void do_reset();
#endif
