/* termfuncs.c
***************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.
******************************************************************************

Written by: Mark Weissman 9/92
*/


#include "win.h"
#include "termfuncs.h"
#define ARGTIMES(FORM) \
{ switch(Argno) { \
  case 0: Arg[0]=1; \
  case 1: while(Arg[0]--) {  FORM; } \
  } \
}

#define ARGCOUNT ((Argno==0)?1:Arg[0])

long Arg[MAXTERMARG], Argno=0, Vars[MAXTERMVAR];

void do_nothing()			{}

void do_CRNL_on()			{Session->crnlp = 0;}
void do_CRNL_off()			{Session->crnlp = 1;}

void do_TABSPACE_on()			{Session->tabspacep = 0;}
void do_TABSPACE_off()			{Session->tabspacep = 1;}

void do_ECHO_on()			{Session->echop = 0;}
void do_ECHO_off()			{Session->echop = 1;}

void do_protect()			{wattron(Session->win,A_PROTECT);}
void do_noprotect() 			{wattroff(Session->win,A_PROTECT);}

void do_bold() 				{wattron(Session->win,A_BOLD);}
void do_nobold() 			{wattroff(Session->win,A_BOLD);}

void do_reverse() 			{wattron(Session->win,A_REVERSE);}
void do_noreverse() 			{wattroff(Session->win,A_REVERSE);}

void do_dim() 				{wattron(Session->win,A_DIM);}
void do_nodim() 			{wattroff(Session->win,A_DIM);}

void do_underline() 			{wattron(Session->win,A_UNDERLINE);}
void do_nounderline() 			{wattroff(Session->win,A_UNDERLINE);}

void do_blink() 			{wattron(Session->win,A_BLINK);}
void do_noblink() 			{wattroff(Session->win,A_BLINK);}

void do_invisible() 			{wattron(Session->win,A_INVIS);}
void do_noinvisible() 			{wattroff(Session->win,A_INVIS);}

void do_altcharset() 			{wattron(Session->win,A_ALTCHARSET);}
void do_noaltcharset() 			{wattroff(Session->win,A_ALTCHARSET);}

void do_standout() 			{wattron(Session->win,A_STANDOUT);}
void do_nostandout() 			{wattroff(Session->win,A_STANDOUT);}

void do_normal()
{
/*  if (Session->win->_attrs & A_STANDOUT) wstandend(Session->win); */
  wattrset(Session->win,A_NORMAL); 
}

void do_sgr()
{
  do_normal();
  if ((Argno >= 1) && Arg[0]) do_standout();
  if ((Argno >= 2) && Arg[1]) do_underline();
  if ((Argno >= 3) && Arg[2]) do_reverse();
  if ((Argno >= 4) && Arg[3]) do_blink();
  if ((Argno >= 5) && Arg[4]) do_dim();
  if ((Argno >= 6) && Arg[5]) do_bold();
  if ((Argno >= 7) && Arg[6]) do_invisible();
  if ((Argno >= 8) && Arg[7]) do_protect();
  if ((Argno >= 9) && Arg[8]) do_altcharset();
}

void do_VTModes()
{
  int i;
  for (i=0; i < (Argno?Argno:1); ++i)
    switch (Arg[i]) {
    case 0: do_normal(); break;
    case 1: do_bold(); break;
    case 4: do_underline(); break;
    case 5: do_blink(); break;
    case 7: do_standout(); break;
    }
}

void do_cursor_invisible() 		{curs_set(0);}
void do_cursor_normal() 		{curs_set(1);}
void do_cursor_brighter() 		{curs_set(2);}

void do_start_keypad() 			{keypad(Session->win,TRUE);}
void do_stop_keypad() 			{keypad(Session->win,FALSE);}

void do_enter_xon_xoff_mode() 		{}
void do_exit_xon_xoff_mode() 		{}

void do_enter_meta_mode() 		{meta(Session->win,TRUE);}
void do_exit_meta_mode() 		{meta(Session->win,FALSE);}

void do_enter_insert_mode() 		{Session->term->InsertMode=1;}
void do_exit_insert_mode() 		{Session->term->InsertMode=0;}

void do_enter_delete_mode() 		{}
void do_exit_delete_mode() 		{}

void do_set_left_margin() 		{Session->lmarg = Arg[0];}
void do_set_right_margin() 		{Session->rmarg = Arg[0];}

void do_enter_automatic_margin_mode()	{}
void do_exit_automatic_margin_mode() 	{}
void do_clear_soft_margins() 		{Session->lmarg = 0; Session->rmarg = Session->columns; }

void do_set_window () {}
void do_print_screen () {}
void do_printer_on () {}
void do_printer_off () {}
void do_print_nbytes () {}

void do_disable_soft_labels() 		{
  Session->term->bool_labels = 0;
}
void do_enable_soft_labels() 		{
  Session->term->bool_labels = 1;
}
void do_program_label() {/* Program label #1 to show string #2 */
  if (Argno > 0 && Arg[0] >= 0 && Arg[0] <= 10) {
    char **lfptr, *olf;
    
    lfptr = (char **)&(Session->term->str_lf0) + Arg[0];
    olf   = *((char **)&(Session->termOriginal->str_lf0) + Arg[0]);
      
    if (*lfptr != olf && *lfptr > (char *)0) free(*lfptr);
    
    if (Argno > 1 && Arg[1] > 0) {
      *lfptr = (char *)malloc(strlen((char *)Arg[1])+2);
      strcpy(*lfptr,(char *)Arg[1]);
    }
    else {
      *lfptr = (char *)Strdup(" ");
      **lfptr = '\0';
    }
    (*lfptr)[strlen(*lfptr)+1] = 's'; /* Hide Type info after string */
    if (Arg[0] > 0) {
      int n = Arg[0] - 1;
      static int lpos[] = {0, 9, 18, 27, 45, 54, 63, 72};
      int oattrs = Session->win->_attrs;
      char template[32], lbuf[XMAX], *lptr=lbuf;
      int lh = Session->term->int_lh, lw = Session->term->int_lw, nlab = Session->term->int_nlab;
      int l, space, x, y;
      int ox = Session->x, oy = Session->y;
	
      memset(lbuf,' ',XMAX);
      strncpy(lbuf,(char *)Arg[1], strlen((char *)Arg[1]));
      
      if (lh <= 0) lh = 1;
      if (lw <= 0) lw = 8;
      if (nlab <= 0) nlab = 8;
      space = Session->columns - nlab*lw;
      sprintf(template,"%%-%ds", lw);
      x = (nlab==8 && lw == 8) ? lpos[n] : ((lw*n) + ((nlab>=2)?((n*space) / (nlab-1)):0));
      do_normal();
      do_standout();
      for(l=lh;l > 0;--l) {
	*(lptr=(lbuf+(l*lw)))='\0';
	y = (Session->rows - (lh-l+1));
	lptr -= lw;
	mvwprintw(Session->win, y, x, template, lptr);
	*lptr = '\0';
      }
      wattrset(Session->win, oattrs);
      do_normal();		/* I'm not sure this should reset attributes */
      wmove(Session->win, oy, ox);
    }
  }
}
void do_program_xmit() { /* Program funct key #1 to transmit string #2 */
  if (Argno > 0 && Arg[0] >= 0 && Arg[0] <= 10) {
    char **kfptr, *okf;
    
    kfptr = (char **)&(Session->term->str_kf0) + Arg[0];
    okf   = *((char **)&(Session->termOriginal->str_kf0) + Arg[0]);

    if (*kfptr != okf && (int)*kfptr > 0) free(*kfptr);
    
    if (Argno > 1 && Arg[1] > 0) {
      *kfptr = (char *)malloc(strlen((char *)Arg[1])+2);
      strcpy(*kfptr,(char *)Arg[1]);
    }
    else {
      *kfptr = (char *)Strdup(" ");
      **kfptr = '\0';
    }
    /* The 'X' below is what tells the function key to transmit this string!!! */
    (*kfptr)[strlen(*kfptr)+1] = 'X'; /* Hide Type info after string */
  }
}
void do_program_type() {/*Program funct key #1 to type string #2*/
  if (Argno > 0 && Arg[0] >= 0 && Arg[0] <= 10) {
    char **kfptr, *okf;
    
    kfptr = (char **)&(Session->term->str_kf0) + Arg[0];
    okf   = *((char **)&(Session->termOriginal->str_kf0) + Arg[0]);

    if (*kfptr != okf && (int)*kfptr > 0) free(*kfptr);
    
    if (Argno > 1 && Arg[1] > 0) {
      *kfptr = (char *)malloc(strlen((char *)Arg[1])+2);
      strcpy(*kfptr,(char *)Arg[1]);
    }
    else {
      *kfptr = (char *)Strdup(" ");
      **kfptr = '\0';
    }
    /* The 'T' below is what tells the function key to type this string!!! */
    (*kfptr)[strlen(*kfptr)+1] = 'T'; /* Hide Type info after string */
  }
}
void do_program_local() {  /* Program funct key #1 to execute string #2 */
  if (Argno > 0 && Arg[0] >= 0 && Arg[0] <= 10) {
    char **kfptr, *okf;
    
    kfptr = (char **)&(Session->term->str_kf0) + Arg[0];
    okf   = *((char **)&(Session->termOriginal->str_kf0) + Arg[0]);

    if (*kfptr != okf && (int)*kfptr > 0) free(*kfptr);
    
    if (Argno > 1 && Arg[1] > 0) {
      *kfptr = (char *)malloc(strlen((char *)Arg[1])+2);
      strcpy(*kfptr,(char *)Arg[1]);
    }
    else {
      *kfptr = (char *)Strdup(" ");
      **kfptr = '\0';
    }
    /* The 'L' below is what tells the function key to locally type this string!!! */
    (*kfptr)[strlen(*kfptr)+1] = 'L'; /* Hide Type info after string */
  }
}

void do_enable_altchar_mode() 	{}
void do_disable_altchar_mode() 	{}

void do_request_for_input() 		{}

void do_underline_char() 		{}

void do_display_status() 		{}
void do_go_to_status() 			{}
void do_return_from_status() 		{}
void do_nodisplay_status() 		{}

void do_cursor_down_half_line() 	{}
void do_cursor_up_half_line() 		{}

void do_wrap() 				{Session->wrap = 1;}
void do_nowrap() 			{Session->wrap = 0;}

void do_enter_cursor_addressing_mode() 	{Session->crnlp = 1;}
void do_exit_cursor_addressing_mode() 	{Session->crnlp = 0;}
void do_curse_up() 			{ Go((Session->y)-ARGCOUNT,(Session->x));}
void do_curse_down()			{ Go((Session->y)+ARGCOUNT,(Session->x));}
void do_curse_forward()			{
  if (Session->term->Local) {
    int n = ARGCOUNT;
    if ((Session->x + n) >= (Session->columns - 1)) {
      n = (Session->columns - Session->x - 1);
      do_bell();
      Go(Session->y, Session->x+n);
    }
  }
  else if (Session->term->bool_xhp==1) {
    char c;
    /* standout not erased by overwriting */ /* This is probably the wrong flag */
    ARGTIMES(BPUTC(Session, (c=charyx(Session->y, Session->x))?c:' '));
  }
  else {
    ARGTIMES(Go((Session->y),(Session->x)+1));
  }
}
void do_curse_back() { 
  Go((Session->y),(Session->x-ARGCOUNT));
  if (Session->term->Local) {
    if (attryx(Session->y, Session->x) != 'P') NextField(-1);
    { int ox = Session->x, oy = Session->y;
      BPUTC(Session,' ');
      Go(oy, ox);
    }
  }
}
void do_scroll_left() 			{}
void do_scroll_right() 			{}
void do_scroll_reverse()		{
  int n = ARGCOUNT;
  if (Session->term->Local) {
    if ((Session->y - n) < YMIN) {
      do_bell();
      n = Session->y;
    }
  }
  Go((Session->y)-n,(Session->x));
}
void do_scroll_forward()		{ 
  int n = ARGCOUNT;
  if (Session->term->Local) {
    if ((Session->y + n) >= Session->rows) {
      do_bell();
      n = Session->rows - Session->y - 1;
    }
  }
  if (Session->crnlp) 
    Go((Session->y)+n,(Session->x));
  else Go((Session->y)+n,XMIN); 
}
void do_newline(){
  extern char *OutputSequence;
  if (Session->crnlp && (*OutputSequence != '\r')) Go((Session->y)+ARGCOUNT,(Session->x));
  else Go((Session->y)+ARGCOUNT,XMIN);
}
void do_set_cursor()
{
  long nx=XMIN, ny=YMIN;
  /*CacheInput();*/ 
  switch (Argno) {
  case 2: if (Arg[1]) nx=((Arg[1]>0)?Arg[1]:0);
  case 1: if (Arg[0]) ny=((Arg[0]>0)?Arg[0]:0);
  }
  Go(ny,nx);
}
void do_home() {
  Go(YMIN,XMIN);
  if (Session->term->Local) NextField(0);
}
void do_set_cursor_column() 		{ 
  if (Arg[0] > Session->x && (Session->term->bool_xhp==1)) {
    /* Propogate Attribute */
    int x=Session->x, y=Session->y;
    char c;
    for (x=Session->x; x<Arg[0]; ++x) mvwaddch(Session->win, y, x, ((c=charyx(y,x))?c:' '));
  }
  Go((Session->y),Arg[0]);
}
void do_set_cursor_row() 		{ 
  Go(Arg[0],(Session->x));
}
void do_save_cursor() 			{Session->save_x = (Session->x); Session->save_y = (Session->y);}
void do_restore_cursor() 		{ Go(Session->save_y,Session->save_x);}
void do_carriage_return()
{
  /* Comment out smart version.  If you need \r\n to \n mapping use ExpectCap entry */
  if (Session->term->Local) {
    int op=0, x, y;
    char fieldsep = (char)31, blockterm = (char)30;
    char fbuf[BUFSIZ], *b=fbuf;
    if (Session->win->_y) {
      for(y=0; y < Session->rows; ++y) {
	if (Session->win->_y[y]) {
	  for (x=0; x < Session->columns; ++x) {
	    int np = (attryx(y,x) == 'P');
	    if (!op && np && b != fbuf) {
	      if (Session->term->bool_hpFormatMode==1) *b++ = fieldsep;
	      else {
		*b++ = '\r';
		if (Session->term->bool_hpAutoLinefeed==1) *b++ = '\n';
	      }
	    }
	    if (np) *b++ = charyx(y,x);
	    op = np;
	  }
	}
      }
    }
    if (b != fbuf && (Session->term->bool_hpFormatMode!=1)) *b++ = '\r';
    *b++ = blockterm;
    *b = '\0';
    write(Session->fd, fbuf, b-fbuf);
  }
  else Go((Session->y),XMIN); 
}
void do_set_tab_stop() 			{Session->tabs[Session->x] = 1;}
void do_clear_tab() 			{Session->tabs[Session->x] = 0;}
void do_clear_tabs() 			{long i; for (i = 0; i<Session->columns; i++) Session->tabs[i] = 0;}
void do_backtab() 			{
  if (Session->term->Local) {
    long y=Session->y, x=Session->x;
    for(;attryx(y, x-1) == 'P'; --x);
    if (x != Session->x) Go(y,x);
    else {
      Go(y,x);
      NextField(-1);
      y=Session->y, x=Session->x;
      for(;attryx(y, x-1) == 'P'; --x);
      Go(y,x);
    }
  }
}
void do_tab()
{
  if (Session->term->Local) {
    NextField((attryx(Session->y,Session->x)=='P'));
  }
  else if (Session->tabspacep) {
    for (BPUTC(Session,' '); !Session->tabs[(Session->x)];BPUTC(Session,' '));
  }
  else for (Go((Session->y),(Session->x+1)); !Session->tabs[Session->x];Go((Session->y),(Session->x+1)));
}
void do_font0() 		{wattrset(Session->win,A_NORMAL);}
void do_font1() 		{wattrset(Session->win,A_ALTCHARSET);}
void do_font2() 		{}
void do_font3() 		{}
void do_font4() 		{}
void do_font5() 		{}
void do_font6() 		{}
void do_font7() 		{}

void do_bell() 			{beep();}
void do_visible_bell() 		{}

void do_lower_left() 		{}

void do_formfeed() 		{}

void do_clear_to_eos() 		{ 
  if (Session->term->Local) {
    int ox = Session->x, oy = Session->y, x=ox, y=oy;
    int oattrs = Session->win->_attrs;
    for(; y < Session->rows; ++y, x=0)
      for(; x < Session->columns; ++x)
	if (attryx(y,x) == 'P') {
	  wattrset(Session->win, (Session->win->_y[y][x] & A_ATTRIBUTES));
	  mvwaddch(Session->win,y,x,' ');
	}
    wattrset(Session->win, oattrs);
    Go(oy, ox);
  }
  else wclrtobot(Session->win);
}
void do_clear_to_bos()
{				/* clr to bos */
  if (Session->term->Local) {
    int ox = Session->x, oy = Session->y, x=ox, y=oy;
    int oattrs = Session->win->_attrs;
    for(; y >= YMIN; --y, x=Session->rows-1)
      for(; x >= XMIN; --x)
	if (attryx(y,x) == 'P') {
	  wattrset(Session->win, (Session->win->_y[y][x] & A_ATTRIBUTES));
	  mvwaddch(Session->win,y,x,' ');
	}
    wattrset(Session->win, oattrs);
    Go(oy, ox);
  }
  else {
    long oy=(Session->y), ox=(Session->x), yy, xx;
   
    Go(YMIN,XMIN);		/* Allow for cache input */
    for (yy=0; yy<oy; ++yy) {
      wmove(Session->win, yy, 0);
      wclrtoeol(Session->win);
    }
    for(xx=0; xx<ox; ++xx) wdelch(Session->win);
    Go(oy,XMIN);
  }
}
void do_clear_to_eol() 		{ 
  if (Session->term->Local) {
    int x = Session->x, ox=x, y = Session->y, oy=y;
    while (attryx(y,x) == 'P') { BPUTC(Session,' '); ++x; }
    Go(oy, ox);
  }
  else wclrtoeol(Session->win);
}

void do_clear_to_bol()
{
  if (Session->term->Local) {
    int x = Session->x, y = Session->y;
    while (attryx(y,x) == 'P') --x;
    while (attryx(y,++x) == 'P') BPUTC(Session,' ');
    while (attryx(y,x) == 'P') --x;
    Go(Session->y, x+1);
  }
  else {
    long ox=Session->x;
    Go((Session->y),XMIN); 
    while (ox--) wdelch(Session->win);
  }
}

void do_clear()
{
  do_home();
  do_clear_to_eos();
}

void do_clear_line()
{
  if (Session->term->Local) {
    int ox = Session->x, oy = Session->y;
    Go(oy, XMIN);
    NextField(0);
    while (Session->y == oy) BPUTC(Session, ' ');
    Go(oy, ox);
  }
  else {
    Go((Session->y),XMIN);
    wclrtoeol(Session->win); 
  }
}

void do_erase_chars()
{
  long dx;
   
  BFLUSH(1);
  for (dx=(Session->x)+Arg[0]-1; dx>=Session->x; --dx) mvwaddch(Session->win,(Session->y),dx,' ');
  wmove(Session->win,(Session->y),(Session->x));
}

void do_delete_chars() { 
   
  BFLUSH(1); /* Last chance to look before deleting */
  ARGTIMES(wdelch(Session->win)); 
}

void do_insert_chars()
{ long ox=(Session->x), oy=(Session->y);
   
  BFLUSH(1); /* last chance to look at buffer before clobbering */
  ARGTIMES(winsch(Session->win,' '));
  wmove(Session->win,oy,ox);
}

void do_repeat_char() 		{ ARGTIMES(BPUTC(Session, (char)Arg[1])); }

void do_set_scroll_region()
{
  if (!Argno) Arg[0]=YMIN, Arg[1]=(Session->rows-1); 
  wsetscroll(Session,Arg[0],Arg[1]);
}

/* do_reset - Reset emulator and screen
 */
void do_reset()
{
  register long i;

   
  Session->wrap = 1;
  Session->save_y = YMIN-1;		/* So we know we haven't saved */
  for (i=XMIN; i<Session->columns; i++) Session->tabs[i] = ((i/8)*8 == i);
  wsetscroll(Session,YMIN,(Session->rows-1));
  BFLUSH(1); /* Flush old Buffer before clearing screen */
  (Session->x)=XMIN;
  (Session->y)=YMIN;
  do_clear();
  do_normal();
  wmove(Session->win, (Session->x), (Session->y));
}

/* The following are routines for VT102 compatibility
 */

void do_insert_line()
{
  long oy, ox;
  CacheInput();
  BFLUSH(1); /* Flush line to be replaced with insert */
  getyx(Session->win,oy,ox);
  ARGTIMES( {
    if (BMARG(Session) < (Session->rows-1)) {
      wmove(Session->win,BMARG(Session),0);
      wdeleteln(Session->win);
      wmove(Session->win,oy,ox);
    }
    winsertln(Session->win);
  });
}


void do_delete_line()
{
  long oy, ox;
  CacheInput();
  BFLUSH(1); /* Flush line to be deleted */
  getyx(Session->win,oy,ox);
  ARGTIMES( {
    wdeleteln(Session->win);
    if (BMARG(Session) < (Session->rows-1)) {
      wmove(Session->win,BMARG(Session),0);
      winsertln(Session->win);
      wmove(Session->win,oy,ox);
    }});
}


void do_HPDC2() {
  Session->term->bool_hpInhibitDC2 = (Arg[0]&&1);
}
void do_HPSHAKE() {
  Session->term->bool_hpInhibitHandshake = (Arg[0]&&1);
}
void do_HPXMITFUNS() {
  Session->term->bool_hpTransmitFuns = (Arg[0]&&1);
}
void do_HPSPOW() {
  Session->term->bool_hpSPOW = (Arg[0]&&1);
}
void do_HPEOLWRAP() {
  Session->term->bool_hpInhibitEOLWrap = (Arg[0]&&1);
}
void do_HPAUTOKBDLOCK() {
  Session->term->bool_hpAutoKbdLock = (Arg[0]&&1);
}
void do_HPAUTOLINEFEED() {
  Session->term->bool_hpAutoLinefeed = (Arg[0]&&1);
}
void do_HPCAPSLOCK() {
  Session->term->bool_hpCapsLock = (Arg[0]&&1);
}
void do_HPAUTOTERM() {
  Session->term->bool_hpAutoTerm = (Arg[0]&&1);
}
void do_HPCLEARTERM() {
  Session->term->bool_hpClearTerm = (Arg[0]&&1);
}
void do_HPKBDLOCK() {
  Session->term->bool_hpKbdLock = 1;
}
void do_HPKBDUNLOCK() {
  Session->term->bool_hpKbdLock = 0;
}
void do_HPMEMLOCK() {
  Session->term->bool_hpMemLock = 1;
}
void do_HPMEMUNLOCK() {
  Session->term->bool_hpMemLock = 0;
}
void do_HPDISPFUNS() {
  Session->term->bool_hpDispFuns = 1;
}
void do_HPNODISPFUNS() {
  Session->term->bool_hpDispFuns = 0;
}
void do_HPKEYS() {
  Session->term->bool_hpKeys = 1;
}
void do_HPNOKEYS() {
  Session->term->bool_hpKeys = 0;
}
void do_HPATTR() {
  int n = Arg[0] - '@';
  if (Argno > 1 && Arg[1]) n &= 16;
  if (!Argno) return;
  if (n==0) { do_normal(); return; }
  if (n & 1)  do_blink();
  if (n & 2)  do_reverse();
  if (n & 4)  do_underline();
  if (n & 8)  do_dim();
  if (n & 16) do_invisible();
}
void do_HPMODES() {
  if (Arg[0]) Session->term->bool_hpInhibitDC2       	= (Arg[0]=='1');
  if (Arg[1]) Session->term->bool_hpInhibitHandshake 	= (Arg[1]=='1');
  if (Arg[2]) { if (Arg[2]=='1') do_HPPAGE(); else do_HPNOPAGE(); }
  if (Arg[3]) Session->term->bool_hpInhibitEOLWrap	= (Arg[3]=='1');
  if (Arg[4]) Session->term->bool_hpSPOW 		= (Arg[4]=='1');
  if (Arg[5]) Session->term->bool_hpTransmitFuns 	= (Arg[5]=='1');
  if (Arg[6]) Session->term->bool_hpAutoTerm 		= (Arg[6]=='1');
  if (Arg[7]) Session->term->bool_hpClearTerm 		= (Arg[7]=='1');
}
void do_HPSTATUS1() {
  char *status = "\033\\0000000\r\n", *byte = status + 2;
  int wc, cc = strlen(status);
  TermTab *t = Session->term;
  byte[0] = '0' | 0; /* display mem in Kbytes: b3=8k, b2 = 4k, b1=2k, b0 = 1k */
  byte[1] = '0' |((t->bool_hpPageMode==1)<<3)|((t->bool_hpInhibitEOLWrap==1)<<2)|((t->bool_hpSPOW==1)<<1)|(t->bool_hpTransmitFuns==1);
  byte[2] = '0' |((t->bool_hpInhibitDC2==1)<<3)|((t->bool_hpInhibitHandshake==1)<<2);
  byte[3] = '0' |(1<<3)|((t->bool_hpAutoLinefeed==1)<<2)|((t->bool_hpBlockMode==1)<<1)|(t->bool_hpCapsLock==1);
  byte[4] = '0'; /* pending: b3=status2, b2=enter, b1=userfun, b0=cursor-sense */
  byte[5] = '0'; /* errors: b3=p2@rrinter, b2=0, b1=self-test, b0=framing, overrun or parity */
  byte[6] = '0'; /* pending: b3=0, b2=0, b1=DeviceOpStatus, b0=DeviceStatus */
  if ((t->bool_hpBlockMode==1) && (t->bool_hpPageMode==1)) cc -= 2;
  else if (t->bool_hpAutoLinefeed!=1) cc -= 1;
  wc = write(Session->fd,status, cc);
/*  debuglog("HPSTATUS1: Write(%d, \"^[%s\", %d) => %d\r\n", Session->fd, status+1, cc, wc); */
}

void do_HPSTATUS2() {
  char *status = "\033|0000000\r\n", *byte = status + 2;
  int wc, cc = strlen(status);
  TermTab *t = Session->term;
  byte[0] = '0'; /* nondisplay mem: b3=8k, b2 = 4k, b1=2k, b0 = 1k */
  byte[1] = '0' |(0<<3)|(1<<2)|(0<<1)|1;
  byte[2] = '0';
  byte[3] = '0';
  byte[4] = '0';
  byte[5] = '0';
  byte[6] = '0' |(0<<3)|(1<<2)|(1<<1)|1; /* b3=0, b2=mem-full, b1=memlock, b0 = not locked in row 0 */
  if ((t->bool_hpBlockMode==1) && (t->bool_hpPageMode==1)) cc -= 2;
  else if (t->bool_hpAutoLinefeed!=1) cc -= 1;
  wc = write(Session->fd,status, cc);
/*  debuglog("HPSTATUS1: Write(%d, \"^[%s\", %d) => %d\r\n", Session->fd, status+1, cc, wc); */
}

void do_HPDEVICEID() {
  char *status = "XXXXX\r\n";
  int wc, cc = strlen(status);
  TermTab *t = Session->term;

  if (*t->type == 'h') strncpy(status, t->type+2, 5);
  else strncpy(status, t->type, 5);
  if (status[4] == '\0') status[4] = 'B';

  if ((t->bool_hpBlockMode==1) && (t->bool_hpPageMode==1)) cc -= 2;
  else if (t->bool_hpAutoLinefeed!=1) cc -= 1;
  wc = write(Session->fd,status, cc);
  /*  debuglog("DEVICEID: write(%d, \"%s\", %d) => %d\r\n", Session->fd, status, cc, wc); */
}

static HPSetLocal() {
  Session->term->Local = 
    ((Session->term->bool_hpPageMode==1) 
     && (Session->term->bool_hpBlockMode==1)
     && (Session->term->bool_hpFormatMode==1));
}
void do_HPFORMAT() {
  Session->term->bool_hpFormatMode = 1;
  do_enter_insert_mode();
  HPSetLocal();
  do_clear_tabs();
  Session->lmarg = 0; Session->rmarg = Session->columns;
  Go(YMIN,XMIN);
  NextField(0);
}
void do_HPNOFORMAT() {
  Session->term->bool_hpFormatMode = 0;
  do_enter_insert_mode();
  HPSetLocal();
  Go(YMIN,XMIN);
  NextField(0);
}
void do_HPBLOCKMODE() {
  Session->term->bool_hpBlockMode = (Arg[0]&&1);
  HPSetLocal();
}
void do_HPPAGEMODE() {
  /* PageMode(1) LineMode(0) */
  if (Arg[0]) do_HPPAGE(); else do_HPNOPAGE();
}
void do_HPPAGE() {
  Session->term->bool_hpPageMode = 1;
  HPSetLocal();
}
void do_HPNOPAGE() {
  Session->term->bool_hpPageMode = 0;
  HPSetLocal();
}
