/*
 *
 * /afs/cs/project/edrc/ndim/source/bos/libbos/List_Insert.c,v 1.1.1.1 1992/05/08 19:45:45 snl Exp
 * 
 * HISTORY
 * 
 * List_Insert.c,v
 * Revision 1.1.1.1  1992/05/08  19:45:45  snl
 * bos 1.2
 *
 * Revision 2.1  91/04/15  11:40:19  snl
 * Created.
 * 
 */

/* 
 * List_Insert.c --
 *
 *	Source code for the List_Insert library procedure.
 *
 * Copyright 1988 Regents of the University of California
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "/afs/cs/project/edrc/ndim/source/bos/libbos/List_Insert.c,v 1.1.1.1 1992/05/08 19:45:45 snl Exp SPRITE (Berkeley)";
#endif not lint

#include <stdio.h>
#include "list.h"

extern void panic();

/*
 * ----------------------------------------------------------------------------
 *
 * List_Insert --
 *
 *	Insert the list element pointed to by itemPtr into a List after 
 *	destPtr.  Perform a primitive test for self-looping by returning
 *	failure if the list element is being inserted next to itself.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The list containing destPtr is modified to contain itemPtr.
 *
 * ----------------------------------------------------------------------------
 */
void
List_Insert(itemPtr, destPtr)
    register	List_Links *itemPtr;	/* structure to insert */
    register	List_Links *destPtr;	/* structure after which to insert it */
{
    if (itemPtr == (List_Links *) NIL || destPtr == (List_Links *) NIL
	    || !itemPtr || !destPtr) {
	panic("List_Insert: itemPtr (%x) or destPtr (%x) is NIL.\n",
		  (unsigned int) itemPtr, (unsigned int) destPtr);
	return;
    }
    if (itemPtr == destPtr) {
	panic("List_Insert: trying to insert something after itself.\n");
	return;
    }
    itemPtr->nextPtr = destPtr->nextPtr;
    itemPtr->prevPtr = destPtr;
    destPtr->nextPtr->prevPtr = itemPtr;
    destPtr->nextPtr = itemPtr;
}
