#
# /afs/cs/project/edrc/ndim/source/bos/base/debug.tcl,v 1.1 1992/05/21 04:07:32 snl Exp
#
# HISTORY
#
# debug.tcl,v
# Revision 1.1  1992/05/21  04:07:32  snl
# moved in some files from ndim/workspace
#
# Revision 1.1.1.1  1992/05/08  19:32:04  snl
# n-dim 0.82
#
# Revision 1.1  91/12/16  20:22:04  snl
# Initial revision
# 
#
# number of disabled break points ; -1 means all until _b_bena
global _b_disabled
set _b_disabled 0

proc _b_point {{name breakpoint} {_b_disarg 0}} {
# break point procedure 
# continue typed at the break point prompt continues execution of tcl code

  global _b_disabled
  uplevel {foreach _b_var [info vars] {
    if {[string match _b_* $_b_var]} {continue}
    print "$_b_var: [set $_b_var]\n"
  }}
  if {$_b_disabled > 0} {
    set _b_disabled [expr "$_b_disabled - 1"]
    return
  }
  if {$_b_disabled || $_b_disarg} {return}
  uplevel "set _b_name $name"
  uplevel {for {} {1} {} {
    print "$_b_name> "
    set _b_comm [exec csh -f -c "set _input = \$<; echo \"\$_input\""]
    if {![length $_b_comm]} {continue}
    set _b_comm [range $_b_comm 0 [expr "[length $_b_comm chars] - 2"] chars]
    if "[string match [set _b_comm]* continue]" {return}
    catch {eval $_b_comm} _b_res
    print $_b_res\n
  }}
}

proc _b_proc {proc} {
# sets break point at the begining of the procedure
# procedures that start with _b_ or end with -b_ are not changed

  set args ""
  if {[string match _b_* $proc] || [string match *-b_ $proc]} {
    print "breakpoint could not be inserted in procedure $proc\n"
    return 
  }
  foreach a [info args $proc] {
    if [info default $proc $a def] {
      set args "$args {$a $def}"
    } else {
      set args "$args $a"
    }
  }
  proc $proc $args "
    print \"\n---- proc $proc ------\n\"
    _b_point $proc
    [info body $proc]
  "
  print "breakpoint set for procedure $proc\n"
}

proc _b_comm {comm} {
# sets break point for a command 
# renames command to $comm-b_ and creates a procedure $comm
# commands in the variables protectedcomm are not changed, they are
# used in these procedures, so breakpointing them would couse 
# infinite recursion

  set protectedcomm {
    catch continue 
    eval exec expr 
    for foreach 
    global   
    if info   
    length   
    print proc 
    range rename return 
    set string  
    uplevel
  }
  if {[_b_member $comm "[info proc] $protectedcomm"]} {
    print "breakpoint could not be inserted for command $comm\n"
    return 
  }
  if {![length [info command $comm-b_]]} {
    rename $comm $comm-b_
  }
  proc $comm args "
    print \"\n---- command $comm -----\n\"
    _b_point $comm
    eval uplevel $comm-b_ {\$args}
  "
  print "breakpoint set for command $comm\n"
}

proc _b_proc_all {{pattern *}} {
# break all procedures

  foreach p [info proc $pattern] {
    _b_proc $p
  }
}

proc _b_comm_all {{pattern *}} {
# breal all commands

  foreach c [info command $pattern] {
    _b_comm $c
  }
}

proc _b_all {{pattern *}} {
# break all procedures and all commands

  foreach c [info command $pattern] {
    if {[_b_member $c [info proc]]} {
      _b_proc $c
    } else {
      _b_comm $c
    }
  }
}

proc _b_disable {{n -1}} {
# sets the values to the global variable _b_disabled
# see the comment for the variable

  global _b_disabled
  set _b_disabled $n
}

proc _b_enable {} {
# sets 0 to global variable _b_disabled
# see the comment for the variable

  global _b_disabled
  set _b_disabled 0
}

proc _b_member {e list} {
# utility function
# returns 1 if $e is member of $list otherwise 0

  foreach le $list {
    if {![string compare $le $e]} {return 1}
  }
  return 0
}
