#
# BitmapMenuButton.tcl,v 1.1.1.1 1992/05/08 19:46:01 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/BitmapMenuButton.tcl,v 1.1.1.1 1992/05/08 19:46:01 snl Exp
#
# HISTORY
#
# BitmapMenuButton.tcl,v
# Revision 1.1.1.1  1992/05/08  19:46:01  snl
# bos 1.2
#
# Revision 1.1  92/03/08  23:32:59  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:05:52  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:11:22  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:41:40  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:34:13  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:33:28  snl
# Initial revision
# 
#
GraphicalObject refineWith BitmapMenuButton

BitmapMenuButtonTraits defMethod initialize {parent bitmap group args} {
  set w [$self [$self graphicalObjectParent]:initializePhase1 $parent]
  eval "bitmapbutton $w -bitmap $bitmap -relief flat $args"
  $self set group $group
  $self [$self graphicalObjectParent]:initializePhase2 $parent
  $self bind <Enter> "$self activate"
  $self bind <B1-Enter> "$self activate; $self config -relief sunken; $self post"
  $self bind <B1-Leave> "$self deactivate; $self config -relief flat"
  $self bind <Shift-B1-Leave> "$self deactivate; $self config -relief flat"
  $self bind <Leave> "$self deactivate"
  $self bind <1> "$self config -relief sunken; $self post"
  $self bind <ButtonRelease-1> "$self config -relief flat; $self unpost"
  return $w
}
BitmapMenuButtonTraits defMethod activate {} {
  [$self window] activate
}
BitmapMenuButtonTraits defMethod deactivate {} {
  [$self window] deactivate
}
BitmapMenuButtonTraits defMethod post {} {
  if {![string compare [$self menu] ""]} {return {}}
  set Y [expr {[$self winfo rooty] + [$self winfo height]}]
  [$self menu] post [$self winfo rootx] $Y [[$self group] window]
}
BitmapMenuButtonTraits defMethod unpost {} {
  if {![string compare [$self menu] ""]} {return {}}
  [$self menu] unpost
}
BitmapMenuButtonTraits defMethod setMenu {menu} {
  $self set menu $menu
  return $menu
}
BitmapMenuButtonTraits defMethod getVariable {} {
  set v [$self config -variable]
  set vl [llength $v]
  -- vl
  return [lindex $v $vl]
}

BitmapMenuButton addSlot menu {}
BitmapMenuButton addSlot group {}
