*** tk3.6.OLD/tkCanvas.c	Wed Jan 12 18:44:12 1994
--- tk3.6.NEW/tkCanvas.c	Sat Jul 23 11:31:54 1994
***************
*** 1,5 ****
! 
! /* 
   * tkCanvas.c --
   *
   *	This module implements canvas widgets for the Tk toolkit.
--- 1,4 ----
! /*
   * tkCanvas.c --
   *
   *	This module implements canvas widgets for the Tk toolkit.
***************
*** 149,154 ****
--- 148,154 ----
  extern Tk_ItemType TkArcType, TkBitmapType, TkLineType;
  extern Tk_ItemType TkOvalType, TkPolygonType;
  extern Tk_ItemType TkRectangleType, TkTextType, TkWindowType;
+ extern Tk_ItemType TkIconType, TkEdgeType;
  
  /*
   * Various Tk_Uid's used by this module (set up during initialization):
***************
*** 978,983 ****
--- 978,1320 ----
  		break;
  	    }
  	}
+     } else if ((c == 'e') && (strncmp(argv[1], "edgeinfo", length) == 0)) {
+ 	int argc2, argc3, argc4, counter, appendIt;
+ 	char **argv2, **argv3, **argv4, convertBuffer[20];
+ 	Tcl_DString resultStr, command;
+ 	
+ 	if (argc < 3) {
+ 	  Tcl_AppendResult(canvasPtr->interp, "wrong # args:  should be \"",
+ 			   Tk_PathName(canvasPtr->tkwin), " edgeinfo ",
+ 			   "command ?options?\"", (char *) NULL);
+ 	  return TCL_ERROR;
+ 	}
+   
+ 	Tcl_DStringInit(&resultStr);
+ 	if (argc == 3) {
+ 	  if (!strcmp(argv[2], "ids")) {
+ 	    for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		 itemPtr = itemPtr->nextPtr) {
+ 	      if (!strcmp(itemPtr->typePtr->name, "edge")) {
+ 		sprintf(convertBuffer, "%d", itemPtr->id);
+ 		Tcl_DStringAppendElement(&resultStr, convertBuffer);
+ 	      }
+ 	    }
+ 	  } else if (!strcmp(argv[2], "names")) {
+ 	    for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		 itemPtr = itemPtr->nextPtr) {
+ 	      if (!strcmp(itemPtr->typePtr->name, "edge")) {
+ 		result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					  canvasPtr->tkwin,
+ 					  itemPtr->typePtr->configSpecs, 
+ 					  (char *) itemPtr, "-name", 0);
+ 		if (Tcl_SplitList(canvasPtr->interp,
+ 				  canvasPtr->interp->result,
+ 				  &argc2, &argv2) != TCL_OK) {
+ 		  goto edgeinfo_error;
+ 		}
+ 		Tcl_DStringAppendElement(&resultStr, argv2[4]);
+ 		ckfree((char *) argv2);
+ 	      }
+ 	    }
+ 	  } else if (!strcmp(argv[2], "graphs")) {
+ 	    for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		 itemPtr = itemPtr->nextPtr) {
+ 	      if (!strcmp(itemPtr->typePtr->name, "edge")) {
+ 		result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					  canvasPtr->tkwin,
+ 					  itemPtr->typePtr->configSpecs, 
+ 					  (char *) itemPtr,
+ 					  "-graphname", 0);
+ 		if (Tcl_SplitList(canvasPtr->interp,
+ 				  canvasPtr->interp->result,
+ 				  &argc2, &argv2) != TCL_OK) {
+ 		  goto edgeinfo_error;
+ 		}
+ 		if (Tcl_SplitList(canvasPtr->interp,
+ 				  resultStr.string,
+ 				  &argc3, &argv3) != TCL_OK) {
+ 		  goto edgeinfo_error;
+ 		}
+ 		appendIt = 1;
+ 		for (counter = 0; counter < argc3; counter++) {
+ 		  if (!strcmp(argv3[counter], argv2[4])) {
+ 		    appendIt = 0;
+ 		  }
+ 		}
+ 		if (appendIt) {
+ 		  Tcl_DStringAppendElement(&resultStr, argv2[4]);
+ 		}
+ 		ckfree((char *) argv2);
+ 		ckfree((char *) argv3);
+ 	      }
+ 	    }
+ 	  }
+ 	} else {
+ 	  if (argc == 4) {
+ 	    if (!strcmp(argv[2], "ids")) {
+ 	      for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		   itemPtr = itemPtr->nextPtr) {
+ 		result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					  canvasPtr->tkwin,
+ 					  itemPtr->typePtr->configSpecs, 
+ 					  (char *) itemPtr,
+ 					  "-graphname", 0);
+ 		if (Tcl_SplitList(canvasPtr->interp,
+ 				  canvasPtr->interp->result,
+ 				  &argc2, &argv2) != TCL_OK) {
+ 		  goto edgeinfo_error;
+ 		}
+ 		if (!strcmp(itemPtr->typePtr->name, "edge") &&
+ 		    !strcmp(argv2[4], argv[3])) {
+ 		  sprintf(convertBuffer, "%d", itemPtr->id);
+ 		  Tcl_DStringAppendElement(&resultStr, convertBuffer);
+ 		}
+ 		ckfree((char *) argv2);
+ 	      }
+ 	    } else if (!strcmp(argv[2], "names")) {
+ 	      for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		   itemPtr = itemPtr->nextPtr) {
+ 		result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					  canvasPtr->tkwin,
+ 					  itemPtr->typePtr->configSpecs, 
+ 					  (char *) itemPtr,
+ 					  "-graphname", 0);
+ 		if (Tcl_SplitList(canvasPtr->interp,
+ 				  canvasPtr->interp->result,
+ 				  &argc2, &argv2) != TCL_OK) {
+ 		  goto edgeinfo_error;
+ 		}
+ 		if (!strcmp(itemPtr->typePtr->name, "edge") &&
+ 		    !strcmp(argv2[4], argv[3])) {
+ 		  result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					    canvasPtr->tkwin,
+ 					    itemPtr->typePtr->configSpecs, 
+ 					    (char *) itemPtr, "-name", 0);
+ 		  if (Tcl_SplitList(canvasPtr->interp,
+ 				    canvasPtr->interp->result,
+ 				    &argc3, &argv3) != TCL_OK) {
+ 		    goto edgeinfo_error;
+ 		  }
+ 		  Tcl_DStringAppendElement(&resultStr, argv3[4]);
+ 		  ckfree((char *) argv3);
+ 		}
+ 		ckfree((char *) argv2);
+ 	      }
+ 	    }
+ 	  } else {
+ 	    if (!strcmp(argv[2], "id")) {
+ 	      for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		   itemPtr = itemPtr->nextPtr) {
+ 		if (strcmp(itemPtr->typePtr->name, "icon") == 0) {
+ 		  result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					    canvasPtr->tkwin,
+ 					    itemPtr->typePtr->configSpecs, 
+ 					    (char *) itemPtr, "-edges", 0);
+ 		  if (Tcl_SplitList(canvasPtr->interp,
+ 				    canvasPtr->interp->result,
+ 				    &argc2, &argv2) != TCL_OK) {
+ 		    goto edgeinfo_error;
+ 		  }
+ 		  if (Tcl_SplitList(canvasPtr->interp, argv2[4],
+ 				    &argc3, &argv3) != TCL_OK) {
+ 		    goto edgeinfo_error;
+ 		  }
+ 		  Tcl_DStringInit(&command);
+ 		  Tcl_DStringAppend(&command, "lsearch -glob {", -1);
+ 		  Tcl_DStringAppend(&command, argv2[4], -1);
+ 		  Tcl_DStringAppend(&command, "} \"", -1);
+ 		  Tcl_DStringAppend(&command, argv[4], -1);
+ 		  Tcl_DStringAppend(&command, " ", -1);
+ 		  Tcl_DStringAppend(&command, argv[5], -1);
+ 		  Tcl_DStringAppend(&command, " *\"", -1);
+ 		  Tcl_Eval(interp, command.string);
+ 		  if (strcmp(interp->result, "-1")) {
+ 		    if (Tcl_SplitList(canvasPtr->interp,
+ 				      argv3[atol(interp->result)],
+ 				      &argc4, &argv4) != TCL_OK) {
+ 		      goto edgeinfo_error;
+ 		    }
+ 		    Tcl_DStringAppend(&resultStr, argv4[2], -1);
+ 		    goto edgeinfo_finished;
+ 		  }
+ 		  Tcl_DStringFree(&command);
+ 		  ckfree((char *) argv3);
+ 		  ckfree((char *) argv2);
+ 		}
+ 	      }
+ 	    }
+ 	  }
+ 	}
+ 
+       edgeinfo_finished:
+ 	Tcl_ResetResult(interp);
+ 	Tcl_AppendResult(interp, resultStr.string, (char *) NULL);
+ 	Tcl_DStringFree(&resultStr);
+ 	return TCL_OK;
+ 
+       edgeinfo_error:
+ 	Tcl_ResetResult(interp);
+ 	return TCL_OK;
+ 	
+     } else if ((c == 'i') && (strncmp(argv[1], "iconinfo", length) == 0)) {
+ 	int argc2;
+ 	char **argv2, convertBuffer[20];
+ 	Tcl_DString resultStr;
+ 	
+ 	if (argc < 3) {
+ 	  Tcl_AppendResult(canvasPtr->interp, "wrong # args:  should be \"",
+ 			   Tk_PathName(canvasPtr->tkwin), " iconinfo ",
+ 			   "command ?options?\"", (char *) NULL);
+ 	  return TCL_ERROR;
+ 	}
+   
+ 	Tcl_DStringInit(&resultStr);
+ 	if (argc == 3) {
+ 	  if (!strcmp(argv[2], "ids")) {
+ 	    for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		 itemPtr = itemPtr->nextPtr) {
+ 	      if (!strcmp(itemPtr->typePtr->name, "icon")) {
+ 		sprintf(convertBuffer, "%d", itemPtr->id);
+ 		Tcl_DStringAppendElement(&resultStr, convertBuffer);
+ 	      }
+ 	    }
+ 	  } else if (!strcmp(argv[2], "names")) {
+ 	    for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		 itemPtr = itemPtr->nextPtr) {
+ 	      if (!strcmp(itemPtr->typePtr->name, "icon")) {
+ 		result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					  canvasPtr->tkwin,
+ 					  itemPtr->typePtr->configSpecs, 
+ 					  (char *) itemPtr, "-name", 0);
+ 		if (Tcl_SplitList(canvasPtr->interp,
+ 				  canvasPtr->interp->result,
+ 				  &argc2, &argv2) != TCL_OK) {
+ 		  goto iconinfo_error;
+ 		}
+ 		Tcl_DStringAppendElement(&resultStr, argv2[4]);
+ 		ckfree((char *) argv2);
+ 	      }
+ 	    }
+ 	  }
+ 	} else {
+ 	  if (!strcmp(argv[2], "id")) {
+ 	    for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 		 itemPtr = itemPtr->nextPtr) {
+ 	      if (strcmp(itemPtr->typePtr->name, "icon") == 0) {
+ 		result = Tk_ConfigureInfo(canvasPtr->interp,
+ 					  canvasPtr->tkwin,
+ 					  itemPtr->typePtr->configSpecs, 
+ 					  (char *) itemPtr, "-name", 0);
+ 		if (Tcl_SplitList(canvasPtr->interp,
+ 				  canvasPtr->interp->result,
+ 				  &argc2, &argv2) != TCL_OK) {
+ 		  goto iconinfo_error;
+ 		}
+ 		if (!strcmp(argv2[4], argv[3])) {
+ 		  sprintf(convertBuffer, "%d", itemPtr->id);
+ 		  Tcl_DStringAppend(&resultStr, convertBuffer, -1);
+ 		  ckfree((char *) argv2);
+ 		  goto iconinfo_finished;
+ 		}
+ 		ckfree((char *) argv2);
+ 	      }
+ 	    }
+ 	  }
+ 	}
+ 	
+       iconinfo_finished:
+ 	Tcl_ResetResult(interp);
+ 	Tcl_AppendResult(interp, resultStr.string, (char *) NULL);
+ 	Tcl_DStringFree(&resultStr);
+ 	return TCL_OK;
+ 
+       iconinfo_error:
+ 	Tcl_ResetResult(interp);
+ 	return TCL_OK;
+ 	
+     } else if ((c == 'l') && (strncmp(argv[1], "layout", length) == 0)) {
+ 	int gotAny = 0, gotAnyScroll = 0;
+ 	int argc2, x1 = 0, y1 = 0, x2 = 0, y2 = 0, xScroll2 = 0, yScroll2 = 0;
+ 	char buffer[100], **argv2;
+ 	
+ 	if (argc == 2) {
+ 	  Tcl_AppendResult(canvasPtr->interp, "wrong # args:  should be \"",
+ 			   Tk_PathName(canvasPtr->tkwin), " layout ",
+ 			   "type ?-option value?\"", (char *) NULL);
+ 	  return TCL_ERROR;
+ 	}
+   
+ 	for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 	     itemPtr = itemPtr->nextPtr) {
+ 	  if (!gotAny) {
+ 	    x1 = itemPtr->x1;
+ 	    y1 = itemPtr->y1;
+ 	    x2 = itemPtr->x2;
+ 	    y2 = itemPtr->y2;
+ 	    gotAny = 1;
+ 	  } else {
+ 	    if (itemPtr->x1 < x1) {
+ 	      x1 = itemPtr->x1;
+ 	    }
+ 	    if (itemPtr->y1 < y1) {
+ 	      y1 = itemPtr->y1;
+ 	    }
+ 	    if (itemPtr->x2 > x2) {
+ 	      x2 = itemPtr->x2;
+ 	    }
+ 	    if (itemPtr->y2 > y2) {
+ 	      y2 = itemPtr->y2;
+ 	    }
+ 	  }
+ 	}
+ 	result = TkCanvLayoutCmd(canvasPtr, interp, argc, argv);
+ 	for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 	     itemPtr = itemPtr->nextPtr) {
+ 	  if (!gotAny) {
+ 	    x1 = itemPtr->x1;
+ 	    y1 = itemPtr->y1;
+ 	    x2 = itemPtr->x2;
+ 	    y2 = itemPtr->y2;
+ 	    gotAny = 1;
+ 	  } else {
+ 	    if (itemPtr->x1 < x1) {
+ 	      x1 = itemPtr->x1;
+ 	    }
+ 	    if (itemPtr->y1 < y1) {
+ 	      y1 = itemPtr->y1;
+ 	    }
+ 	    if (itemPtr->x2 > x2) {
+ 	      x2 = itemPtr->x2;
+ 	    }
+ 	    if (itemPtr->y2 > y2) {
+ 	      y2 = itemPtr->y2;
+ 	    }
+ 	  }
+ 	  if (!gotAnyScroll) {
+ 	    xScroll2 = itemPtr->x2;
+ 	    yScroll2 = itemPtr->y2;
+ 	    gotAnyScroll = 1;
+ 	  } else {
+ 	    if (itemPtr->x2 > xScroll2) {
+ 	      xScroll2 = itemPtr->x2;
+ 	    }
+ 	    if (itemPtr->y2 > yScroll2) {
+ 	      yScroll2 = itemPtr->y2;
+ 	    }
+ 	  }
+ 	}
+ 	if (gotAny) {
+ 	  EventuallyRedrawArea(canvasPtr, x1, y1, x2, y2);
+ 	}
+ 	sprintf(buffer, "-scrollregion {0c 0c %d %d} ",
+ 		xScroll2 + 20, yScroll2 + 20);
+ 	if (Tcl_SplitList(interp, buffer, &argc2, &argv2) != TCL_OK) {
+ 	  return TCL_ERROR;
+ 	}
+ 	ConfigureCanvas(interp, canvasPtr, argc2, argv2,
+ 			TK_CONFIG_ARGV_ONLY);
+ 	ckfree((char *) argv2);
      } else if ((c == 'l') && (strncmp(argv[1], "lower", length) == 0)) {
  	Tk_Item *prevPtr;
  
***************
*** 1849,1855 ****
      TkLineType.nextPtr = &TkWindowType;
      TkWindowType.nextPtr = &TkBitmapType;
      TkBitmapType.nextPtr = &TkArcType;
!     TkArcType.nextPtr = NULL;
      allUid = Tk_GetUid("all");
      currentUid = Tk_GetUid("current");
  }
--- 2186,2194 ----
      TkLineType.nextPtr = &TkWindowType;
      TkWindowType.nextPtr = &TkBitmapType;
      TkBitmapType.nextPtr = &TkArcType;
!     TkArcType.nextPtr = &TkIconType;
!     TkIconType.nextPtr = &TkEdgeType;
!     TkEdgeType.nextPtr = NULL;
      allUid = Tk_GetUid("all");
      currentUid = Tk_GetUid("current");
  }
*** tk3.6.OLD/doc/canvas.n	Wed Jan 12 18:43:32 1994
--- tk3.6.NEW/doc/canvas.n	Sat Jul 23 11:31:36 1994
***************
*** 1,4 ****
! '\"
  '\" Copyright (c) 1992 The Regents of the University of California.
  '\" All rights reserved.
  '\"
--- 1,4 ----
! '\" 
  '\" Copyright (c) 1992 The Regents of the University of California.
  '\" All rights reserved.
  '\"
***************
*** 489,494 ****
--- 489,506 ----
  If \fItagToDelete\fR is omitted then it defaults to \fItagOrId\fR.
  This command returns an empty string.
  .TP
+ \fIpathName \fBedgeinfo command \fR?\fIgraphName\fR? \fR?\fIoptions\fR?
+ .VS
+ This command implements a fast access to certain edge
+ specific informations. The command "graphs" returns the
+ names of all graphs in the canvas. The command "ids" returns
+ all existing edge ids (or all edge ids belonging to a
+ specified graph), and the command "names" returns the names 
+ of all existing edges (or all edge ids belonging to a
+ specified graph). The command "id" requires a from icon id,
+ and a to icon id as additional parameters, and returns the
+ corresponding edge id.
+ .TP
  \fIpathName \fBfind \fIsearchCommand \fR?\fIarg arg ...\fR?
  This command returns a list consisting of all the items that
  meet the constraints specified by \fIsearchCommand\fR and
***************
*** 532,537 ****
--- 544,558 ----
  If \fItagOrId\fR doesn't refer to any items, or if the item
  contains no tags, then an empty string is returned.
  .TP
+ \fIpathName \fBiconinfo command \fR?\fIoptions\fR?
+ .VS
+ This command implements a fast access to certain icon
+ specific informations. The command "ids" returns all
+ existing icon ids, and the command "names" returns the names
+ of all existing icons. The command "id" requires an icon name
+ as an additional option. The return value is the
+ corresponding id of that icon.
+ .TP
  \fIpathName \fBicursor \fItagOrId index\fR
  .VS
  Set the position of the insertion cursor for the item(s)
***************
*** 588,593 ****
--- 609,682 ----
  see the sections describing individual item types below for details
  on the legal options.
  .TP
+ \fIpathName \fBlayout command \fR?\fIoptions\fR?
+ .VS
+ This command implements certain layout mechanisms used by
+ the icon and edge icon items. The parameter \fIcommand\fR
+ specifies what should be layouted.
+ .DS
+ .IP \fIedges\fR
+ rearranges the edges in the graph.
+ .IP \fIisi\fR
+ layouts a tree graph with the ISI algorithm. Possible options
+ are: -edgeheight (to specify the height of all edges),
+ -edgewidth (to specify the width of all edges), -graphname
+ (to select a certain graph to layout), -iconspaceh (the
+ additional horizontal offset between the icons), -iconspacev
+ (the additional vertical offset between the icons), -order
+ (1 means layout from the top down, 0 means order left to
+ right), -maxx (giving the maximum x position for randomly
+ placed icons), -maxy (giving the maximum y position for
+ randomly placed icons), -keeprandompositions (0 means that
+ icons are only placed randomly, when their current position
+ is invalid. An invalid posision is the coordinate -1, -1),
+ -rootid (to select a specific root icon), -xoffset (to
+ specify an x offset for the placed graph), and -yoffset (to
+ specify a y offset for the placed graph).
+ .IP \fIitem\fR
+ rearranges one specific item (specified with the option
+ -idlist).
+ .IP \fImatrix\fR
+ arranges all icon items in a simple matrix. This command
+ accepts the following options: -elementsperline (the number
+ of elements per line), -iconheight (the default icon
+ height), -iconwidth (the default icon width), -iconspaceh
+ (the horizontal space between the icons), -iconspacev (the
+ vertical space between the icons), -layouttypes (a list of
+ canvas item types to layout. Line and polygon are not
+ allowed), -computeiconsize (calculate and set the maximum
+ iconsize for all icons), -sortcommand (the sortcommand). The
+ sortcommand gets the pathname of the canvas and the list of
+ all icon item ids. It has to return the newly sorted list of
+ icon ids.
+ .IP \fIrandom\fR 
+ assigns random positions to all icons. Possible options are:
+ -maxx (giving the maximum x position), -maxy (giving the
+ maximum y position), -layouttypes (a list of canvas item
+ types to layout. Line and polygon are not allowed), -idlist
+ (to pass a list of ids to layout) and -keeprandompositions
+ (0 means that icons are only placed randomly, when their
+ current position is invalid. An invalid posision is the
+ coordinate -1, -1).
+ .IP \fItree\fR
+ layouts a tree graph in the form of a tree. Possible options
+ are: -edgeheight (to specify the height of all edges),
+ -edgewidth (to specify the width of all edges), -graphname
+ (to select a certain graph to layout), -iconspaceh (the
+ additional horizontal offset between the icons), -iconspace
+ (the additional vertical offset between the icons), -order
+ (1 means layout from the top down, 0 means order left to
+ right), -maxx (giving the maximum x position for randomly
+ placed icons), -maxy (giving the maximum y position for
+ randomly placed icons), -keeprandompositions (0 means that
+ icons are only placed randomly, when their current position
+ is invalid. An invalid posision is the coordinate -1, -1),
+ -rootid (to select a specific root icon), -xoffset (to
+ specify an x offset for the placed graph), and -yoffset (to
+ specify a y offset for the placed graph).
+ .DE
+ .VE
+ .TP
  \fIpathName \fBlower \fItagOrId \fR?\fIbelowThis\fR?
  Move all of the items given by \fItagOrId\fR to a new position
  in the display list just before the item given by \fIbelowThis\fR.
***************
*** 1442,1447 ****
--- 1531,1745 ----
  The window specified by \fIpathName\fR must either be a child of
  the canvas widget or a child of some ancestor of the canvas widget.
  \fIPathName\fR may not refer to a top-level window.
+ .VE
+ 
+ .SH "EDGE ITEMS"
+ .PP
+ .VS
+ Items of type \fBedge\fR appear on the display as lines with
+ a label in the middle. Edges are created with widget
+ commands of the following form:
+ .DS
+ \fIpathName \fBcreate edge \fIx1 y1... xn yn \fR?\fIoption value option value ...\fR?
+ .DE
+ The arguments \fIx1\fR through \fIyn\fR give
+ the coordinates for a series of two or more points that describe
+ a series of connected line segments.
+ After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
+ pairs, each of which sets one of the configuration options
+ for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
+ used in \fBitemconfigure\fR widget commands to change the item's
+ configuration. The standard Line options are supported.
+ Additionally the following options are supported for edges:
+ .TP
+ \fB\-background \fIcolor\fR
+ Draw the background of the label with \fIcolor\fR, which may be
+ specified in any of the forms accepted by \fBTk_GetColor\fR.
+ .TP
+ \fB\-font \fIfontName\fR
+ Specifies the font to be used for the label.
+ \fIFontName\fR may be any string acceptable to \fBTk_GetFontStruct\fR.
+ If this option isn't specified, it defaults to a system-dependent
+ font.
+ .TP
+ \fB\-from \fIiconId\fR
+ Specifies the icon id where the edge starts.
+ .TP
+ \fB\-graphname \fIname\fR
+ Specifies the name of the graph that contains this edge. An
+ edge can only be member of one graph at the same time.
+ .TP
+ \fB\-label \fItext\fR
+ Specifies the text to be displayed in the label.
+ .TP
+ \fB\-menu1 \fImenuName\fR
+ Specifies the name of a menu that should be attached to the
+ edge (usually mouse button 3).
+ .TP
+ \fB\-menu2 \fImenuName\fR
+ Specifies the name of a menu that should be attached to the
+ edge (usually meta mouse button 3).
+ .TP
+ \fB\-menu3 \fImenuName\fR
+ Specifies the name of a menu that should be attached to the
+ edge (usually control mouse button 3).
+ .TP
+ \fB\-name \fIedgeName\fR
+ Specifies the name of the edge.
+ .TP
+ \fB\-state \fIstate\fR
+ Specifies the state of the edge. Possible values are
+ \fIselected\fR and \fInormal\fR.
+ .TP
+ \fB\-to \fIiconId\fR
+ Specifies the icon id where the edge ends.
+ .VE
+ 
+ .SH "ICON ITEMS"
+ .PP
+ .VS
+ Items of the type \fBicon\fR appear on the display as labels
+ with optional images. Icons are created with widget commands
+ of the following form:
+ .DS
+ \fIpathName \fBcreate icon \fIx y \fR?\fIoption value option value ...\fR?
+ .DE
+ The arguments \fIx\fR and \fIy\fR specify the coordinates of a
+ point used to position the icon on the display. After the
+ coordinates there may be any number of \fIoption\fR-\fIvalue\fR 
+ pairs, each of which sets one of the configuration options
+ for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
+ used in \fBitemconfigure\fR widget commands to change the item's
+ configuration.
+ The following options are supported for icons:
+ .TP
+ \fB\-background \fIcolor\fR
+ Specifies a color to be used to display the background of the
+ label and the bitmap.
+ \fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
+ If this option isn't specified, or if it is specified as an empty
+ string, then the background color for the canvas is used.
+ .TP
+ \fB\-bitmap \fIbitmap\fR
+ Specifies the bitmap to be displayed in the item.
+ \fIBitmap\fR may have any of the forms accepted by
+ \fBTk_GetBitmap\fR.
+ .TP
+ \fB\-borderwidth \fIwidth\fR
+ Specifies the borderwidth of the border. The default value
+ is 1.0. 
+ .TP
+ \fB\-command \fIscript\fR
+ Specifies the command that is bound to the icon. Typically,
+ this command is called when the user double clicks the icon
+ with mouse button 1.
+ .TP
+ \fB\-dropcommand \fIscript\fR
+ If the wish supports drag&drop, this command is called
+ when a tkiconpane icon is dropped into an icon pane on this
+ icon. This command receives four parameters. The first
+ parameter is the icon pane widget path where the icon comes
+ from. The second parameter specifies the source icon id
+ (canvas id) in this icon pane. The third parameter is the
+ name of the icon pane widget where the icon has been
+ dropped. The last parameter is the target icon id (canvas
+ id) where the icon has been dropped (the icon that has this
+ dropcommand attached).
+ .TP
+ \fB\-edges \fIedgeList\fR
+ Specifies the list of all edges bound to this icon. The list
+ contains a list containing the fromNodeId, the toNodeId and
+ the edgeId.
+ .TP
+ \fB\-font \fIfontName\fR
+ Specifies the font to be used for the label.
+ \fIFontName\fR may be any string acceptable to
+ \fBTk_GetFontStruct\fR. If this option isn't specified, it
+ defaults to a system-dependent font.
+ .TP
+ \fB\-foreground \fIcolor\fR
+ Specifies a color to be used to display the foreground of
+ the label and the bitmap.
+ \fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR and
+ defaults to \fBblack\fR.
+ .TP
+ \fB\-layoutinfo \fBstring\fR
+ This option can be used to attach additional layout
+ information to the icon.
+ .TP
+ \fB\-mask \fImask\fR
+ Specifies the bitmap to be used as the mask for the
+ \fB-bitmap\fR option.
+ .TP
+ \fB\-menu1 \fImenuName\fR
+ Specifies the name of a menu that should be attached to the
+ icon (usually mouse button 3).
+ .TP
+ \fB\-menu2 \fImenuName\fR
+ Specifies the name of a menu that should be attached to the
+ icon (usually meta mouse button 3).
+ .TP
+ \fB\-menu3 \fImenuName\fR
+ Specifies the name of a menu that should be attached to the
+ icon (usually control mouse button 3).
+ .TP
+ \fB\-name \fIiconName\fR
+ Specifies the name of the icon.
+ .TP
+ \fB\-outline \fIcolor\fR
+ Specifies a color to be used to display the border of the
+ icon. \fIColor\fR may have any of the forms accepted by
+ \fBTk_GetColor\fR and defaults to \fBblack\fR.
+ .TP
+ \fB\-relief \fIrelief\fR
+ Specifies the relief to be used. The usual values are
+ accepted.
+ .TP
+ \fB\-sortstring \fIstring\fR
+ Specifies the string that should be used to sort the icons.
+ .TP
+ \fB\-status \fIstring\fR
+ Specifies the status of the icon. This information is used
+ to automatically retrieve the status dependant bitmap. Look
+ into the documentation for tkiconpane(n) to see the usual
+ way to deal with this. The new bitmap is only loaded when
+ the status has been changed. This makes it possible to
+ change the status bitmap by hand with the -statusbitmap
+ option.
+ .TP
+ \fB\-statusbitmap \fIbitmap\fR
+ Specifies the bitmap to be displayed in the item to
+ represent a certain status. \fIBitmap\fR may have any of the
+ forms accepted by \fBTk_GetBitmap\fR. The status bitmap is
+ overlayed above the standard icon bitmap.
+ .TP
+ \fB\-statusmask \fImask\fR
+ Specifies the bitmap to be used as the mask for the
+ \fB-statusbitmap\fR option.
+ .TP
+ \fB\-text \fItext\fR
+ Specifies the text to be displayed in the icon.
+ .TP
+ \fB\-textanchor \fIanchorPos\fR
+ \fIAnchorPos\fR tells how to position the text relative to
+ the bitmap;  it may have any of the forms accepted by
+ \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR is
+ \fBs\fR, then the text is displayed centered below the
+ bitmap. This option defaults to \fBs\fR.
+ .TP
+ \fB\-type \fItype\fR
+ Specifies the type of the icon. This information is used to
+ retrieve the icon specific menus, bitmaps etc. Look
+ into the documentation for tkiconpane(n) to see the usual
+ way to deal with this. The new bitmap is only loaded when
+ the type has been changed. This makes it possible to
+ change the type bitmap by hand with the -bitmap option.
+ .TP
+ \fB\-x \fIposition\fR
+ Specifies the x position of the icon.
+ .TP
+ \fB\-y \fIposition\fR
+ Specifies the y position of the icon.
  .VE
  
  .SH "APPLICATION-DEFINED ITEM TYPES"
