global auto_path
lappend auto_path .
lappend auto_path ../library
source ../library/tkIconPaneCmd.tcl

wm maxsize . 1000 1000
wm geometry . 400x400

foreach fileName [glob -nocomplain *.lay] {
  source $fileName
}

menu .layouterMenu

foreach layouter [lsort [info commands LAYOUT_*]] {
  .layouterMenu add radiobutton \
    -command "
      .layouter config -layoutcommand $layouter
      .layouter layout
    " \
    -label [string range $layouter 7 end] \
    -variable layouter
}

set layouter matrix
set nodeCounter 0
set edgeCounter 0
set graphorder 0
set edgeorder 0
tkiconpane .layouter -toplevel 0 \
  -edgemenupath {../library/menus} \
  -iconmenupath {../library/menus} \
  -iconpixmappath {../library/icons} \
  -iconstatuspath {../library/status} \
  -menu1 layouter \
  -menu2 .layouterMenu \
  -menubar layouter \
  -menupath {../library/viewMenus} \
  -layout 0 \
  -name layouter

pack append . .layouter {top fill expand}

if {$argc > 0} {
  if {[file exists $argv]} {
    source [lindex $argv 0]
    .layouter config -layoutcommand LAYOUT_$layouter
    .layouter layout
  }
}

proc SaveIcons {pathName} {
  global nodeCounter
  global edgeCounter
  global layouter

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set fd [open layout.info w]

  puts $fd "global nodeCounter"
  puts $fd "global edgeCounter"
  puts $fd "global layouter"
  puts $fd "set nodeCounter [set nodeCounter]"
  puts $fd "set edgeCounter [set edgeCounter]"
  puts $fd "set layouter [set layouter]\n"

  foreach element [$pathName iconinfo ids] {
    puts $fd "$pathName iconcreate [lindex [$canvasPath itemconfig $element -name] 4] -menu1 layouter -status none -text [lindex [$canvasPath itemconfig $element -name] 4] -name [lindex [$canvasPath itemconfig $element -name] 4] -type standard"
  }
  foreach element [$pathName edgeinfo ids mygraph] {
    puts $fd "$pathName edgecreate mygraph \[list \[.layouter iconinfo id [lindex [$pathName edgeinfo fromtoname mygraph $element] 0]\] \[.layouter iconinfo id [lindex [$pathName edgeinfo fromtoname mygraph $element] 1]\] 1 -menu1 layouter -label [lindex [$canvasPath itemconfig $element -name] 4] -name [lindex [$canvasPath itemconfig $element -name] 4]\]"
  }

  close $fd
}

