'\"
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for TIX man pages
.de HS
.if '\\$2'tix'        .TH \\$1 n \\$3 \\TIX
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
'
'
'----------------------------------------------------------------------
.HS tixSListbox tix 3.6
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixScrolledListbox - Create and manipulate TIX \fBScrolledListbox\fR widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixScrolledListbox\fI \fIpathName ?\fIoptions\fR?
'
'
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fB
'
anchor	background	cursor
relief	borderWidth	geometry
'
\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"

'----------BEGIN

.LP
.nf
Name:		\fBanchor\fR
Class:		\fBAnchor\fR
Command-Line Switch:	\fB\-anchor\fR
.fi
.IP
Specifies the alignment of the items inside the listbox subwidget.
Only the values "w" and "e" are allowed. When set to "w", the listbox
is automatically aligned to the beginning of the items. When set to
"e", the listbox is automatically aligned to the end of the items.  
Automatically alignment only happens when the \fBScrolledListbox\fR
changes its size.
'----------END

'----------BEGIN
.LP
.nf
Name:		\fBfont\fR
Class:		\fBFont\fR
Command-Line Switch:	\fB\-font\fR
.fi
.IP
Specifies the font used the listbox subwidget
inside the \fBScrolledListbox\fR widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBforeground\fR
Class:		\fBForeground\fR
Command-Line Switch:	\fB\-foreground\fR
.fi
.IP
Specifies the foreground color of the listbox subwdget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBgeometry\fR
Class:		\fBGeometry\fR
Command-Line Switch:	\fB\-geometry\fR
Alias:		\fB-geom\fR
.fi
.IP
Specifies the geometry of the listbox subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlistboxBg\fR
Class:		\fBBackground\fR
Command-Line Switch:	\fB\-listboxbg\fR
.fi
.IP
Specifies the background color of the listbox subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBscrollbar\fR
Class:		\fBScrollbar\fR
Command-Line Switch:	\fB-scrollbar\fR
.fi
.IP
Specifies the display policy of the scrollbars. Only the following
four values are recognized: \fB"x"\fR: only the horizontal scrollbar
is shown. \fB"y"\fR: only the vertical scrollbar is shown.
\fB"both"\fR: both scrollbars are shown.  \fB"auto"\fR: The scrollbars
are shown when needed.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBscrollbarBg\fR
Class:		\fBScrollbarBg\fR
Command-Line Switch:	\fB-scrollbarbg\fR
.fi
.IP
Specifies the background color of the scrollbar subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBscrollbarFg\fR
Class:		\fBScrollbarFg\fR
Command-Line Switch:	\fB-scrollbarfg\fR
.fi
.IP
Specifies the foreground color of the scrollbar subwidget.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBscrollbarWidth\fR
Class:		\fBScrollbarWidth\fR
Command-Line Switch:	\fB-scrollbarwidth\fR
Alias:		\fB-scbwidth\fR (Obsolete!)
.fi
.IP
Specifies the width of the scrollbar subwidget.
'----------END
'
.VE
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixScrolledListbox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a \fBScrolledListbox\fR widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
\fBScrolledListbox\fR such as its cursor and relief.

The \fBScrolledListbox\fR widget is a "convenience widget". It
combinds two scrollbar widgets with the listbox widget and sets their
behavior and appearance accordingly.
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBScrolledListbox\fR command creates a new Tcl command whose
name is the same as the path name of the \fBScrolledListbox\fR's window.  This
command may be used to invoke various
operations on the widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?

.DE
'
\fIPathName\fR is the name of the command, which is the same as
the frame widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for \fBScrolledListbox\fR widgets:
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBframe\fR
command.
'
.TP
\fIpathName \fBlistbox \fI?options?\fR 
When no additional options are supplied, returns the pathname of the
listbox subwidget.

When additional options are supplied, invokes the widget command of
the listbox subwidget with these options.

The \fBlistbox\fR widget command provides a quick way to access the
listbox subwidget. For example, you can use it to add items or delete
items from the listbox subwidget. However, please don't abuse this
command and change the behavior of listbox subwidget arbitrarily.
'
'----------------------------------------------------------------------
.SH BINDINGS
.PP
\fBScrolledListbox\fR widgets have no default bindings.
'
'
'
'----------------------------------------------------------------------
.SH AUTHOR
.PP
Ioi Kim Lam - ioi@graphics.cis.upenn.edu
'
'----------------------------------------------------------------------
.SH KEYWORDS
TIX
