proc MkMiscDialog {} {
    set w .misc
    global misc

    if {[winfo exists $w] != 0} {
	return
    }
    set misc 1
    toplevel $w
    wm title $w "Miscellaneous Compound Widgets"
    wm geometry $w 450x300
    frame $w.top -relief raised -bd 1
    frame $w.top.left
    set lbfm [tixLabelFrame $w.top.left.lbfm -label "Compound Widgets"]

    radiobutton $lbfm.1 -text "Control" \
	-variable misc \
	-relief flat \
	-command "MkMiscControl $w.top.right"
    radiobutton $lbfm.2 -text "LabelFrame" \
	-variable misc \
	-relief flat \
	-command "MkMiscLabelFrame $w.top.right"
    radiobutton $lbfm.3 -text "Scrolled List Box" \
	-variable misc \
	-relief flat \
	-command "MkMiscSListbox $w.top.right"
    radiobutton $lbfm.4 -text "Select" \
	-variable misc \
	-relief flat \
	-command "MkMiscSelect $w.top.right"

    frame $w.top.right -relief sunken -bd 1
    MkMiscControl $w.top.right

    pack $lbfm.1 $lbfm.2 $lbfm.3 $lbfm.4 -side top -fill x
    pack $w.top.left.lbfm  -expand yes -fill both
    pack $w.top.left  -side left -padx 20 -pady 10 -expand no -fill both
    pack $w.top.right -side right -padx 20 -pady 13 -expand yes -fill both

    pack $w.top -expand yes -fill both

    tixDlgBtns $w.btns
    $w.btns add close -text "Close" -width 6 -command "destroy $w"
    pack $w.btns -fill x
}

proc MkMiscControl {w} {
    destroy $w
    frame $w -relief sunken -bd 1
    pack $w -side right -padx 20 -pady 13 -expand yes -fill both

    tixControl $w.ctl1 -entrywidth 12 -value 0.0 -step 3.1415926 \
	-ulimit 100.0 -llimit 0.0
    tixControl $w.ctl2 -entrywidth 12 

    pack $w.ctl1 -side top -expand yes -fill none -padx 10 -pady 10 
    pack $w.ctl2 -side top -expand yes -fill none -padx 10 -pady 10
}

proc MkMiscLabelFrame {w} {
    destroy $w
    frame $w -relief sunken -bd 1
    pack $w -side right -padx 20 -pady 13 -expand yes -fill both

    set lbfm [tixLabelFrame $w.lbfm -label "LabelFrame"]
    label $lbfm.label -text "This is in a LabelFrame"
    pack $lbfm.label -side top -expand yes -fill both
    pack $w.lbfm -side top -expand yes -fill both -padx 10 -pady 10
}

proc MkMiscSListbox {w} {
    destroy $w
    frame $w -relief sunken -bd 1
    pack $w -side right -padx 20 -pady 13 -expand yes -fill both

    tixScrolledListbox $w.scb -geom 10x6
    $w.scb listbox insert end Janurary
    $w.scb listbox insert end Feburary
    $w.scb listbox insert end March
    $w.scb listbox insert end April
    $w.scb listbox insert end May
    $w.scb listbox insert end June
    $w.scb listbox insert end July
    $w.scb listbox insert end August
    $w.scb listbox insert end September
    $w.scb listbox insert end October
    $w.scb listbox insert end November
    $w.scb listbox insert end December

    pack $w.scb  -side top -expand yes -fill both -padx 10 -pady 10
}

proc MkMiscSelect {w} {
    destroy $w
    frame $w -relief sunken -bd 1
    pack $w -side right -padx 20 -pady 13 -expand yes -fill both

    tixSelect $w.sel
    $w.sel add eat   -text Eat   -width 6
    $w.sel add work  -text Work  -width 6
    $w.sel add sleep -text Sleep -width 6
    $w.sel config -value {work}

    pack $w.sel  -side top -expand yes -fill none -padx 10 -pady 10
}
