proc MkComboDialog {} {
    set w .combo
    if {[winfo exists $w] != 0} {
	return
    }
    toplevel $w
    wm title $w "Combobox Demonstration"
    frame $w.top -border 1 -relief raised
    # The message
    #------------
    message $w.top.msg -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*\
	-relief flat -width 480 -anchor n\
	-text {
There are three types of Comboboxes.

Static Combobox
	Acts much the same way as a menu. It provides the user with a fixed\
set of choices.

Editable Combobox
	The user can <1> select from a set of pre-defined options\
in the listbox, or <2> enter an alternative selection into the entry.

History Combobox
	It is an editable combobox that records the user's recent \
selections into the listbox.}
    pack $w.top.msg -fill both -padx 10

    set labfm [tixLabelFrame $w.top.labfm1 -label " Static Combobox "]
    tixCombobox $labfm.cbx -type static -command ComboCommand -width 30 \
	-height 6 -fancy yes
    $labfm.cbx appendhistory Janurary
    $labfm.cbx appendhistory Feburary
    $labfm.cbx appendhistory March
    $labfm.cbx appendhistory April
    $labfm.cbx appendhistory May
    $labfm.cbx appendhistory June
    $labfm.cbx appendhistory July
    $labfm.cbx appendhistory August
    $labfm.cbx appendhistory September
    $labfm.cbx appendhistory October
    $labfm.cbx appendhistory November
    $labfm.cbx appendhistory December
    
    pack $labfm.cbx -fill both -expand yes
    pack $w.top.labfm1 -fill x -padx 130 -pady 5
   
    # Editable, you can type the selection in the entry
    #--------------------------------------------------
    set labfm [tixLabelFrame $w.top.labfm2 -label " Editable Combobox "]
    tixCombobox $labfm.cbx -type editable -command ComboCommand \
	-height 4 -fancy yes
    $labfm.cbx appendhistory "America"
    $labfm.cbx appendhistory "Britain"
    $labfm.cbx appendhistory "China"
    $labfm.cbx appendhistory "Denmark"
    $labfm.cbx appendhistory "Egypt"
    
    pack $labfm.cbx -fill both -expand yes
    pack $w.top.labfm2 -fill x -padx 130 -pady 5
   
    # History, your input in the entry is recorded and can be recalled
    #-----------------------------------------------------------------
    set labfm [tixLabelFrame $w.top.labfm3 -label " History Combobox "]
    tixCombobox $labfm.cbx -type history -command ComboCommand \
	-height 5 -fancy yes
    $labfm.cbx appendhistory "/usr/bin/mail"
    $labfm.cbx appendhistory "/etc/profile"
    $labfm.cbx appendhistory "/home/d/doe/Mail/letter"
    
    pack $labfm.cbx -fill both -expand yes
    pack $w.top.labfm3 -fill x -padx 130 -pady 5
  
    # The Buttons
    #-------------
    tixDlgBtns $w.btns
    $w.btns add close -text "Close" -command  "destroy $w"
    
    pack $w.top -expand yes -fill both 
    pack $w.btns -fill x

}

proc ComboCommand {string} {
    global tix_hide

    if [info exists tix_hide] {
	return
    }
    set w .combo2

    if [winfo exists $w] {
	destroy $w
    }
    toplevel $w
    wm title $w "Acknowledge"

    frame $w.top -relief raised -border 1
    message $w.top.msg -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-* \
	-relief sunken -bd 1 -anchor n -padx 40 -width 400\
	-text "You have selected 

\"$string\""

    tixDlgBtns $w.btns
    $w.btns add close -text "Close"   -width 7
    $w.btns add hide -text "Don't show this message" \
	-command "set tix_hide 1; destroy $w"

    pack $w.top.msg -expand yes -fill both -padx 10 -pady 10
    pack $w.top -expand yes -fill both 
    pack $w.btns -fill x

    $w.btns button close config -command "destroy $w"

    update
}
