/* ----------------------------- -*- Mode: C -*- -----------------------------
 * libpqcmds.h - Tcl extensions for Postgres.
 * 
 * %W%
 * 
 * Written by
 * Robin J. Maxwell
 * Open Systems Solutions, Inc
 * Collaboration Software Group.
 * 
 * Copyright (c) 1992 Open Systems Solutions, Inc
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  
 * Open Systems Solutions, Inc. and Robin J. Maxwell make no representations
 * about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * Author          : Robin J. Maxwell
 * Created On      : Wed Jul 29 14:39:54 1992
 * Last Modified By: Robin J. Maxwell
 * Last Modified On: Wed Oct 28 15:30:34 1992
 * Update Count    : 5
 * Status          : Unknown, Use with caution!
 */


#ifndef _LIBPQCMDS_H
#define _LIBPQCMDS_H

#include "tclExtend.h"
#include "libpq-fe.h"

typedef PortalBuffer **PBuffer_pt;

typedef struct libpqGlob{
    int useCount;               /* Commands that currently share globals */
    void *tblHdrPtr;            /* PortalBuffer handle table */
    char *dbname;               /* Storage for current db name */
}libpqGlob_t, *libpqGlob_pt;

  /*
   * Function prototypes.
   */
    extern int Tcl_PQsetdbCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
				       char **));
    extern int Tcl_PQdbCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					char **));
    extern int Tcl_PQresetCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					   char **));
    extern int Tcl_PQFinishCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					    char **));
    extern int Tcl_PQexecCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					  char **));
    extern int Tcl_PQnportalsCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					      char **));
    extern int Tcl_PQnamesCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					   char **));
    extern int Tcl_PQparrayCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					    char **));
    extern int Tcl_PQclearCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					   char **));
    extern int Tcl_PQrulepCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					   char **));
    extern int Tcl_PQntuplesCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					     char **));
    extern int Tcl_PQngroupsCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					     char **));
    extern int Tcl_PQntuplesGroupCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, 
						  int, char **));
    extern int Tcl_PQnfieldsGroupCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, 
						  int, char **));
    extern int Tcl_PQfnameGroupCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
						char **));
    extern int Tcl_PQfnumberGroupCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,
						  int, char **));
    extern int Tcl_PQgetgroupCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					      char **));
    extern int Tcl_PQnfieldsCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					     char **));
    extern int Tcl_PQfnumberCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					     char **));
    extern int Tcl_PQfnameCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					   char **));
    extern int Tcl_PQftypeCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					   char **));
    extern int Tcl_PQsametypeCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					      char **));
    extern int Tcl_PQgetvalueCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					      char **));
    extern int Tcl_PQtraceCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
					   char **));
    extern int Tcl_PQuntraceCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int,

					     char **));
    extern void Tcl_PQlibinit _ANSI_ARGS_((Tcl_Interp *));
    static void libPQCleanUp _ANSI_ARGS_((ClientData));

#endif /* _LIBPQCMDS_H */
