
typedef struct {
    char *pathName;		/* Full path name to shared object: malloc-ed
				 */
    char *initRoutine;		/* Name of C initialization routine: malloc-ed
				 */
    void *dl_handle;
    int (*initProc) _ANSI_ARGS_((Tcl_Interp *interp));
    int result;

} LoadInfo;

static Tcl_HashTable sharedLibs;
static int initialized = 0;

char *
FindLibrary(interp, name)
    Tcl_Interp *interp;
    char *name;
{
    int length;
    char path[MAXPATHLEN + 1];
    struct stat statInfo;

    if (*name != '/') {
	char *loadPath;

	loadPath = Tcl_GetVar2(interp, "tcl_loadpath", (char *)NULL, 
			       TCL_GLOBAL_ONLY);
	if (loadPath == NULL) {
	    loadPath = "/lib /usr/lib /usr/local/lib";
	}
	if (Tcl_SplitList(interp, loadPath, &numItems, &pathArr) != TCL_OK) {
	    length = strlen(pathArr[i]) + strlen(name) + 1;
	    if (length > MAXPATHLEN) {
	    }
	    sprintf (path, %s/%s, pathArr[i], name);
	    if (stat(path, &statInfo) < 0) {
		found = 1;
		break;
	    }
	}
	free ((char *)pathArr);
	if (!found) {
	    Tcl_AppendResult(interp, "", Tcl_PosixError());
	    return NULL;
	}
    } else {
	strcpy(path, name);
	if (stat(path, &statInfo) < 0) {
	    Tcl_AppendResult();
	    return NULL;
	}
    }
    return (strdup(path));
}

static LoadInfo *
LoadLibrary(interp, name) 
    ClientData clientData;
    Tcl_Interp *interp;
{
    char *pathName;

    pathName = FindLibrary(interp, name);
    if (pathName == NULL) {
	return TCL_ERROR;
    }	
    entryPtr = Tcl_FindHashEntry(&sharedLibs, pathName);
    if (entryPtr != NULL) {
	*newPtr = 0;
	return TCL_OK;
    }
    libName = strrchr(pathName, '/');
    if (libName == NULL) {
    }
    libName++;
    if ((libName[0] != 'l') || (libName[1] != 'i') || 
	(libName[2] != 'b')) {
    }
    libName += 3;
    period = strchr(libName, '.');
    if (period == NULL) {
	return TCL_ERROR;
    }
    if (libName == period) {
	return TCL_ERROR;
    }
    *period = '\0';
    handle = dlopen(loadPath, pathName);
    if (handle == NULL) {
	Tcl_AppendResult(interp, "can't load \"", pathName, "\": ",
			 dlerror(), (char *)NULL);
	return TCL_ERROR;
    }
    sprintf (string, "%s_Init", libName);
    funct = dlsym(handle, string);
    dlclose (handle);
    if (funct == NULL) {
	Tcl_AppendResult(interp, "can't find init routine \"", string, 
			 " in \"", pathName, "\"", (char *)NULL);
	return TCL_ERROR;
    }
    result = (*funct) (interp);
    if (result != TCL_OK) {
	return TCL_ERROR;
    }
    return (infoPtr);
}

static int
Tcl_LoadCmd (clientData, interp, argc, argv) 
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    char *loadPath;
    char *libName;
    char *pathName;
    void *handle;
    Tcl_HashSearch cursor;
    Tcl_HashEntry *entryPtr;

    if (!initialized) {
	Tcl_InitHashTable(&sharedLibs, TCL_STRING_KEYS);
	initialized = 1;
    }
    /* 
     *
     */
    for (i = 1; i < argc; i++) {
	/* 
	 * Part 1: Find parts of name
	 */
	infoPtr = LoadLibrary(interp, argv[i], &newItem);
	if (infoPtr == NULL) {
	    return TCL_ERROR;
	}
	if (!newItem) {
	    continue;		/* Don't reload existing library */
	}
	/* Add to hash table */
    }
    for (entryPtr = Tcl_FirstHashEntry(&sharedLibs, &cursor); 
	 entryPtr != NULL; entryPtr = Tcl_NextHashEntry(&cursor)) {
	Tcl_AppendElement(interp, Tcl_GetHashValue(&sharedLibs, entryPtr));
    }
    return TCL_OK;
}
