# Program: xf
# Description: the option dialog for general options
#
# $Header: xfoptVersion.tcl[2.3] Wed Mar 10 12:07:24 1993 garfield@garfield frozen $

##########
# Procedure: XFOptionsVersion
# Description: allow the editing of the version control options
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFOptionsVersion {} {
  global xfConf
  global xfMisc
  global xfVersion

  set xfMisc(versionCommand) $xfConf(versionCommand)

  # build widget structure
  XFTmpltToplevel .xfOptionsVersion 400x280 {XF version control options}

  XFTmpltFrame .xfOptionsVersion.frame1 0

  button .xfOptionsVersion.frame1.ok \
    -text {OK} \
    -command {
      XFOptionsVersionSet
      destroy .xfOptionsVersion}

  button .xfOptionsVersion.frame1.save \
    -text {Save + OK} \
    -command {
      XFOptionsVersionSet
      XFProcOptionsSaveOptions
      destroy .xfOptionsVersion}

  button .xfOptionsVersion.frame1.cancel \
    -text {Cancel} \
    -command {destroy .xfOptionsVersion}

  XFTmpltFrame .xfOptionsVersion.frame2 0

  checkbutton .xfOptionsVersion.frame2.version \
    -text {Use version control} \
    -variable xfMisc(versionCommand)

  XFTmpltFrame .xfOptionsVersion.frame3 0

  XFTmpltFrame .xfOptionsVersion.frame3.frame5

  label .xfOptionsVersion.frame3.frame5.message2 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {List:}

  label .xfOptionsVersion.frame3.frame5.message3 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {List (long):}

  label .xfOptionsVersion.frame3.frame5.message4 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {List default (long):}

  label .xfOptionsVersion.frame3.frame5.message5 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Retrieve:}

  label .xfOptionsVersion.frame3.frame5.message6 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Retrieve default:}

  label .xfOptionsVersion.frame3.frame5.message7 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Remove:}

  label .xfOptionsVersion.frame3.frame5.message8 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Save:}

  label .xfOptionsVersion.frame3.frame5.message9 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Save with comment:}

  label .xfOptionsVersion.frame3.frame5.message10 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Show:}

  label .xfOptionsVersion.frame3.frame5.message11 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Show default:}

  label .xfOptionsVersion.frame3.frame5.message12 \
    -anchor e \
    -padx 0 \
    -pady 0 \
    -text {Test:}

  XFTmpltFrame .xfOptionsVersion.frame3.frame6

  entry .xfOptionsVersion.frame3.frame6.list \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.list insert 0 $xfVersion(list)

  entry .xfOptionsVersion.frame3.frame6.listlong \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.listlong insert 0 $xfVersion(listLong)

  entry .xfOptionsVersion.frame3.frame6.listlongdef \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.listlongdef insert 0 \
    $xfVersion(listLongDefault)

  entry .xfOptionsVersion.frame3.frame6.retrv \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.retrv insert 0 $xfVersion(retrv)

  entry .xfOptionsVersion.frame3.frame6.retrvdef \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.retrvdef insert 0 $xfVersion(retrvDefault)

  entry .xfOptionsVersion.frame3.frame6.rm \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.rm insert 0 $xfVersion(rm)

  entry .xfOptionsVersion.frame3.frame6.save \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.save insert 0 $xfVersion(save)

  entry .xfOptionsVersion.frame3.frame6.savemess \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.savemess insert 0 $xfVersion(saveMessage)

  entry .xfOptionsVersion.frame3.frame6.show \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.show insert 0 $xfVersion(show)

  entry .xfOptionsVersion.frame3.frame6.showdef \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.showdef insert 0 $xfVersion(showDefault)

  entry .xfOptionsVersion.frame3.frame6.test \
    -relief sunken
  .xfOptionsVersion.frame3.frame6.test insert 0 $xfVersion(test)

  # packing
  pack append .xfOptionsVersion.frame1 \
              .xfOptionsVersion.frame1.ok {left fill expand} \
              .xfOptionsVersion.frame1.save {left fill expand} \
              .xfOptionsVersion.frame1.cancel {left fill expand}
  pack append .xfOptionsVersion.frame2 \
              .xfOptionsVersion.frame2.version {left fill expand}
  pack append .xfOptionsVersion.frame3.frame5 \
              .xfOptionsVersion.frame3.frame5.message2 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message3 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message4 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message5 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message6 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message7 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message8 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message9 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message10 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message11 {top fillx} \
              .xfOptionsVersion.frame3.frame5.message12 {top fillx}
  pack append .xfOptionsVersion.frame3.frame6 \
              .xfOptionsVersion.frame3.frame6.list {top fillx} \
              .xfOptionsVersion.frame3.frame6.listlong {top fillx} \
              .xfOptionsVersion.frame3.frame6.listlongdef {top fillx} \
              .xfOptionsVersion.frame3.frame6.retrv {top fillx} \
              .xfOptionsVersion.frame3.frame6.retrvdef {top fillx} \
              .xfOptionsVersion.frame3.frame6.rm {top fillx} \
              .xfOptionsVersion.frame3.frame6.save {top fillx} \
              .xfOptionsVersion.frame3.frame6.savemess {top fillx} \
              .xfOptionsVersion.frame3.frame6.show {top fillx} \
              .xfOptionsVersion.frame3.frame6.showdef {top fillx} \
              .xfOptionsVersion.frame3.frame6.test {top fillx}
  pack append .xfOptionsVersion.frame3 \
              .xfOptionsVersion.frame3.frame5 {left filly} \
              .xfOptionsVersion.frame3.frame6 {left fill expand}
  pack append .xfOptionsVersion \
              .xfOptionsVersion.frame1 {bottom fill} \
              .xfOptionsVersion.frame2 {top fill} \
              .xfOptionsVersion.frame3 {top fill expand}

  XFBindFormConnect .xfOptionsVersion.frame3.frame6
}

##########
# Procedure: XFOptionsVersionSet
# Description: set the new options
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFOptionsVersionSet {} {
  global xfConf
  global xfMisc
  global xfVersion

  set xfConf(versionCommand) $xfMisc(versionCommand)
  set xfVersion(list) [.xfOptionsVersion.frame3.frame6.list get]
  set xfVersion(listLong) [.xfOptionsVersion.frame3.frame6.listlong get]
  set xfVersion(listLongDefault) \
    [.xfOptionsVersion.frame3.frame6.listlongdef get]
  set xfVersion(retrv) [.xfOptionsVersion.frame3.frame6.retrv get]
  set xfVersion(retrvDefault) [.xfOptionsVersion.frame3.frame6.retrvdef get]
  set xfVersion(rm) [.xfOptionsVersion.frame3.frame6.rm get]
  set xfVersion(save) [.xfOptionsVersion.frame3.frame6.save get]
  set xfVersion(saveMessage) [.xfOptionsVersion.frame3.frame6.savemess get]
  set xfVersion(show) [.xfOptionsVersion.frame3.frame6.show get]
  set xfVersion(showDefault) [.xfOptionsVersion.frame3.frame6.showdef get]
  set xfVersion(test) [.xfOptionsVersion.frame3.frame6.test get]

  # test if we can find version control
  if {[catch "$xfVersion(test)" xfResult]} {
    set xfConf(versionCommand) 0
  }
}

# eof

