# Program: xf
# Description: external interface to save facilities
#
# $Header: xfsave.tcl[2.5] Wed Mar 10 12:08:14 1993 garfield@garfield frozen $

auto_load XFSaveBind
auto_load XFSaveSourceAppendix

##########
# Procedure: XFSave
# Description: save current definition
# Arguments: xfFileName - the output file
# Returns: none
# Sideeffects: none
##########
proc XFSave {xfFileName} {
  global xfConf
  global xfMisc
  global xfPath
  global xfStatus

  if {$xfStatus(saving)} {
    return
  }
  set xfStatus(saving) 1
  XFMiscUpdateModuleList
  # clear up the window showing stuff
  XFEditSetShowWindows

  # save current file
  if {[file exists $xfFileName]} {
    catch "exec cp $xfFileName $xfFileName~"
    catch "exec cp $xfFileName $xfPath(tmp)/lc$xfStatus(uniqueId)"
  }
  if {[catch "open $xfFileName w" xfOutFile]} {
    XFProcError "$xfOutFile"
  } {
    XFSaveComment $xfOutFile file [file rootname [file tail $xfFileName]]
    XFSaveSourcePrefix $xfOutFile 1

    # save all visible children of .
    foreach xfCounter [lsort [winfo children .]] {
      if {![string match ".xf*" $xfCounter] &&
          "[winfo class $xfCounter]" == "Toplevel"} {
        XFSaveRootToplevelChild $xfOutFile $xfCounter
        XFSaveSourceDestroyWindow $xfOutFile $xfCounter
        XFSaveShowWindowTail $xfOutFile $xfCounter
      }
    }
    # save all invisible children of .
    foreach xfProcName [lsort [info procs ShowWindow.*]] {
      XFSaveShowWindow $xfOutFile $xfProcName
    }
    # save .
    set xfMisc(menuBarTraversalList) ""
    set xfMisc(specialSaveString) ""
    puts $xfOutFile "\n\n# procedure to show window ."
    puts $xfOutFile "proc ShowWindow. {args} {# xf ignore me 7"
    if {"[info procs StartupSrc.]" != ""} {
      puts $xfOutFile "\nStartupSrc."
    }
    XFSaveWidget $xfOutFile .
    XFSaveBind $xfOutFile .
    XFSaveWidgetSpecial $xfOutFile .
    XFSaveSubwindow $xfOutFile .
    if {"[info procs MiddleSrc.]" != ""} {
      puts $xfOutFile "\nMiddleSrc."
    }
    XFSavePack $xfOutFile .
    XFSavePlace $xfOutFile .
    puts $xfOutFile "\n  if {\"\[info procs XFEdit\]\" != \"\"} {"
    puts $xfOutFile "    XFEditSetShowWindows"
    puts $xfOutFile "    XFMiscBindWidgetTree $xfCounter"
    puts $xfOutFile "  }"
    XFSaveMenubarTraversal $xfOutFile
    if {"$xfMisc(specialSaveString)" != ""} {
      puts $xfOutFile "\n$xfMisc(specialSaveString)\n"
    }
    if {"[info procs EndSrc.]" != ""} {
      puts $xfOutFile "\nEndSrc."
    }
    puts $xfOutFile "}"
    XFSaveShowWindowTail $xfOutFile .

    # save procedures
    XFSaveProcs $xfOutFile

    XFSaveSourceAppendix $xfOutFile 1
    puts $xfOutFile "\n# eof"
    puts $xfOutFile "#"
    puts $xfOutFile ""
    close $xfOutFile
  }
  catch "chmod u+x $xfFileName"
  set xfStatus(saving) 0
}

##########
# Procedure: XFSaveModules
# Description: save current definition splitted in modules
# Arguments: xfFileName - the output file
# Returns: none
# Sideeffects: none
##########
proc XFSaveModules {xfFileName} {
  global autoLoadList
  global moduleList
  global xfConf
  global xfMisc
  global xfPath
  global xfSaveModuleList
  global xfStatus

  if {$xfStatus(saving)} {
    return
  }
  set xfStatus(saving) 1
  XFMiscUpdateModuleList
  # clear up the window showing stuff
  XFEditSetShowWindows

  # save modules
  foreach xfModFileName [lsort [array names moduleList]] {
    if {"$xfModFileName" == $xfConf(programName) ||
        (([llength $xfSaveModuleList] > 0 &&
          [lsearch $xfSaveModuleList $xfModFileName] == -1) ||
          [llength $xfSaveModuleList] == 0)} {
      continue
    }
    if {[file exists $xfModFileName]} {
      catch "exec cp $xfModFileName $xfModFileName~"
    }
    if {[catch "open $xfModFileName w" xfOutFile]} {
      XFProcError "$xfOutFile"
    } {
      XFSaveComment $xfOutFile module $xfModFileName
      puts $xfOutFile "\n# module contents"
      puts $xfOutFile "global moduleList"
      puts $xfOutFile "global autoLoadList"
      if {[info exists moduleList($xfModFileName)]} {
        puts $xfOutFile "set moduleList($xfModFileName) \{[set moduleList($xfModFileName)]\}"
      }
      if {[info exists autoLoadList($xfModFileName)]} {
        puts $xfOutFile "set autoLoadList($xfModFileName) \{[set autoLoadList($xfModFileName)]\}"
      }

      puts $xfOutFile "\n# procedures to show toplevel windows"

      # save all visible children of . in this module
      foreach xfCounter [lsort [winfo children .]] {
        if {[lsearch [set moduleList($xfModFileName)] $xfCounter] >= 0} {
          XFSaveRootToplevelChild $xfOutFile $xfCounter
          XFSaveSourceDestroyWindow $xfOutFile $xfCounter
          XFSaveShowWindowTail $xfOutFile $xfCounter
        }
      }
      # save all invisible children of . in this module
      foreach xfProcName [lsort [info procs ShowWindow.*]] {
        if {[lsearch [set moduleList($xfModFileName)] \
              [string range $xfProcName 10 end]] >= 0} {
          XFSaveShowWindow $xfOutFile $xfProcName
        }
      }

      # save .
      set xfMisc(menuBarTraversalList) ""
      set xfMisc(specialSaveString) ""
      if {[lsearch [set moduleList($xfModFileName)] .] >= 0} {
        puts $xfOutFile "\n\n# procedure to show window ."
        puts $xfOutFile "proc ShowWindow. {args} {# xf ignore me 7"
        if {"[info procs StartupSrc.]" != ""} {
          puts $xfOutFile "\nStartupSrc."
        }
        XFSaveWidget $xfOutFile .
        XFSaveBind $xfOutFile .
        XFSaveWidgetSpecial $xfOutFile .
        XFSaveSubwindow $xfOutFile .
        if {"[info procs MiddleSrc.]" != ""} {
          puts $xfOutFile "\nMiddleSrc."
        }
        XFSavePack $xfOutFile .
        XFSavePlace $xfOutFile .
        puts $xfOutFile "\n  if {\"\[info procs XFEdit\]\" != \"\"} {"
        puts $xfOutFile "    XFEditSetShowWindows"
        puts $xfOutFile "    XFMiscBindWidgetTree $xfCounter"
        puts $xfOutFile "  }"
        XFSaveMenubarTraversal $xfOutFile
        if {"$xfMisc(specialSaveString)" != ""} {
          puts $xfOutFile "\n$xfMisc(specialSaveString)\n"
        }
        if {"[info procs EndSrc.]" != ""} {
          puts $xfOutFile "\nEndSrc."
        }
        puts $xfOutFile "}"
        XFSaveShowWindowTail $xfOutFile .
      }

      # save procedures
      puts $xfOutFile "\n\n# User defined procedures"
      foreach xfProcName [set moduleList($xfModFileName)] {
        if {"[info procs $xfProcName]" != ""} {
          if {"Alias" == "$xfProcName" ||
              "Unalias" == "$xfProcName" ||
              "SymbolicName" == "$xfProcName" ||
              "SN" == "$xfProcName" ||
              "MenuPopupAdd" == "$xfProcName" ||
              "MenuPopupHandle" == "$xfProcName" ||
              "NoFunction" == "$xfProcName" ||
              "GetSelection" == "$xfProcName"} {
            continue
          }
          XFSaveProc $xfOutFile $xfProcName
        }
      }
      puts $xfOutFile "\n\n# Internal procedures"
      foreach xfProcName [set moduleList($xfModFileName)] {
        if {"[info procs $xfProcName]" != ""} {
          if {"Alias" == "$xfProcName" ||
              "Unalias" == "$xfProcName" ||
              "SymbolicName" == "$xfProcName" ||
              "SN" == "$xfProcName" ||
              "MenuPopupAdd" == "$xfProcName" ||
              "MenuPopupHandle" == "$xfProcName" ||
              "NoFunction" == "$xfProcName" ||
              "GetSelection" == "$xfProcName"} {
            XFSaveProc $xfOutFile $xfProcName
          }
        }
      }
      puts $xfOutFile "\n# eof"
      puts $xfOutFile "#"
      puts $xfOutFile ""
      close $xfOutFile
    }
  }

  # save main part
  if {([llength $xfSaveModuleList] > 0 &&
       [lsearch $xfSaveModuleList $xfFileName] == -1) ||
       [llength $xfSaveModuleList] == 0} {
    if {[file exists $xfFileName]} {
      catch "exec cp $xfFileName $xfFileName~"
      catch "exec cp $xfFileName $xfPath(tmp)/lc$xfStatus(uniqueId)"
    }
    if {[catch "open $xfFileName w" xfOutFile]} {
      XFProcError "$xfOutFile"
    } {
      XFSaveComment $xfOutFile file [file rootname $xfConf(programName)]
      XFSaveSourcePrefix $xfOutFile

      # save all visible children of . in this module
      foreach xfCounter [lsort [winfo children .]] {
        if {[XFMiscInModule $xfCounter] == 0 &&
            [XFMiscIsXFElement $xfCounter] == 0 &&
            "[winfo class $xfCounter]" == "Toplevel"} {
          XFSaveRootToplevelChild $xfOutFile $xfCounter
          XFSaveSourceDestroyWindow $xfOutFile $xfCounter
          XFSaveShowWindowTail $xfOutFile $xfCounter
        }
      }
      # save all invisible children of . in this module
      foreach xfProcName [lsort [info procs ShowWindow.*]] {
        if {[XFMiscInModule [string range $xfProcName 10 end]] == 0 &&
            [XFMiscIsXFElement [string range $xfProcName 10 end]] == 0} {
          XFSaveShowWindow $xfOutFile $xfProcName
        }
      }

      # save .
      if {[XFMiscInModule .] == 0 &&
          [XFMiscIsXFElement .] == 0} {
        set xfMisc(menuBarTraversalList) ""
        set xfMisc(specialSaveString) ""
        puts $xfOutFile "\n\n# procedure to show window ."
        puts $xfOutFile "proc ShowWindow. {args} {# xf ignore me 7"
        if {"[info procs StartupSrc.]" != ""} {
          puts $xfOutFile "\nStartupSrc."
        }
        XFSaveWidget $xfOutFile .
        XFSaveBind $xfOutFile .
        XFSaveWidgetSpecial $xfOutFile .
        XFSaveSubwindow $xfOutFile .
        if {"[info procs MiddleSrc.]" != ""} {
          puts $xfOutFile "\nMiddleSrc."
        }
        XFSavePack $xfOutFile .
        XFSavePlace $xfOutFile .
        puts $xfOutFile "\n  if {\"\[info procs XFEdit\]\" != \"\"} {"
        puts $xfOutFile "    XFEditSetShowWindows"
        puts $xfOutFile "    XFMiscBindWidgetTree $xfCounter"
        puts $xfOutFile "  }"
        XFSaveMenubarTraversal $xfOutFile
        if {"$xfMisc(specialSaveString)" != ""} {
          puts $xfOutFile "\n$xfMisc(specialSaveString)\n"
        }
        if {"[info procs EndSrc.]" != ""} {
          puts $xfOutFile "\nEndSrc."
        }
        puts $xfOutFile "}"
        XFSaveShowWindowTail $xfOutFile .
      }

      # save procedures
      puts $xfOutFile "\n\n# User defined procedures"
      set xfTmpList ""
      foreach xfProcName [set moduleList($xfConf(programName))] {
        if {[XFMiscInModule $xfProcName] == 0 &&
            [XFMiscIsXFElement $xfProcName] == 0 &&
            "[info procs $xfProcName]" != ""} {
          if {"Alias" == "$xfProcName" ||
              "Unalias" == "$xfProcName" ||
              "SymbolicName" == "$xfProcName" ||
              "SN" == "$xfProcName" ||
              "MenuPopupAdd" == "$xfProcName" ||
              "MenuPopupHandle" == "$xfProcName" ||
              "NoFunction" == "$xfProcName" ||
              "GetSelection" == "$xfProcName"} {
            continue
          }
          XFSaveProc $xfOutFile $xfProcName
          lappend xfTmpList "$xfProcName"
        }
      }
      foreach xfProcName [lsort [info procs]] {
        if {[XFMiscInModule $xfProcName] == 0 &&
            [XFMiscIsXFElement $xfProcName] == 0 &&
            [lsearch $xfTmpList $xfProcName] == -1} {
          if {"Alias" == "$xfProcName" ||
              "Unalias" == "$xfProcName" ||
              "SymbolicName" == "$xfProcName" ||
              "SN" == "$xfProcName" ||
              "MenuPopupAdd" == "$xfProcName" ||
              "MenuPopupHandle" == "$xfProcName" ||
              "NoFunction" == "$xfProcName" ||
              "GetSelection" == "$xfProcName"} {
            continue
          }
          XFSaveProc $xfOutFile $xfProcName
        }
      }
      puts $xfOutFile "\n\n# Internal procedures"
      set xfTmpList ""
      foreach xfProcName [set moduleList($xfConf(programName))] {
        if {[XFMiscInModule $xfProcName] == 0 &&
            [XFMiscIsXFElement $xfProcName] == 0 &&
            "[info procs $xfProcName]" != ""} {
          if {"Alias" == "$xfProcName" ||
              "Unalias" == "$xfProcName" ||
              "SymbolicName" == "$xfProcName" ||
              "SN" == "$xfProcName" ||
              "MenuPopupAdd" == "$xfProcName" ||
              "MenuPopupHandle" == "$xfProcName" ||
              "NoFunction" == "$xfProcName" ||
              "GetSelection" == "$xfProcName"} {
            XFSaveProc $xfOutFile $xfProcName
            lappend xfTmpList "$xfProcName"
          }
        }
      }
      foreach xfProcName [lsort [info procs]] {
        if {[XFMiscInModule $xfProcName] == 0 &&
            [XFMiscIsXFElement $xfProcName] == 0 &&
            [lsearch $xfTmpList $xfProcName] == -1} {
          if {"Alias" == "$xfProcName" ||
              "Unalias" == "$xfProcName" ||
              "SymbolicName" == "$xfProcName" ||
              "SN" == "$xfProcName" ||
              "MenuPopupAdd" == "$xfProcName" ||
              "MenuPopupHandle" == "$xfProcName" ||
              "NoFunction" == "$xfProcName" ||
              "GetSelection" == "$xfProcName"} {
            XFSaveProc $xfOutFile $xfProcName
          }
        }
      }
 
      XFSaveSourceAppendix $xfOutFile
      puts $xfOutFile "\n# eof"
      puts $xfOutFile "#"
      puts $xfOutFile ""
      close $xfOutFile
    }
    catch "chmod u+x $xfFileName"
  }
  set xfStatus(saving) 0
}

##########
# Procedure: XFSaveModuleList
# Description: save current save module selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFSaveModuleList {} {
  global xfSaveModuleList

  if {[catch "open .xf-save-modules w" xfOutFile]} {
    XFProcError "$xfOutFile"
  } {
    puts $xfOutFile "global xfSaveModuleList"
    puts $xfOutFile "set xfSaveModuleList {[set xfSaveModuleList]}"
    puts $xfOutFile "\n# eof"
    puts $xfOutFile "#"
    puts $xfOutFile ""
    close $xfOutFile
  }
}

##########
# Procedure: XFSaveAsProc
# Description: save selected toplevel to procedure
# Arguments: xfW
# Returns: none
# Sideeffects: none
##########
proc XFSaveAsProc {xfW} {
  global xfConf
  global xfPath
  global xfStatus

  if {$xfStatus(saving)} {
    return
  }
  set xfStatus(saving) 1

  if {"[info commands $xfW]" != ""} {
    if {[catch "open $xfPath(tmp)/tp$xfStatus(uniqueId) w" xfOutFile]} {
      XFProcError "Could not create toplevel procedure\nI will not remove this toplevel\n$xfOutFile"
    } {
      XFSaveRootToplevelChild $xfOutFile $xfW
      XFSaveSourceDestroyWindow $xfOutFile $xfW
      close $xfOutFile

      if {[catch "source $xfPath(tmp)/tp$xfStatus(uniqueId)" xfResult]} {
        XFProcError "Could not create toplevel procedure\nI will not remove this toplevel\n$xfResult"
      } {
        XFDestroy $xfW
        update
        catch "exec rm $xfPath(tmp)/tp$xfStatus(uniqueId)"
      }
    }
  }
  set xfStatus(saving) 0
}

##########
# Procedure: XFSaveClassBindings
# Description: save class bindings
# Arguments: xfFileName - the output file name
# Returns: none
# Sideeffects: none
##########
proc XFSaveClassBindings {xfFileName} {
  global xfConf
  global xfPath
  global xfStatus

  if {$xfStatus(saving)} {
    return
  }
  set xfStatus(saving) 1

  # save current file
  if {[catch "open $xfFileName w" xfOutFile]} {
    XFProcError "$xfOutFile"
  } {
    puts $xfOutFile "# class bindings"
    puts $xfOutFile "#"
    foreach xfCounter $xfStatus(elementList) {
      XFSaveBind $xfOutFile $xfCounter 1
    }
    foreach xfCounter $xfStatus(additionalList) {
      XFSaveBind $xfOutFile $xfCounter 1
    }
    puts $xfOutFile "\n# eof"
    puts $xfOutFile "#"
    puts $xfOutFile ""
    close $xfOutFile
  }
  set xfStatus(saving) 0
}

##########
# Procedure: XFSaveProcsTmplt
# Description: save procedures in template file
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFSaveProcsTmplt {} {
  global xfPath
  global xfStatus

  if {[catch "open $xfPath(tmp)/tb$xfStatus(uniqueId) a" xfOutFile] != 0} {
    XFProcError "$xfOutFile"
  } {
    puts $xfOutFile "# XFInternalString"
    puts $xfOutFile "# Procedures"
    foreach xfProcName $xfStatus(tmpltList) {
      if {[catch "winfo class $xfProcName"]} {
        XFSaveProc $xfOutFile $xfProcName
      }
    }
    close $xfOutFile
  }
}

##########
# Procedure: XFSaveScript
# Description: save a startup script
# Arguments: xfProgramName - the prograqm name
# Returns: none
# Sideeffects: none
##########
proc XFSaveScript {xfProgramName} {
  global xfConf
  global xfLoadPath

  if {![catch "open [file rootname $xfProgramName].sh w" outFile]} {
    puts $outFile "#!/bin/sh"
    puts $outFile "#"
    puts $outFile "# Program: [file rootname $xfProgramName]"
    puts $outFile "#"
    puts $outFile "# This file is an automatically created shell script"
    puts $outFile "# for starting the application named: $xfProgramName"
    puts $outFile "#"
    puts $outFile "# adapt the following variables to fit your"
    puts $outFile "# local site"
    puts $outFile "#"
    puts $outFile "# WHIS_CMD is the wish interpreter to use"
    puts $outFile "WISH_CMD=$xfConf(interpreter)"
    puts $outFile "#"
    puts $outFile "# XF_LOAD_PATH is the path were the tcl modules"
    puts $outFile "# for this application are located"
    puts $outFile "if test \"\$XF_LOAD_PATH\" = \"\"; then"
    puts $outFile "  XF_LOAD_PATH=$xfLoadPath"
    puts $outFile "else"
    puts $outFile "  XF_LOAD_PATH=\$XF_LOAD_PATH:$xfLoadPath"
    puts $outFile "fi"
    puts $outFile "#"
    puts $outFile "#"
    puts $outFile "ARGC=\$#"
    puts $outFile "COMMANDLINE="
    puts $outFile "while \[ \$ARGC -gt 0 \]; do"
    puts $outFile "  C=\$1"
    puts $outFile "  shift"
    puts $outFile "  ARGC=`expr \$ARGC - 1`"
    puts $outFile "  case \$C in"
    puts $outFile "    -xfloadpath)"
    puts $outFile "      if \[ \$ARGC -gt 0 \]; then"
    puts $outFile "        C=\$1"
    puts $outFile "        shift"
    puts $outFile "        ARGC=`expr \$ARGC - 1`"
    puts $outFile "        XF_LOAD_PATH=\$C:\$XF_LOAD_PATH"
    puts $outFile "      else"
    puts $outFile "        echo \"$xfProgramName: expected path for -xfloadpath\""
    puts $outFile "        exit 2"
    puts $outFile "      fi;;"
    puts $outFile "    *)"
    puts $outFile "      COMMANDLINE=\$COMMANDLINE\" \"\$C;;"
    puts $outFile "  esac"
    puts $outFile "done"
    puts $outFile "#"
    puts $outFile "export XF_LOAD_PATH"
    puts $outFile "for p in `echo \$XF_LOAD_PATH|awk 'BEGIN{RS=\":\"}{print \$0}'`; do"
    puts $outFile "  if test -f \$p/$xfProgramName; then "
    puts $outFile "    exec \$WISH_CMD -n [file rootname $xfProgramName] -f \$p/$xfProgramName \$COMMANDLINE"
    puts $outFile "  fi"
    if {$xfConf(versionCommand)} {
      puts $outFile "  (cd \$p; retrv -q $xfProgramName) 2>/dev/null"
      puts $outFile "  if test -f \$p/$xfProgramName; then "
      puts $outFile "    \$WISH_CMD -n [file rootname $xfProgramName] -f \$p/$xfProgramName \$COMMANDLINE"
      puts $outFile "    (cd \$p; rm -f $xfProgramName) 2>/dev/null"
      puts $outFile "  fi"
    }
    puts $outFile "done"
    puts $outFile "echo \"Could not find: $xfProgramName\""
    puts $outFile "# eof"
    puts $outFile ""
    close $outFile
    catch "chmod u+x [file rootname $xfProgramName].sh"
  } {
    XFProcError "Could not open [file rootname $xfProgramName].sh"
  }
}

##########
# Procedure: XFSaveSubTree
# Description: save the widget sub tree
# Arguments: xfW - the widget
#            xfFileName - the output file
#            xfSaveAsProc - save with variable as pathname
# Returns: none
# Sideeffects: none
##########
proc XFSaveSubTree {xfW xfFileName {xfSaveAsProc 0}} {
  global symbolicName
  global xfMisc
  global xfAppDefToplevels

  if {"$xfW" == "."} {
    XFProcError "Sorry, no cutting from ."
    return
  }
  if {[catch "open $xfFileName w" xfOutFile]} {
    XFProcError "$xfOutFile"
  } {
    set xfMisc(menuBarTraversalList) ""
    set xfMisc(specialSaveString) ""
    puts $xfOutFile "# $xfW"
    puts $xfOutFile "# The above line makes pasting MUCH easier for me."
    puts $xfOutFile "# It contains the pathname of the cutted widget."
    XFSaveComment $xfOutFile template [file rootname [file tail $xfFileName]]

    if {$xfSaveAsProc} {
      puts $xfOutFile "\nproc V[winfo class $xfW]$xfW { insertWidgetPath args} {"
      puts $xfOutFile "\n  set xfCounter 0"
      puts $xfOutFile "  set xfLength \[llength \$args\]"
      puts $xfOutFile "  while {\$xfCounter < \$xfLength} {"
      puts $xfOutFile "    set xfElement \[lindex \$args \$xfCounter\]"
      puts $xfOutFile "    if {\"\$xfElement\" == \"-startupSrc\" ||"
      puts $xfOutFile "        \"\$xfElement\" == \"-middleSrc\" ||"
      puts $xfOutFile "        \"\$xfElement\" == \"-endSrc\"} {"
      puts $xfOutFile "      if {\$xfLength > \[expr \$xfCounter+1\]} {"
      puts $xfOutFile "        incr xfCounter"
      puts $xfOutFile "        set xfSource(\$xfElement) \[lindex \$args \$xfCounter\]"
      puts $xfOutFile "      }"
      puts $xfOutFile "    } {"
      puts $xfOutFile "      if {\[string match -* \$xfElement\]} {"
      puts $xfOutFile "        if {\$xfLength > \[expr \$xfCounter+1\]} {"
      puts $xfOutFile "          incr xfCounter"
      puts $xfOutFile "          set xfGenResource(\$xfElement) \[lindex \$args \$xfCounter\]"
      puts $xfOutFile "        }"
      puts $xfOutFile "      } {"
      puts $xfOutFile "        if {\[string match .* \$xfElement\]} {"
      puts $xfOutFile "          if {\$xfLength > \[expr \$xfCounter+2\]} {"
      puts $xfOutFile "            incr xfCounter"
      puts $xfOutFile "            set xfSpecResource(\$xfElement) \[lindex \$args \$xfCounter\]"
      puts $xfOutFile "            incr xfCounter"
      puts $xfOutFile "            lappend xfSpecResource(\$xfElement) \[lindex \$args \$xfCounter\]"
      puts $xfOutFile "          }"
      puts $xfOutFile "        }"
      puts $xfOutFile "      }"
      puts $xfOutFile "    }"
      puts $xfOutFile "    incr xfCounter"
      puts $xfOutFile "  }"
      puts $xfOutFile "  if {\"\$insertWidgetPath\" == \".\"} {"
      puts $xfOutFile "    set insertWidgetPath \"\""
      puts $xfOutFile "  }"
      puts $xfOutFile "\n  if {\"\[info commands $xfW\]\" == \"\"} {"
      puts $xfOutFile "  if {\[info exists xfSource(-startupSrc)\]} {"
      puts $xfOutFile "    if {\[catch \"\$xfSource(-startupSrc)\" xfResult\]} {"
      puts $xfOutFile "      puts stderr \$xfResult"
      puts $xfOutFile "    }"
      puts $xfOutFile "  }"
      # make interpreter happy }}
    }
    XFSaveWidget $xfOutFile $xfW
    XFSaveBind $xfOutFile $xfW
    XFSaveWidgetSpecial $xfOutFile $xfW
    XFSaveSubwindow $xfOutFile $xfW
    if {$xfSaveAsProc} {
      puts $xfOutFile "\n  if {\[info exists xfSource(-middleSrc)\]} {"
      puts $xfOutFile "    if {\[catch \"\$xfSource(-middleSrc)\" xfResult\]} {"
      puts $xfOutFile "      puts stderr \$xfResult"
      puts $xfOutFile "    }"
      puts $xfOutFile "  }"
    }
    XFSavePack $xfOutFile $xfW
    XFSavePlace $xfOutFile $xfW
    set xfParent [string range $xfW 0 [expr [string last . $xfW]-1]]
    if {"$xfParent" == ""} {
      set xfParent .
    }
    XFSavePackOne $xfOutFile $xfParent $xfW $xfSaveAsProc
    XFSavePlaceOne $xfOutFile $xfParent $xfW $xfSaveAsProc
    XFSaveMenubarTraversal $xfOutFile
    if {[lsearch $xfAppDefToplevels $xfW] != -1} {
      puts $xfOutFile "  if {\"\[info procs XFLocalSetAppDefs\]\" != \"\"} {"
      puts $xfOutFile "    XFLocalSetAppDefs"
      puts $xfOutFile "  }"
    }
    if {"$xfMisc(specialSaveString)" != ""} {
      puts $xfOutFile "\n$xfMisc(specialSaveString)\n"
    }
    if {$xfSaveAsProc} {
      # make interpreter happy {
      puts $xfOutFile "\n  if {\[info exists xfSource(-endSrc)\]} {"
      puts $xfOutFile "    if {\[catch \"\$xfSource(-endSrc)\" xfResult\]} {"
      puts $xfOutFile "      puts stderr \$xfResult"
      puts $xfOutFile "    }"
      puts $xfOutFile "  }"
      puts $xfOutFile "  }"
      puts $xfOutFile "\n  if {\[info exists xfGenResource\]} {"
      puts $xfOutFile "    set xfWidgetList \"\""
      puts $xfOutFile "    set xfTmpWidgetList $xfW"
      puts $xfOutFile "    while {1} {"
      puts $xfOutFile "      if {\[llength \$xfTmpWidgetList\] == 0} {"
      puts $xfOutFile "        break"
      puts $xfOutFile "      }"
      puts $xfOutFile "      set xfFirstWidget \[lindex \$xfTmpWidgetList 0\]"
      puts $xfOutFile "      lappend xfWidgetList \$xfFirstWidget"
      puts $xfOutFile "      set xfTmpWidgetList \[lreplace \$xfTmpWidgetList 0 0\]"
      puts $xfOutFile "      if {\"\[winfo children \$xfFirstWidget\]\" != \"\"} {"
      puts $xfOutFile "        eval lappend xfTmpWidgetList \[winfo children \$xfFirstWidget\]"
      puts $xfOutFile "      }"
      puts $xfOutFile "    }"
      puts $xfOutFile "    foreach xfCounter \$xfWidgetList {"
      puts $xfOutFile "      if {\[info exists xfGenResource\]} {"
      puts $xfOutFile "        foreach xfResource \[array names xfGenResource\] {"
      puts $xfOutFile "          catch \"\$xfCounter config \$xfResource \[set xfGenResource(\$xfResource)\]\""
      puts $xfOutFile "        }"
      puts $xfOutFile "      }"
      puts $xfOutFile "    }"
      puts $xfOutFile "  }"
      puts $xfOutFile "  if {\[info exists xfSpecResource\]} {"
      puts $xfOutFile "    foreach xfCounter \[array names xfSpecResource\] {"
      puts $xfOutFile "      if {\"\[info commands \$xfCounter\]\" != \"\"} {"
      puts $xfOutFile "        catch \"\$xfCounter config \[lindex \$xfSpecResource(\$xfCounter) 0\] \[lindex \$xfSpecResource(\$xfCounter) 1\]\""
      puts $xfOutFile "      }"
      puts $xfOutFile "    }"
      puts $xfOutFile "  }"
      puts $xfOutFile "  return $xfW"
      # make interpreter happy {
      puts $xfOutFile "}"
    }
    puts $xfOutFile "# end of widget tree\n"
    close $xfOutFile
  }
}

##########
# Procedure: XFSaveTclIndex
# Description: save the tclIndex file
# Arguments: xfOutFile - the output descriptor
#            xfParent - the parent widget
# Returns: none
# Sideeffects: none
##########
proc XFSaveTclIndex {} {
  global autoLoadList
  global moduleList
  global xfConf

  set xfTclIndex ""
  foreach xfCounter [array names moduleList] {
    if {"$xfCounter" == "$xfConf(programName)"} {
      continue
    }
    if {"$moduleList($xfCounter)" != ""} {
      append xfTclIndex "# $xfCounter\n"
    }
    foreach xfElement $moduleList($xfCounter) {
      if {[catch "winfo class $xfElement"]} {
        if {[info exists ShowWindow$xfElement]} {
          append xfTclIndex "ShowWindow$xfElement $xfCounter\n"
        } {
          append xfTclIndex "$xfElement $xfCounter\n"
        }
      } {
        if {"[info procs ShowWindow$xfElement]" != ""} {
          append xfTclIndex "ShowWindow$xfElement $xfCounter\n"
        }
        if {"[info procs DestroyWindow$xfElement]" != ""} {
          append xfTclIndex "DestroyWindow$xfElement $xfCounter\n"
        }
        if {"[info procs StartupSrc$xfElement]" != ""} {
          append xfTclIndex "StartupSrc$xfElement $xfCounter\n"
        }
        if {"[info procs MiddleSrc$xfElement]" != ""} {
          append xfTclIndex "MiddleSrc$xfElement $xfCounter\n"
        }
        if {"[info procs EndSrc$xfElement]" != ""} {
          append xfTclIndex "EndSrc$xfElement $xfCounter\n"
        }
      }
    }
    if {"$moduleList($xfCounter)" != ""} {
      append xfTclIndex "\n"
    }
  }

  if {"$xfTclIndex" != ""} {
    if {[catch "open tclIndex w" xfOutFile]} {
      XFProcError "$xfOutFile"
    } {
      puts $xfOutFile "# Tcl autoload index file: each line identifies a Tcl"
      puts $xfOutFile "# procedure and the file where that procedure is"
      puts $xfOutFile "# defined.  Generated by the \"auto_mkindex\" command.\n"
      puts $xfOutFile "$xfTclIndex"
      puts $xfOutFile "# end of tclIndex"
      puts $xfOutFile ""
      close $xfOutFile
    }
  }
}

# eof

