# Copyright (c) 1993 Michael B. Durian.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by Michael B. Durian.
# 4. The name of the the Author may be used to endorse or promote 
#    products derived from this software without specific prior written 
#    permission.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

# wishm.tcl,v 1.3 1993/04/05 21:35:12 durian Exp

# default bindings for drumgrid widget
# briefly:
# mouse 1 - incrs. level
# mouse 3 - decrs. level
# mouse 2 - clears
# keys 0-9 set level to value
# key + incrs. level by 10
# key - decrs. level by 10
#
# also handles moving in and out of boxes, in and out of grid, changing
# relief etc.

set DrumGridSomethingPressed 0

proc DrumGridPress {W x y} {
	global DrumGridLastX
	global DrumGridLastY
	global DrumGridSomethingPressed

	incr DrumGridSomethingPressed
	set DrumGridLastX [$W xnearest $x]
	set DrumGridLastY [$W ynearest $y]
	if {$DrumGridLastX != -1 && $DrumGridLastY != -1} {
		$W down $DrumGridLastX $DrumGridLastY
	}
}

proc DrumGridMotion {W x y} {
	global DrumGridLastX
	global DrumGridLastY

	set DrumGridNewX [$W xnearest $x]
	set DrumGridNewY [$W ynearest $y]
	if {$DrumGridNewX != $DrumGridLastX || \
	    $DrumGridNewY != $DrumGridLastY} {
		if {$DrumGridLastX != -1 && $DrumGridLastY != -1} {
			$W up $DrumGridLastX $DrumGridLastY
		}
		if {$DrumGridNewX != -1 && $DrumGridNewY != -1} {
			$W down $DrumGridNewX $DrumGridNewY
		}
		set DrumGridLastX $DrumGridNewX
		set DrumGridLastY $DrumGridNewY
	}
}

bind DrumGrid <ButtonPress> {

	DrumGridPress %W %x %y
}

bind DrumGrid <Any-Motion> {
	global DrumGridSomethingPressed

	if {$DrumGridSomethingPressed} {
		DrumGridMotion %W %x %y
	}
}

bind DrumGrid <ButtonRelease-1> {
	global DrumGridLastX
	global DrumGridLastY
	global DrumGridSomethingPressed

	if {$DrumGridLastX != -1 && $DrumGridLastY != -1} {
		%W volume set $DrumGridLastX $DrumGridLastY \
		    [expr {[%W volume get $DrumGridLastX $DrumGridLastY] + 1}]
	}
	incr DrumGridSomethingPressed -1
}

bind DrumGrid <ButtonRelease-2> {
	global DrumGridLastX
	global DrumGridLastY
	global DrumGridSomethingPressed

	if {$DrumGridLastX != -1 && $DrumGridLastY != -1} {
		%W volume set $DrumGridLastX $DrumGridLastY 0
	}
	incr DrumGridSomethingPressed -1
}

bind DrumGrid <ButtonRelease-3> {
	global DrumGridLastX
	global DrumGridLastY
	global DrumGridSomethingPressed

	if {$DrumGridLastX != -1 && $DrumGridLastY != -1} {
		%W volume set $DrumGridLastX $DrumGridLastY \
		    [expr {[%W volume get $DrumGridLastX $DrumGridLastY] - 1}]
	}
	incr DrumGridSomethingPressed -1
}

bind DrumGrid <Enter> {

	focus %W
}

bind DrumGrid <Leave> {

	focus none
}

bind DrumGrid <Any-KeyPress> {

	case %A in {
	{1 2 3 4 5 6 7 8 9 0 + -} {
		DrumGridPress %W %x %y
	}
	}
}

bind DrumGrid <Any-KeyRelease> {
	global DrumGridLastX
	global DrumGridLastY
	global DrumGridSomethingPressed

	case %A in {
	{1 2 3 4 5 6 7 8 9 0} {
		%W volume set $DrumGridLastX $DrumGridLastY %A
		incr DrumGridSomethingPressed -1
	}
	{+} {
		%W volume set $DrumGridLastX $DrumGridLastY \
		    [expr {[%W volume get $DrumGridLastX $DrumGridLastY] + 10}]
		incr DrumGridSomethingPressed -1
	}
	{-} {
		%W volume set $DrumGridLastX $DrumGridLastY \
		    [expr {[%W volume get $DrumGridLastX $DrumGridLastY] - 10}]
		incr DrumGridSomethingPressed -1
	}
	}
}
