/*
 * data.h
 */
#include "copyright.h"

#define EX_FRAMES 		5
#define SBEXPVIEWS 		7
#define NUMDETFRAMES		5	/* # frames in torp explosion */
#define ex_width        	64
#define ex_height       	64
#define sbexp_width        	80
#define sbexp_height       	80
#define cloud_width 		9
#define cloud_height 		9
#define plasmacloud_width 	13
#define plasmacloud_height 	13
#define etorp_width 		3
#define etorp_height 		3
#define eplasmatorp_width 	7
#define eplasmatorp_height 	7
#define mplasmatorp_width 	5
#define mplasmatorp_height 	5
#define mtorp_width 		3
#define mtorp_height 		3
#define crossmask_width 	16
#define crossmask_height 	16
#define planet_width 		30
#define planet_height 		30
#define mplanet_width 		16
#define mplanet_height 		16
#define shield_width 		20
#define shield_height 		20
#define cloak_width		20
#define cloak_height		20
#define icon_width 		112
#define icon_height 		80

extern struct player *players;
extern struct player *me;
extern struct torp *torps;
extern struct plasmatorp *plasmatorps;
extern struct status *status;
extern struct ship *myship;
extern struct stats *mystats;
extern struct planet *planets;
extern struct phaser *phasers;
extern struct message *messages;
extern struct mctl *mctl;
extern struct team *teams;
extern struct memory universe;
extern struct planet pdata[];

extern int oldalert;
extern int remap[];
extern int udcounter;
extern int messpend;
extern int lastcount;
extern int mdisplayed;
extern int redrawall;
extern int nopilot;
extern int watch;
extern int selfdest;
extern int lastm;
extern int delay;
extern int rdelay;
extern int mapmode; 
extern int namemode; 
extern int showShields;
extern int showStats;
extern int warncount;
extern int warntimer;
extern int infomapped;
extern int mustexit;
extern int messtime;
extern int keeppeace;
extern int showlocal, showgalactic;
extern char *shipnos;
extern int sock;
extern int xtrekPort;
extern int queuePos;
extern int pickOk;
extern int lastRank;
extern int promoted;
extern int loginAccept;
extern unsigned localflags;
extern int tournMask;
extern int nextSocket;
extern int updatePlayer[];
extern char *serverName;
extern int loggedIn;
extern int reinitPlanets;
extern int redrawPlayer[];
extern int lastUpdate[];
extern int timerDelay;
extern int reportKills;

extern double	Sin[], Cos[];

extern W_Icon stipple, clockpic, icon;

#define VIEWS 16
#define NUM_TYPES 8
extern W_Icon expview[EX_FRAMES];
extern W_Icon sbexpview[SBEXPVIEWS];
extern W_Icon cloud[NUMDETFRAMES];
extern W_Icon plasmacloud[NUMDETFRAMES];
extern W_Icon etorp, mtorp;
extern W_Icon eplasmatorp, mplasmatorp;
extern W_Icon shield, cloakicon;
extern W_Icon fed_bitmaps[NUM_TYPES][VIEWS],
       	      kli_bitmaps[NUM_TYPES][VIEWS],
       	      rom_bitmaps[NUM_TYPES][VIEWS],
       	      ori_bitmaps[NUM_TYPES][VIEWS];
extern W_Icon bplanets[6];
extern W_Icon mbplanets[6];
extern W_Icon bplanets2[8];
extern W_Icon mbplanets2[8];

extern W_Color	borderColor, backColor, textColor, myColor, 
		warningColor, shipCol[5], rColor, yColor,
		gColor, unColor, foreColor;

extern char teamlet[];
extern char *teamshort[];
extern char pseudo[PSEUDOSIZE];
extern char login[PSEUDOSIZE];

extern struct rank ranks[NUMRANKS];

extern W_Window	messagew, w, mapw, statwin, baseWin, infow, iconWin, tstatw,
		war, warnw, helpWin, teamWin[4], qwin, messwa, messwt, messwi,
		messwk, planetw, rankw, playerw, optionWin, reviewWin;
