# Dialog
# ----------------------------------------------------------------------
# Implements a toplevel window containing a message and buttons
#
#   PUBLIC ATTRIBUTES:
#
#     -text .......... the message to display
#     -bitmap  ....... a bitmap to display to the left of the message
#     -buttons ....... a list of buttons to add to the dialog
#     -padx .......... horizontal margin around buttons
#     -pady .......... vertical margin around buttons
#     -variable ...... variable through which to return the name of 
#                      the selected button
#
#   METHODS:
#
#     None.
#
# ----------------------------------------------------------------------
#   AUTHOR:  Jim Wight        <j.k.wight@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1994 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================

itcl_class Dialog {
    inherit Window

    constructor {args} {
      eval Window::constructor $args

      ::frame $this._buttons 
      ::frame $this._text 

      if {[set pos [lsearch $args -buttons]] != -1} {
	  foreach button [lindex $args [expr $pos + 1]] {
	      button $this.$button -text $button \
	                                        -command "$this select $button"
	      pack $this.$button  -in $this._buttons \
	                                     -side left -padx $padx -pady $pady
	  }
      }

      label $this.warn -bitmap warning
      label $this.text -text $text
      pack $this.warn $this.text -in $this._text -side left

      pack $this._text
      pack [::frame $this._join -geometry 2x2 -relief raised -borderwidth 1] \
           -fill x
      pack $this._buttons
      
      transient .
      withdraw
      update idletasks
      set x [expr [winfo screenwidth $this]/2 - [winfo reqwidth $this]/2 \
	     - [winfo vrootx [winfo parent $this]]]
      set y [expr [winfo screenheight $this]/2 - [winfo reqheight $this]/2 \
	     - [winfo vrooty [winfo parent $this]]]
      geometry +$x+$y
      deiconify

      set focus [focus]
      grab $this
      focus $this
      eval set var $variable
      global $var
      tkwait variable $var
    }

    public bitmap   {warning}
    public text     {}
    public buttons  {}
    public padx     {5}
    public pady     {5}
    public variable {_$this}


    # For private use from here on
    #
    method select {button} {
	eval set var $variable
	global $var

	set $var $button
	focus $focus
	$this delete
    }

    protected focus {}
}    
