#!/usr/local/bin/itcl_wish -f

# Class viewer
# ----------------------------------------------------------------------
# Assumes that the sample classes are in ../lib or that their location
# is communicated through the WIGWAMLIB environment variable.
# ----------------------------------------------------------------------

if {[catch "set env(WIGWAMLIB)"]} {
    set WIGWAMLIB ../lib
} else {
    set WIGWAMLIB [set env(WIGWAMLIB)]
}

lappend auto_path $WIGWAMLIB

set here [pwd]
set demos [glob {*tcl}]

if {![catch "cd $WIGWAMLIB"]} {
    set classes [glob {[A-Z]*tcl}]
    cd $here
} else {
    puts "Unable to access $WIGWAMLIB"
    exit
}

itcl_class FileDisplayer {
    inherit itcl_text

    constructor {args} {
	eval itcl_text::constructor $args
    }

    public file {} {
	if {$file != "" && ![catch {open $file r} fd]} {
	    tk_delete 1.0 end
	    insert end [read $fd]
	    close $fd
	}  
    }
}

proc Select {} {
    global WIGWAMLIB

    if {![winfo exists .fnw]} {
	FileNominatorWindow .fnw -title FileNominator -directory $WIGWAMLIB
	.fnw.nominator configure -select {.display configure -file} \
	                         -cancel {destroy .fnw}
    } else {
	raise .fnw
    }
}

button .quit -text Quit -command exit

menubutton .class -text "Class menu" -menu .class.menu -relief raised
menu .class.menu
foreach class [lsort $classes] {
    regexp "\(.*\)\.tcl" $class {\1} item
    .class.menu add command -label $item \
                         -command ".display configure -file  $WIGWAMLIB/$class"
}

menubutton .demo -text "Demo menu" -menu .demo.menu -relief raised
menu .demo.menu
foreach demo [lsort $demos] {
    regexp "\(.*\)\.tcl" $demo {\1} item
    .demo.menu add command -label $item \
                         -command ".display configure -file $demo"
}

button .fnom -text "File selector" -command Select

Viewport .view {FileDisplayer .display -relief ridge -bd 2 -setgrid true}

pack .view -side bottom -fill both -expand yes -padx 2 -pady 2
pack .quit .class .demo .fnom -side left -padx 2 -pady 2
.class.menu invoke 0

wm minsize . 1 1
