# ----------------------------------------------------------------------
#  PURPOSE:  drag&drop send routine for "wcommand" data (widget command)
#
#  Widgets that are to participate in drag&drop operations for
#  "wcommand" data should be registered as follows:
#
#      blt_drag&drop source .win handler wcommand dd_send_wcommand
#      blt_drag&drop target .win handler wcommand my_wcommand_handler
#
#      proc my_wcommand_handler {} {
#          global DragDrop
#
#          set data $DragDrop(wcommand)
#            .
#            .  do something with $data
#            .
#      }
#
#   AUTHOR:  rf
#
# ======================================================================

# ----------------------------------------------------------------------
# COMMAND: dd_send_wcommand <interp> <ddwin> <data>
#
#   INPUTS
#     <interp> = interpreter for target application
#      <ddwin> = pathname for target drag&drop window
#       <data> = data returned from -tokencmd
#
#   RETURNS
#     ""
#
#   SIDE-EFFECTS
#     Sends data to remote application DragDrop(wcommand), and then
#     invokes the "wcommand" handler for the drag&drop target.
# ----------------------------------------------------------------------
proc dd_send_wcommand {interp ddwin data} {
   send $interp "
#      if {\[info command $data\] == {}} {
#         error \{no widget command \"$data\" \}
#      }
      global DragDrop
      set DragDrop(wcommand) $data
   "
   send $interp "blt_drag&drop target $ddwin handle wcommand"
}
