# tkxpilots Version 2.0pl0 - funky interface to xpilots
# Copyright (C) 1993-1994 Richard Oak.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc set_y num {
        global gravX
        global gravY
        global gravityPoint

        set gravY $num

        set gravityPoint [format "%d,%d" $gravX $gravY]
}

proc set_x num {
        global gravX
        global gravY
        global gravityPoint

        set gravX $num

        set gravityPoint [format "%d,%d" $gravX $gravY]
}

proc set_grav num {
	global gravity

	set_point

	if {$num == 0} {
		.mainpanel.grav.a.point.point.a.h configure -state disabled \
			-foreground gray50
		.mainpanel.grav.a.point.point.a.pic configure -foreground \
			gray50
		.mainpanel.grav.a.point.point.v configure -state disabled \
                        -foreground gray50
		.mainpanel.grav.grav.a.gravity.ang.txt configure -foreground gray50
		.mainpanel.grav.grav.a.gravity.ang.scale configure -state disabled \
                        -foreground gray50
		.mainpanel.grav.grav.a.gravity.pnt configure -state disabled \
                        -foreground gray50
		.mainpanel.grav.grav.a.gravity.clock configure -state disabled \
                        -foreground gray50
		.mainpanel.grav.grav.a.gravity.anti configure -state disabled \
                        -foreground gray50
	} else {
		.mainpanel.grav.a.point.point.a.h configure -state normal \
			-foreground black
		.mainpanel.grav.a.point.point.a.pic configure -foreground \
                        black
		.mainpanel.grav.a.point.point.v configure -state normal \
                        -foreground black
		.mainpanel.grav.grav.a.gravity.pnt configure -state normal \
                        -foreground black
		.mainpanel.grav.grav.a.gravity.clock configure -state normal \
                        -foreground black
		.mainpanel.grav.grav.a.gravity.anti configure -state normal \
                        -foreground black
	}
	set gravity $num
}

proc set_clock {} {
	global gravityClockwise

	if {$gravityClockwise == 1} {
		.mainpanel.grav.grav.a.gravity.anti deselect
	}	
}

proc set_anti {} {
	global gravityAnticlockwise

	if {$gravityAnticlockwise == 1} {
                .mainpanel.grav.grav.a.gravity.clock deselect    
        }
}

proc set_point {} {
	global gravityPointSource

	if {$gravityPointSource == 0} {
		.mainpanel.grav.grav.a.gravity.ang.txt configure -foreground black
                .mainpanel.grav.grav.a.gravity.ang.scale configure -state normal \
                        -foreground black
	} else {
		.mainpanel.grav.grav.a.gravity.ang.txt configure -foreground gray50
                .mainpanel.grav.grav.a.gravity.ang.scale configure -state disabled \
			 -foreground gray50
	}
}

proc set_teams {} {
	global teamPlay

	if {$teamPlay == 1} {
		set fg black
		set state normal
	} else {
		set fg gray50
		set state disabled
	}

	.mainpanel.grav.grav.a.teams.ass configure -state $state -foreground \
		$fg
	.mainpanel.grav.grav.a.teams.imm configure -state $state -foreground \
                $fg
	.mainpanel.grav.grav.a.teams.tarkt configure -state $state -foreground \
                $fg
	.mainpanel.grav.grav.a.teams.tartc configure -state $state -foreground \
                $fg
	.mainpanel.grav.grav.a.teams.trekt configure -state $state -foreground \
                $fg
	.mainpanel.grav.grav.a.teams.trecd configure -state $state -foreground \
                $fg
	.mainpanel.grav.grav.a.teams.treck configure -state $state -foreground \
                $fg
}

proc set_robots num {
	global robotsLeave wantedNumRobots

	set wantedNumRobots $num

	if {$wantedNumRobots == 0} {
		.mainpanel.grav.grav.a.robots.leave configure -state disabled \
			-foreground gray50
		.mainpanel.grav.grav.a.robots.life.txt configure -foreground \
			gray50
		.mainpanel.grav.grav.a.robots.life.scale configure -state disabled \
                        -foreground gray50
		.mainpanel.grav.grav.a.robots.score.txt configure -foreground \
                        gray50
		.mainpanel.grav.grav.a.robots.score.scale configure -state disabled \
                        -foreground gray50
		.mainpanel.grav.grav.a.robots.ratio.txt configure -foreground \
                        gray50
		.mainpanel.grav.grav.a.robots.ratio.scale configure -state disabled \
                        -foreground gray50
	} else {
		.mainpanel.grav.grav.a.robots.leave configure -state normal \
			-foreground black
		if {$robotsLeave == 0} {
		.mainpanel.grav.grav.a.robots.life.txt configure -foreground \
                        gray50
                .mainpanel.grav.grav.a.robots.life.scale configure -state disabled \
                        -foreground gray50
                .mainpanel.grav.grav.a.robots.score.txt configure -foreground \
                        gray50
                .mainpanel.grav.grav.a.robots.score.scale configure -state disabled \
                        -foreground gray50
                .mainpanel.grav.grav.a.robots.ratio.txt configure -foreground \
                        gray50
                .mainpanel.grav.grav.a.robots.ratio.scale configure -state disabled \
                        -foreground gray50
		} else {
		.mainpanel.grav.grav.a.robots.life.txt configure -foreground \
                        black
		.mainpanel.grav.grav.a.robots.life.scale configure -state normal \
			-foreground black
		.mainpanel.grav.grav.a.robots.score.txt configure -foreground \
			black
                .mainpanel.grav.grav.a.robots.score.scale configure -state normal \
                        -foreground black
		.mainpanel.grav.grav.a.robots.ratio.txt configure -foreground \
			black
		.mainpanel.grav.grav.a.robots.ratio.scale configure -state normal \
                        -foreground black
		}

	}
}

proc mk_grav {} {
	global gravity wantedNumRobots robotsLeave robotLeaveLife \
			robotLeaveScore robotLeaveRatio teamPlay teamAssign \
			teamImmunity targetKillTeam targetTeamCollision \
			treasureKillTeam treasureCollisionDestroys \
			treasureCollisionMayKill gravityPoint gravityAngle \
			gravityPointSource gravityClockwise \
			gravityAnticlockwise gravX gravY mapFileName tmp_dir \
			mapHeight mapWidth maptoxbm

	frame .mainpanel.grav.grav.a
	frame .mainpanel.grav.a

	set p .mainpanel.grav.a.point
	set g .mainpanel.grav.grav.a.gravity
	set t .mainpanel.grav.grav.a.teams
	set r .mainpanel.grav.grav.a.robots

	set bm_file $tmp_dir/[file tail $mapFileName].xbm

        if {[file exists $bm_file] == 0} {
                set is_compressed [string first ".gz" $mapFileName]

                if {$is_compressed == -1} {
                        set is_compressed [string first ".z" $mapFileName]
                }
                if {$is_compressed == -1} {
                        set is_compressed [string first ".Z" $mapFileName]
                }

                if {$is_compressed != -1} {
                        set CAT zcat
                } else {
                        set CAT cat
                }

                exec $CAT $mapFileName | $maptoxbm 150 > $bm_file
		exec chmod 666 $bm_file
        }

	scan [exec grep height $bm_file] "#define noname_height %i" bm_height

	frame $p
	frame $p.point
	frame $p.point.a

	label $p.point.label -text "Gravity point"
	scale $p.point.a.h -from 0 -to $mapWidth -bg Bisque1 -relief flat \
		-length 184 -command "set_x" -orient horizontal
	label $p.point.a.pic -bitmap @$bm_file
	
	pack append $p.point.a $p.point.a.pic {top frame center pady 22} \
		$p.point.a.h {top frame center}

	scale $p.point.v -from 0 -to $mapHeight -bg Bisque1 -relief flat \
                -length [expr $bm_height + 34] -command "set_y"
	
	pack append $p.point $p.point.label {top frame center} \
		$p.point.v {left frame n} \
		$p.point.a {top frame center} 

	pack $p.point

	frame $g 
	frame $g.grav
        label $g.grav.txt -text "Gravity Strength (x100)"
        scale $g.grav.scale -orient horizontal -from \-50 -to 50 \
                -command "set_grav" -bg Bisque1 -relief flat -length 200
        pack $g.grav.txt $g.grav.scale -side top

        frame $g.ang
        label $g.ang.txt -text "Gravity Angle"
        scale $g.ang.scale -orient horizontal -from 0 -to 359 -command \
                "set gravityAngle" -bg Bisque1 -relief flat -length 200
        pack $g.ang.txt $g.ang.scale -side top


	checkbutton $g.pnt -text "Gravity from a point" -variable \
                gravityPointSource -anchor w -relief flat -command "set_point"
        checkbutton $g.clock -text "Gravity clockwise" -variable \
                gravityClockwise -anchor w -relief flat -command "set_clock"
        checkbutton $g.anti  -text "Gravity anticlockwise" -variable \
                gravityAnticlockwise  -anchor w -relief flat -command "set_anti"

	pack $g.pnt $g.clock $g.anti $g.grav $g.ang -side top -expand yes \
		-fill x

	frame $r
	frame $r.rob
	label $r.rob.txt -text "Max robots"
	scale $r.rob.scale -orient horizontal -from \-1 -to 10 -command \
		"set_robots" -bg Bisque1 -relief flat -length 200
	pack $r.rob.txt $r.rob.scale -side top

	frame $r.life
	label $r.life.txt -text "Max life for each robot"
	scale $r.life.scale -orient horizontal -from 1 -to 100 -command \
		"set robotLeaveLife" -bg Bisque1 -relief flat -length 200
	pack $r.life.txt $r.life.scale -side top

	frame $r.score
	label $r.score.txt -text "Min score for a robot to play"	
	scale $r.score.scale -orient horizontal -from \-100 -to \-1 -command \
		"set robotLeaveScore" -bg Bisque1 -relief flat -length 200
        pack $r.score.txt $r.score.scale -side top

        frame $r.ratio
	label $r.ratio.txt -text "Min ratio for a robot to play"
	scale $r.ratio.scale -orient horizontal -from \-10 -to 0 -command \
		"set robotLeaveRatio" -bg Bisque1 -relief flat -length 200
        pack $r.ratio.txt $r.ratio.scale  -side top

	checkbutton $r.leave -text "The robots leave" -variable robotsLeave \
		-relief flat -command "set_robots $wantedNumRobots"

	pack $r.rob $r.life $r.score $r.ratio $r.leave -side top

	frame $t
	
	checkbutton $t.play -text "Team play" -variable teamPlay -anchor w \
		-relief flat -command "set_teams"
	checkbutton $t.ass -text "Team assign" -variable teamAssign -anchor w \
		-relief flat
	checkbutton $t.imm -text "Team immunity" -variable teamImmunity \
		-anchor w -relief flat
	checkbutton $t.tarkt -text "Team dies when target explodes" \
		-variable targetKillTeam -anchor w -relief flat
	checkbutton $t.tartc -text "Team members collide with target" \
		-variable targetTeamCollision -anchor w -relief flat
	checkbutton $t.trekt -text "Team dies when treasure explodes" \
		-variable treasureKillTeam -anchor w -relief flat
        checkbutton $t.trecd -text "Destroy balls on collision" -variable \
		treasureCollisionDestroys -anchor w -relief flat
	checkbutton $t.treck -text "Unshielded ball collision kills" \
		-variable treasureCollisionMayKill -anchor w -relief flat

	pack $t.play $t.ass $t.imm $t.tarkt $t.tartc $t.trekt $t.trecd \
		$t.treck -fill both -expand yes -side top

	pack $g $r $t -side left

	pack .mainpanel.grav.grav.a .mainpanel.grav.grav.bounce -side top -fill both \
		-expand yes

	pack $p

	pack .mainpanel.grav.a .mainpanel.grav.grav -side left -fill both \
		-expand yes


	$p.point.a.h set $gravX
	$p.point.v set $gravY
	$g.grav.scale set $gravity
	$g.ang.scale set $gravityAngle
	$r.rob.scale set $wantedNumRobots
	$r.life.scale set $robotLeaveLife
	$r.score.scale set $robotLeaveScore
	$r.ratio.scale set $robotLeaveRatio

	set_teams
}
