/*
 * This is a modified version of the tkMain.c program found in the tknews 3.3
 * distribution.  It has been modified heavily to include many news-related
 * commands in the default interpreter.
 *
 * Author : Michael D. Moore
 * 
 */

#include <tkConfig.h>
#include <tkInt.h>

/*
 * Local include files
 */

#include "newscomm.h"
#include "tcp.h"


/*
 * Global variables used by the main program:
 */

Window busyWindow = -1;           /* This is the overlay window used for
				   * doing a fast watch cursor.
				   */
static Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */

static Tcl_Interp *interp;	/* Interpreter for this application. */
char *tcl_RcFileName = NULL;	/* Name of a user-specific startup script
				 * to source if the application is being run
				 * interactively (e.g. "~/.wishrc").  Set
				 * by Tcl_AppInit.  NULL means don't source
				 * anything ever. */
static Tcl_DString command;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */
static char errorExitCmd[] = "exit 1";

/*
 * Command-line options:
 */

int synchronize = 0;
char *fileName = NULL;
char *name = NULL;
char *display = NULL;
char *geometry = NULL;

Tk_ArgvInfo argTable[] = {
    {"-file", TK_ARGV_STRING, (char *) NULL, (char *) &fileName,
	"File from which to read commands"},
    {"-geometry", TK_ARGV_STRING, (char *) NULL, (char *) &geometry,
	"Initial geometry for window"},
    {"-display", TK_ARGV_STRING, (char *) NULL, (char *) &display,
	"Display to use"},
    {"-name", TK_ARGV_STRING, (char *) NULL, (char *) &name,
	"Name to use for application"},
    {"-sync", TK_ARGV_CONSTANT, (char *) 1, (char *) &synchronize,
	"Use synchronous mode for display server"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

/*
 * The following commands rely on the global variables used in tkMain.c,
 * like mainWindow and busyWindow, and thus cannot be placed in newscomm.h.
 */


/*
 * This tcl command draws a line as indicated in XOR mode.
 */
int
  DrawLineCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  GC gc;
  Window root;
  Screen screen;
  int x1,y1,x2,y2;

  if (argc != 5) {
    Tcl_AppendResult(interp, "Wrong # args: should be \"", argv[0],
		     "xstart ystart xend yend\"", (char *) NULL);
    return TCL_ERROR;
  }
  x1 = strtol(argv[1], (char **) NULL, 0);
  y1 = strtol(argv[2], (char **) NULL, 0);
  x2 = strtol(argv[3], (char **) NULL, 0);
  y2 = strtol(argv[4], (char **) NULL, 0);
  root = RootWindowOfScreen(Tk_Screen(mainWindow));
  gc = DefaultGCOfScreen(Tk_Screen(mainWindow));
  XSetFunction(Tk_Display(mainWindow), gc, GXxor);
  XSetSubwindowMode(Tk_Display(mainWindow), gc, IncludeInferiors);
  XSetForeground(Tk_Display(mainWindow), gc, BlackPixelOfScreen(Tk_Screen(mainWindow)));
  XSetLineAttributes(Tk_Display(mainWindow), gc, 3, LineSolid,
		     CapRound, JoinMiter);
  XDrawLine(Tk_Display(mainWindow), root, 
	    gc, x1, y1, x2, y2);
  return TCL_OK;
}


/*
 * This tcl command sets all of the applications windows' cursors to
 * the state indicated (wait or normal).
 */
int
    SetCursorCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int argc;
char **argv;
{
    int wait_mode;

    if (argc != 2) {
	Tcl_AppendResult(interp, "Wrong # args: should be \"", argv[0],
			 " wait|normal\"", (char *) NULL);
	return TCL_ERROR;
    }
    if (!strcmp(argv[1], "wait")) {
	wait_mode = 1;
    } else {
	wait_mode = 0;
    }
    if (busyWindow == (Window) -1) {
	XSetWindowAttributes attr;
	unsigned long valuemask;

	valuemask = CWDontPropagate | CWCursor;
	attr.do_not_propagate_mask = (ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	attr.cursor = XCreateFontCursor(Tk_Display(mainWindow), XC_watch);
	busyWindow = XCreateWindow(Tk_Display(mainWindow), \
				 Tk_WindowId(mainWindow), 0, 0,
				 3000, 3000, (unsigned int) 0, \
				 CopyFromParent, InputOnly,
				 CopyFromParent, valuemask, &attr);
    }
    if (wait_mode) {
	XMapRaised(Tk_Display(mainWindow), busyWindow);
    } else {
	XUnmapWindow(Tk_Display(mainWindow), busyWindow);
    }
    return TCL_OK;
}


/* This tcl command returns the x and y coordinates of the pointer */
int
  QueryPointerCmd(junk, interp, argc, argv) 
ClientData  junk;
Tcl_Interp  *interp;
int         argc;
char        **argv;
{
  char *ret;
  Window rw,cw;
  int xr,yr,xw,yw;
  unsigned int keys_buttons;

  if (argc != 1) {
    Tcl_AppendResult(interp, "Wrong # args: shouldbe \"", argv[0],
		     (char *) NULL); 
    return TCL_ERROR;
  }
  
  XQueryPointer(Tk_Display(mainWindow), \
		DefaultRootWindow(Tk_Display(mainWindow)), \
		&rw, &cw, &xr, &yr, &xw, &yw, &keys_buttons);
  ret = (char *) malloc(20);
  sprintf(ret, "%d %d", xr, yr);
  interp->result = ret;
  return TCL_OK;
}

/*
 * The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tk library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tk and Tcl with it).
 */

extern int main();
int *tclDummyMainPtr = (int *) main;

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    Tk_Window main;

    main = Tk_MainWindow(interp);

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    tcl_RcFileName = "~/.wishrc";
    return TCL_OK;
}



  
int
main(argc, argv)
    int argc;				/* Number of arguments. */
    char **argv;			/* Array of argument strings. */
{
    char *args, *p, *msg;
    char buf[20];
    int code;
    char *val, *sd;
    char stemp[300];

    interp = Tcl_CreateInterp();
    /*
     * Parse command-line arguments.
     */
    if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
	    != TCL_OK) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }
    if (name == NULL) {
	if (fileName != NULL) {
	    p = fileName;
	} else {
	    p = argv[0];
	}
	name = strrchr(p, '/');
	if (name != NULL) {
	    name++;
	} else {
	    name = p;
	}
    }

    /*
     * If a display was specified, put it into the DISPLAY
     * environment variable so that it will be available for
     * any sub-processes created by us.
     */

    if (display != NULL) {
	Tcl_SetVar2(interp, "env", "DISPLAY", display, TCL_GLOBAL_ONLY);
    }

    /*
     * Initialize the Tk application.
     */

    mainWindow = Tk_CreateMainWindow(interp, display, "tknews", "Tknews");
    if (mainWindow == NULL) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }
    Tk_SetClass(mainWindow, "Tk");
    if (synchronize) {
	XSynchronize(Tk_Display(mainWindow), True);
    }
    Tk_GeometryRequest(mainWindow, 200, 200);

    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".  Also set the "geometry" variable from the geometry
     * specified on the command line.
     */

    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", (fileName != NULL) ? fileName : argv[0],
	    TCL_GLOBAL_ONLY);
    if (geometry != NULL) {
	Tcl_SetVar(interp, "geometry", geometry, TCL_GLOBAL_ONLY);
    }

    /*
     * Set the "tcl_interactive" variable.
     */

    tty = isatty(0);

    Tcl_SetVar(interp, "tcl_interactive",
	    ((fileName == NULL) && tty) ? "1" : "0", TCL_GLOBAL_ONLY);

    /* 
     * Here is where the tknews special commands are added to the 
     * interp.
     */
    Tcl_CreateCommand(interp, "Strftime", StrftimeCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "RandNum", RandNumCmd,
		    (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "QueryPointer", QueryPointerCmd,
		      (ClientData) 0, (void (*)()) NULL); 
    Tcl_CreateCommand(interp, "SetCursor", SetCursorCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "DrawLine", DrawLineCmd,
		      (ClientData) 0, (void (*) ()) NULL);
    Tcl_CreateCommand(interp, "GetArticleList", GetArticleListCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "Connect", Tcp_ConnectCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "LoadActiveList", LoadActiveListCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "InverseRange", InverseRangeCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "SaveNewsrc", SaveNewsrcCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "LoadNewsrc", LoadNewsrcCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "FileGetLine", FileGetLineCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "GetFile", GetFileCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "Lisort", Tcl_LisortCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "GetHostname", GetHostnameCmd,
		      (ClientData) 0, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "FileReplaceLine", FileReplaceLineCmd,
		      (ClientData) 0, (void (*)()) NULL);
    /* 
     * Now check and see if the environment variables TKNEWS_LIB_DIR
     * and TKNEWS_SCRIPT_DIR are set.  If they are, use them instead
     * of the predefined values.  Set the 'sd' variable to store the
     * value for the script dir, and is freed later.
     */
    val = (char *) getenv("TKNEWS_SCRIPT_DIR");
    if (val != (char *) NULL) {
      strcpy(stemp, val);
      Tcl_SetVar(interp, "SCRIPT_DIR", stemp, TCL_GLOBAL_ONLY);
      sd = (char *) malloc(strlen(stemp)+1);
      strcpy(sd,stemp);
    } else {
      Tcl_SetVar(interp, "SCRIPT_DIR", SCRIPT_DIR, TCL_GLOBAL_ONLY);
      sd = (char *) malloc(strlen(SCRIPT_DIR)+1);
      strcpy(sd, SCRIPT_DIR);
    }
    val = (char *) getenv("TKNEWS_LIB_DIR");
    if (val != (char *) NULL) {
      strcpy(stemp, val);
      Tcl_SetVar(interp, "LIBRARY_DIR", stemp, TCL_GLOBAL_ONLY);
    } else {
      Tcl_SetVar(interp, "LIBRARY_DIR", LIBRARY_DIR, TCL_GLOBAL_ONLY);
    }
    /*
     * Invoke application-specific initialization.
     */
    if (Tcl_AppInit(interp) != TCL_OK) {
	fprintf(stderr, "Tcl_AppInit failed: %s\n", interp->result);
    }

    /*
     * Set the geometry of the main window, if requested.
     */

    if (geometry != NULL) {
	code = Tcl_VarEval(interp, "wm geometry . ", geometry, (char *) NULL);
	if (code != TCL_OK) {
	    fprintf(stderr, "%s\n", interp->result);
	}
    }

    /*
     * Invoke tknews by first sourcing config.t and then sourcing tknews.t
     */
    code = Tcl_VarEval(interp, "source ", sd, "/config.t", \
		       (char *) NULL);
    if (code != TCL_OK) {
      goto error;
    }
    code = Tcl_VarEval(interp, "source ", sd, "/tknews.t", \
		       (char *) NULL);
    if (code != TCL_OK) {
      goto error;
    }
    /*
     * Free sd variable since we are through with it.
     */
    free(sd);
    Tcl_DStringInit(&command);

    /*
     * Loop infinitely, waiting for commands to execute.  When there
     * are no windows left, Tk_MainLoop returns and we exit.
     */

    Tk_MainLoop();

    /*
     * Don't exit directly, but rather invoke the Tcl "exit" command.
     * This gives the application the opportunity to redefine "exit"
     * to do additional cleanup.
     */

    Tcl_Eval(interp, "exit");
    exit(1);

error:
    msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
	msg = interp->result;
    }
    fprintf(stderr, "%s\n", msg);
    Tcl_Eval(interp, errorExitCmd);
    return 1;			/* Needed only to prevent compiler warnings. */
}
